/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.account.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.time.LocalDate;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.api.DateParam;
import org.apache.fineract.infrastructure.core.data.DateFormat;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.security.service.SqlValidator;
import org.apache.fineract.portfolio.account.api.StandingInstructionHistoryApiResourceSwagger;
import org.apache.fineract.portfolio.account.data.StandingInstructionDTO;
import org.apache.fineract.portfolio.account.data.StandingInstructionHistoryData;
import org.apache.fineract.portfolio.account.service.StandingInstructionHistoryReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/standinginstructionrunhistory")
@Component
@Tag(name="Standing Instructions History", description="The list capability of history can support pagination and sorting.")
public class StandingInstructionHistoryApiResource {
    private final PlatformSecurityContext context;
    private final DefaultToApiJsonSerializer<StandingInstructionHistoryData> toApiJsonSerializer;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final StandingInstructionHistoryReadPlatformService standingInstructionHistoryReadPlatformService;
    private final SqlValidator sqlValidator;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Standing Instructions Logged History", description="The list capability of history can support pagination and sorting \n\nExample Requests :\n\nstandinginstructionrunhistory\n\nstandinginstructionrunhistory?orderBy=name&sortOrder=DESC\n\nstandinginstructionrunhistory?offset=10&limit=50")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=StandingInstructionHistoryApiResourceSwagger.GetStandingInstructionRunHistoryResponse.class))})})
    public String retrieveAll(@Context UriInfo uriInfo, @QueryParam(value="externalId") @Parameter(description="externalId") String externalId, @QueryParam(value="offset") @Parameter(description="offset") Integer offset, @QueryParam(value="limit") @Parameter(description="limit") Integer limit, @QueryParam(value="orderBy") @Parameter(description="orderBy") String orderBy, @QueryParam(value="sortOrder") @Parameter(description="sortOrder") String sortOrder, @QueryParam(value="transferType") @Parameter(description="transferType") Integer transferType, @QueryParam(value="clientName") @Parameter(description="clientName") String clientName, @QueryParam(value="clientId") @Parameter(description="clientId") Long clientId, @QueryParam(value="fromAccountId") @Parameter(description="fromAccountId") Long fromAccount, @QueryParam(value="fromAccountType") @Parameter(description="fromAccountType") Integer fromAccountType, @QueryParam(value="locale") @Parameter(description="locale") String locale, @QueryParam(value="dateFormat") @Parameter(description="dateFormat") String rawDateFormat, @QueryParam(value="fromDate") @Parameter(description="fromDate") DateParam fromDateParam, @QueryParam(value="toDate") @Parameter(description="toDate") DateParam toDateParam) {
        this.context.authenticatedUser().validateHasReadPermission("standinginstruction");
        DateFormat dateFormat = StringUtils.isBlank((CharSequence)rawDateFormat) ? null : new DateFormat(rawDateFormat);
        this.sqlValidator.validate(orderBy);
        this.sqlValidator.validate(sortOrder);
        this.sqlValidator.validate(externalId);
        SearchParameters searchParameters = SearchParameters.builder().limit(limit).externalId(externalId).offset(offset).orderBy(orderBy).sortOrder(sortOrder).build();
        LocalDate startDateRange = null;
        LocalDate endDateRange = null;
        if (fromDateParam != null) {
            startDateRange = fromDateParam.getDate("fromDate", dateFormat, locale);
        }
        if (toDateParam != null) {
            endDateRange = toDateParam.getDate("toDate", dateFormat, locale);
        }
        StandingInstructionDTO standingInstructionDTO = new StandingInstructionDTO(searchParameters, transferType, clientName, clientId, fromAccount, fromAccountType, startDateRange, endDateRange);
        Page history = this.standingInstructionHistoryReadPlatformService.retrieveAll(standingInstructionDTO);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, history);
    }

    @Generated
    public StandingInstructionHistoryApiResource(PlatformSecurityContext context, DefaultToApiJsonSerializer<StandingInstructionHistoryData> toApiJsonSerializer, ApiRequestParameterHelper apiRequestParameterHelper, StandingInstructionHistoryReadPlatformService standingInstructionHistoryReadPlatformService, SqlValidator sqlValidator) {
        this.context = context;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.standingInstructionHistoryReadPlatformService = standingInstructionHistoryReadPlatformService;
        this.sqlValidator = sqlValidator;
    }
}

