/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.organisation.staff.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.exception.UnrecognizedQueryParamException;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.security.utils.SQLBuilder;
import org.apache.fineract.organisation.staff.data.StaffData;
import org.apache.fineract.organisation.staff.exception.StaffNotFoundException;
import org.apache.fineract.organisation.staff.service.StaffReadPlatformService;
import org.apache.fineract.organisation.staff.service.StaffReadPlatformServiceImpl;
import org.apache.fineract.portfolio.client.domain.ClientStatus;
import org.apache.fineract.portfolio.loanaccount.domain.LoanStatus;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountStatusType;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class StaffReadPlatformServiceImpl
implements StaffReadPlatformService {
    private final PlatformSecurityContext context;
    private final JdbcTemplate jdbcTemplate;
    private static final StaffLookupMapper LOOKUP_MAPPER = new StaffLookupMapper();
    private static final StaffInOfficeHierarchyMapper STAFF_IN_OFFICE_HIERARCHY_MAPPER = new StaffInOfficeHierarchyMapper();

    public Collection<StaffData> retrieveAllLoanOfficersInOfficeById(Long officeId) {
        SQLBuilder extraCriteria = new SQLBuilder();
        extraCriteria.addCriteria(" office_id = ", (Object)officeId);
        extraCriteria.addCriteria(" is_loan_officer = ", (Object)true);
        return this.retrieveAllStaff(extraCriteria);
    }

    public Collection<StaffData> retrieveAllStaffForDropdown(Long officeId) {
        String hierarchy = this.context.authenticatedUser().getOffice().getHierarchy() + "%";
        Long defaultOfficeId = this.defaultToUsersOfficeIfNull(officeId);
        String sql = "select " + LOOKUP_MAPPER.schema() + " where s.office_id = ? and s.is_active=true and o.hierarchy like ? ";
        return this.jdbcTemplate.query(sql, (RowMapper)LOOKUP_MAPPER, new Object[]{defaultOfficeId, hierarchy});
    }

    private Long defaultToUsersOfficeIfNull(Long officeId) {
        Long defaultOfficeId = officeId;
        if (defaultOfficeId == null) {
            defaultOfficeId = (Long)this.context.authenticatedUser().getOffice().getId();
        }
        return defaultOfficeId;
    }

    public StaffData retrieveStaff(Long staffId) {
        String hierarchy = this.context.authenticatedUser().getOffice().getHierarchy() + "%";
        try {
            StaffMapper rm = new StaffMapper();
            String sql = "select " + rm.schema() + " where s.id = ? and o.hierarchy like ? ";
            return (StaffData)this.jdbcTemplate.queryForObject(sql, (RowMapper)rm, new Object[]{staffId, hierarchy});
        }
        catch (EmptyResultDataAccessException e) {
            throw new StaffNotFoundException(staffId, e);
        }
    }

    public Collection<StaffData> retrieveAllStaff(Long officeId, boolean loanOfficersOnly, String status) {
        SQLBuilder extraCriteria = this.getStaffCriteria(officeId, loanOfficersOnly, status);
        return this.retrieveAllStaff(extraCriteria);
    }

    private Collection<StaffData> retrieveAllStaff(SQLBuilder extraCriteria) {
        StaffMapper rm = new StaffMapper();
        String sql = "select " + rm.schema();
        String hierarchy = this.context.authenticatedUser().getOffice().getHierarchy() + "%";
        extraCriteria.addCriteria(" o.hierarchy like ", (Object)hierarchy);
        sql = sql + " " + extraCriteria.getSQLTemplate();
        sql = sql + " order by s.lastname ";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, extraCriteria.getArguments());
    }

    private SQLBuilder getStaffCriteria(Long officeId, boolean loanOfficersOnly, String status) {
        SQLBuilder extraCriteria = new SQLBuilder();
        extraCriteria.addNonNullCriteria(" s.office_id = ", (Object)officeId);
        if (loanOfficersOnly) {
            extraCriteria.addCriteria(" s.is_loan_officer = ", (Object)true);
        }
        if (status != null) {
            if (status.equalsIgnoreCase("active")) {
                extraCriteria.addCriteria(" s.is_active =", (Object)true);
            } else if (status.equalsIgnoreCase("inActive")) {
                extraCriteria.addCriteria(" s.is_active =", (Object)false);
            } else if (!status.equalsIgnoreCase("all")) {
                throw new UnrecognizedQueryParamException("status", status, new Object[]{"all", "active", "inactive"});
            }
        }
        return extraCriteria;
    }

    public Collection<StaffData> retrieveAllStaffInOfficeAndItsParentOfficeHierarchy(Long officeId, boolean loanOfficersOnly) {
        String sql = "select " + STAFF_IN_OFFICE_HIERARCHY_MAPPER.schema(loanOfficersOnly);
        sql = sql + " order by s.lastname";
        return this.jdbcTemplate.query(sql, (RowMapper)STAFF_IN_OFFICE_HIERARCHY_MAPPER, new Object[]{officeId});
    }

    public Object[] hasAssociatedItems(Long staffId) {
        ArrayList<String> params = new ArrayList<String>();
        String sql = "select c.display_name as client, g.display_name as grp,l.loan_officer_id as loan, s.field_officer_id as sav from m_staff staff  left outer join m_client c on staff.id = c.staff_id  AND c.status_enum < ?  left outer join m_group g on staff.id = g.staff_id  left outer join m_loan l on staff.id = l.loan_officer_id and l.loan_status_id < ?  left outer join m_savings_account s on c.staff_id = s.field_officer_id and s.status_enum < ?  where  staff.id  = ?  group by staff.id, client, grp, loan, sav";
        List result = this.jdbcTemplate.queryForList(sql, new Object[]{ClientStatus.CLOSED.getValue(), LoanStatus.WITHDRAWN_BY_CLIENT.getValue(), SavingsAccountStatusType.WITHDRAWN_BY_APPLICANT.getValue(), staffId});
        if (result != null) {
            for (Map map : result) {
                if (map.get("client") != null) {
                    params.add("client");
                }
                if (map.get("grp") != null) {
                    params.add("group");
                }
                if (map.get("loan") != null) {
                    params.add("loan");
                }
                if (map.get("sav") == null) continue;
                params.add("savings account");
            }
        }
        return params.toArray();
    }

    @Generated
    public StaffReadPlatformServiceImpl(PlatformSecurityContext context, JdbcTemplate jdbcTemplate) {
        this.context = context;
        this.jdbcTemplate = jdbcTemplate;
    }
}

