/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.organisation.provisioning.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import org.apache.fineract.accounting.glaccount.domain.GLAccount;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.organisation.provisioning.domain.ProvisioningCategory;
import org.apache.fineract.organisation.provisioning.domain.ProvisioningCriteria;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="m_provisioning_criteria_definition")
public class ProvisioningCriteriaDefinition
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @ManyToOne(optional=false)
    @JoinColumn(name="criteria_id", referencedColumnName="id", nullable=false)
    private ProvisioningCriteria criteria;
    @ManyToOne
    @JoinColumn(name="category_id", nullable=false)
    private ProvisioningCategory provisioningCategory;
    @Column(name="min_age", nullable=false)
    private Long minimumAge;
    @Column(name="max_age", nullable=false)
    private Long maximumAge;
    @Column(name="provision_percentage", nullable=false)
    private BigDecimal provisioningPercentage;
    @ManyToOne
    @JoinColumn(name="liability_account", nullable=false)
    private GLAccount liabilityAccount;
    @ManyToOne
    @JoinColumn(name="expense_account", nullable=false)
    private GLAccount expenseAccount;
    static final long serialVersionUID = -4166373129564246790L;

    protected ProvisioningCriteriaDefinition() {
    }

    private ProvisioningCriteriaDefinition(ProvisioningCriteria criteria, ProvisioningCategory provisioningCategory, Long minimumAge, Long maximumAge, BigDecimal provisioningPercentage, GLAccount liabilityAccount, GLAccount expenseAccount) {
        this.criteria = criteria;
        this.provisioningCategory = provisioningCategory;
        this.minimumAge = minimumAge;
        this.maximumAge = maximumAge;
        this.provisioningPercentage = provisioningPercentage;
        this.liabilityAccount = liabilityAccount;
        this.expenseAccount = expenseAccount;
    }

    public static ProvisioningCriteriaDefinition newPrivisioningCriteria(ProvisioningCriteria criteria, ProvisioningCategory provisioningCategory, Long minimumAge, Long maximumAge, BigDecimal provisioningPercentage, GLAccount liabilityAccount, GLAccount expenseAccount) {
        return new ProvisioningCriteriaDefinition(criteria, provisioningCategory, minimumAge, maximumAge, provisioningPercentage, liabilityAccount, expenseAccount);
    }

    public void update(Long minAge, Long maxAge, BigDecimal percentage, GLAccount lia, GLAccount exp) {
        this._persistence_set_minimumAge(minAge);
        this._persistence_set_maximumAge(maxAge);
        this._persistence_set_provisioningPercentage(percentage);
        this._persistence_set_liabilityAccount(lia);
        this._persistence_set_expenseAccount(exp);
    }

    public boolean isOverlapping(ProvisioningCriteriaDefinition def) {
        return this._persistence_get_minimumAge() <= def._persistence_get_maximumAge() && def._persistence_get_minimumAge() <= this._persistence_get_maximumAge();
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ProvisioningCriteriaDefinition();
    }

    public Object _persistence_get(String string) {
        if (string == "provisioningPercentage") {
            return this.provisioningPercentage;
        }
        if (string == "criteria") {
            return this.criteria;
        }
        if (string == "provisioningCategory") {
            return this.provisioningCategory;
        }
        if (string == "minimumAge") {
            return this.minimumAge;
        }
        if (string == "expenseAccount") {
            return this.expenseAccount;
        }
        if (string == "maximumAge") {
            return this.maximumAge;
        }
        if (string == "liabilityAccount") {
            return this.liabilityAccount;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "provisioningPercentage") {
            this.provisioningPercentage = (BigDecimal)object;
            return;
        }
        if (string == "criteria") {
            this.criteria = (ProvisioningCriteria)object;
            return;
        }
        if (string == "provisioningCategory") {
            this.provisioningCategory = (ProvisioningCategory)object;
            return;
        }
        if (string == "minimumAge") {
            this.minimumAge = (Long)object;
            return;
        }
        if (string == "expenseAccount") {
            this.expenseAccount = (GLAccount)object;
            return;
        }
        if (string == "maximumAge") {
            this.maximumAge = (Long)object;
            return;
        }
        if (string == "liabilityAccount") {
            this.liabilityAccount = (GLAccount)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public BigDecimal _persistence_get_provisioningPercentage() {
        this._persistence_checkFetched("provisioningPercentage");
        return this.provisioningPercentage;
    }

    public void _persistence_set_provisioningPercentage(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("provisioningPercentage");
        this._persistence_propertyChange("provisioningPercentage", (Object)this.provisioningPercentage, (Object)bigDecimal);
        this.provisioningPercentage = bigDecimal;
    }

    public ProvisioningCriteria _persistence_get_criteria() {
        this._persistence_checkFetched("criteria");
        return this.criteria;
    }

    public void _persistence_set_criteria(ProvisioningCriteria provisioningCriteria) {
        this._persistence_checkFetchedForSet("criteria");
        this._persistence_propertyChange("criteria", (Object)this.criteria, (Object)provisioningCriteria);
        this.criteria = provisioningCriteria;
    }

    public ProvisioningCategory _persistence_get_provisioningCategory() {
        this._persistence_checkFetched("provisioningCategory");
        return this.provisioningCategory;
    }

    public void _persistence_set_provisioningCategory(ProvisioningCategory provisioningCategory) {
        this._persistence_checkFetchedForSet("provisioningCategory");
        this._persistence_propertyChange("provisioningCategory", (Object)this.provisioningCategory, (Object)provisioningCategory);
        this.provisioningCategory = provisioningCategory;
    }

    public Long _persistence_get_minimumAge() {
        this._persistence_checkFetched("minimumAge");
        return this.minimumAge;
    }

    public void _persistence_set_minimumAge(Long l) {
        this._persistence_checkFetchedForSet("minimumAge");
        this._persistence_propertyChange("minimumAge", (Object)this.minimumAge, (Object)l);
        this.minimumAge = l;
    }

    public GLAccount _persistence_get_expenseAccount() {
        this._persistence_checkFetched("expenseAccount");
        return this.expenseAccount;
    }

    public void _persistence_set_expenseAccount(GLAccount gLAccount) {
        this._persistence_checkFetchedForSet("expenseAccount");
        this._persistence_propertyChange("expenseAccount", (Object)this.expenseAccount, (Object)gLAccount);
        this.expenseAccount = gLAccount;
    }

    public Long _persistence_get_maximumAge() {
        this._persistence_checkFetched("maximumAge");
        return this.maximumAge;
    }

    public void _persistence_set_maximumAge(Long l) {
        this._persistence_checkFetchedForSet("maximumAge");
        this._persistence_propertyChange("maximumAge", (Object)this.maximumAge, (Object)l);
        this.maximumAge = l;
    }

    public GLAccount _persistence_get_liabilityAccount() {
        this._persistence_checkFetched("liabilityAccount");
        return this.liabilityAccount;
    }

    public void _persistence_set_liabilityAccount(GLAccount gLAccount) {
        this._persistence_checkFetchedForSet("liabilityAccount");
        this._persistence_propertyChange("liabilityAccount", (Object)this.liabilityAccount, (Object)gLAccount);
        this.liabilityAccount = gLAccount;
    }
}

