/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.organisation.provisioning.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.organisation.provisioning.api.ProvisioningCriteriaApiResourceSwagger;
import org.apache.fineract.organisation.provisioning.data.ProvisioningCriteriaData;
import org.apache.fineract.organisation.provisioning.service.ProvisioningCriteriaReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/provisioningcriteria")
@Component
@Tag(name="Provisioning Criteria", description="This defines the Provisioning Criteria")
public class ProvisioningCriteriaApiResource {
    private final PlatformSecurityContext platformSecurityContext;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final ProvisioningCriteriaReadPlatformService provisioningCriteriaReadPlatformService;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final DefaultToApiJsonSerializer<ProvisioningCriteriaData> toApiJsonSerializer;
    private static final Set<String> PROVISIONING_CRITERIA_TEMPLATE_PARAMETER = new HashSet<String>(Arrays.asList("definitions", "loanProducts", "glAccounts"));
    private static final Set<String> PROVISIONING_CRITERIA_PARAMETERS = new HashSet<String>(Arrays.asList("criteriaName", "loanProducts", "definitions"));
    private static final Set<String> ALL_PROVISIONING_CRITERIA_PARAMETERS = new HashSet<String>(Arrays.asList("criteriaId", "criterianame", "createdby"));

    @GET
    @Path(value="template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String retrieveTemplate(@Context UriInfo uriInfo) {
        this.platformSecurityContext.authenticatedUser();
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        ProvisioningCriteriaData data = this.provisioningCriteriaReadPlatformService.retrievePrivisiongCriteriaTemplate();
        return this.toApiJsonSerializer.serialize(settings, (Object)data, PROVISIONING_CRITERIA_TEMPLATE_PARAMETER);
    }

    @GET
    @Path(value="{criteriaId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieves a Provisioning Criteria", description="Retrieves a Provisioning Criteria")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ProvisioningCriteriaApiResourceSwagger.GetProvisioningCriteriaCriteriaIdResponse.class))})})
    public String retrieveProvisioningCriteria(@PathParam(value="criteriaId") @Parameter(description="criteriaId") Long criteriaId, @Context UriInfo uriInfo) {
        this.platformSecurityContext.authenticatedUser();
        ProvisioningCriteriaData criteria = this.provisioningCriteriaReadPlatformService.retrieveProvisioningCriteria(criteriaId);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        if (settings.isTemplate()) {
            criteria = this.provisioningCriteriaReadPlatformService.retrievePrivisiongCriteriaTemplate(criteria);
        }
        return this.toApiJsonSerializer.serialize(settings, (Object)criteria, PROVISIONING_CRITERIA_PARAMETERS);
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieves all created Provisioning Criterias", description="Retrieves all created Provisioning Criterias")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ProvisioningCriteriaApiResourceSwagger.GetProvisioningCriteriaResponse.class)))})})
    public String retrieveAllProvisioningCriterias(@Context UriInfo uriInfo) {
        this.platformSecurityContext.authenticatedUser();
        Collection data = this.provisioningCriteriaReadPlatformService.retrieveAllProvisioningCriterias();
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, data, ALL_PROVISIONING_CRITERIA_PARAMETERS);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a new Provisioning Criteria", description="Creates a new Provisioning Criteria\n\nMandatory Fields: \ncriteriaName\nprovisioningcriteria\n\nOptional Fields: \nloanProducts")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=ProvisioningCriteriaApiResourceSwagger.PostProvisioningCriteriaRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ProvisioningCriteriaApiResourceSwagger.PostProvisioningCriteriaResponse.class))})})
    public String createProvisioningCriteria(@Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandWrapper = null;
        this.platformSecurityContext.authenticatedUser();
        commandWrapper = new CommandWrapperBuilder().createProvisioningCriteria().withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult commandProcessingResult = this.commandsSourceWritePlatformService.logCommandSource(commandWrapper);
        return this.toApiJsonSerializer.serialize((Object)commandProcessingResult);
    }

    @PUT
    @Path(value="{criteriaId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Updates a new Provisioning Criteria", description="Updates a new Provisioning Criteria\n\nOptional Fields\ncriteriaName, loanProducts, provisioningcriteria")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=ProvisioningCriteriaApiResourceSwagger.PutProvisioningCriteriaRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ProvisioningCriteriaApiResourceSwagger.PutProvisioningCriteriaResponse.class))})})
    public String updateProvisioningCriteria(@PathParam(value="criteriaId") @Parameter(description="criteriaId") Long criteriaId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        this.platformSecurityContext.authenticatedUser();
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateProvisioningCriteria(criteriaId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @DELETE
    @Path(value="{criteriaId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Deletes Provisioning Criteria", description="Deletes Provisioning Criteria")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ProvisioningCriteriaApiResourceSwagger.DeleteProvisioningCriteriaResponse.class))})})
    public String deleteProvisioningCriteria(@PathParam(value="criteriaId") @Parameter(description="criteriaId") Long criteriaId) {
        this.platformSecurityContext.authenticatedUser();
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteProvisioningCriteria(criteriaId).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @Generated
    public ProvisioningCriteriaApiResource(PlatformSecurityContext platformSecurityContext, ApiRequestParameterHelper apiRequestParameterHelper, ProvisioningCriteriaReadPlatformService provisioningCriteriaReadPlatformService, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, DefaultToApiJsonSerializer<ProvisioningCriteriaData> toApiJsonSerializer) {
        this.platformSecurityContext = platformSecurityContext;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.provisioningCriteriaReadPlatformService = provisioningCriteriaReadPlatformService;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
    }
}

