/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.organisation.office.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.xml.bind.annotation.XmlTransient;
import java.math.BigDecimal;
import java.time.LocalDate;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.organisation.office.domain.Office;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Table(name="m_office_transaction")
public class OfficeTransaction
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="from_office_id")
    private Office from;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="to_office_id")
    private Office to;
    @Column(name="transaction_date", nullable=false)
    private LocalDate transactionDate;
    @Embedded
    private MonetaryCurrency currency;
    @Column(name="transaction_amount", scale=6, precision=19, nullable=false)
    private BigDecimal transactionAmount;
    @Column(name="description", nullable=true, length=100)
    private String description;
    static final long serialVersionUID = -2970046292591661722L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_from_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_to_vh;

    public static OfficeTransaction fromJson(Office fromOffice, Office toOffice, Money amount, JsonCommand command) {
        LocalDate transactionLocalDate = command.localDateValueOfParameterNamed("transactionDate");
        String description = command.stringValueOfParameterNamed("description");
        return new OfficeTransaction(fromOffice, toOffice, transactionLocalDate, amount, description);
    }

    protected OfficeTransaction() {
        this.transactionDate = null;
    }

    private OfficeTransaction(Office fromOffice, Office toOffice, LocalDate transactionLocalDate, Money amount, String description) {
        this.from = fromOffice;
        this.to = toOffice;
        if (transactionLocalDate != null) {
            this.transactionDate = transactionLocalDate;
        }
        this.currency = amount.getCurrency();
        this.transactionAmount = amount.getAmount();
        this.description = description;
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_from_vh != null) {
            this._persistence_from_vh = (WeavedAttributeValueHolderInterface)this._persistence_from_vh.clone();
        }
        if (this._persistence_to_vh != null) {
            this._persistence_to_vh = (WeavedAttributeValueHolderInterface)this._persistence_to_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new OfficeTransaction();
    }

    public Object _persistence_get(String string) {
        if (string == "transactionAmount") {
            return this.transactionAmount;
        }
        if (string == "description") {
            return this.description;
        }
        if (string == "from") {
            return this.from;
        }
        if (string == "currency") {
            return this.currency;
        }
        if (string == "to") {
            return this.to;
        }
        if (string == "transactionDate") {
            return this.transactionDate;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "transactionAmount") {
            this.transactionAmount = (BigDecimal)object;
            return;
        }
        if (string == "description") {
            this.description = (String)object;
            return;
        }
        if (string == "from") {
            this.from = (Office)object;
            return;
        }
        if (string == "currency") {
            this.currency = (MonetaryCurrency)object;
            return;
        }
        if (string == "to") {
            this.to = (Office)object;
            return;
        }
        if (string == "transactionDate") {
            this.transactionDate = (LocalDate)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public BigDecimal _persistence_get_transactionAmount() {
        this._persistence_checkFetched("transactionAmount");
        return this.transactionAmount;
    }

    public void _persistence_set_transactionAmount(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("transactionAmount");
        this._persistence_propertyChange("transactionAmount", (Object)this.transactionAmount, (Object)bigDecimal);
        this.transactionAmount = bigDecimal;
    }

    public String _persistence_get_description() {
        this._persistence_checkFetched("description");
        return this.description;
    }

    public void _persistence_set_description(String string) {
        this._persistence_checkFetchedForSet("description");
        this._persistence_propertyChange("description", (Object)this.description, (Object)string);
        this.description = string;
    }

    protected void _persistence_initialize_from_vh() {
        if (this._persistence_from_vh == null) {
            this._persistence_from_vh = new ValueHolder((Object)this.from);
            this._persistence_from_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_from_vh() {
        Office office;
        this._persistence_initialize_from_vh();
        if ((this._persistence_from_vh.isCoordinatedWithProperty() || this._persistence_from_vh.isNewlyWeavedValueHolder()) && (office = this._persistence_get_from()) != this._persistence_from_vh.getValue()) {
            this._persistence_set_from(office);
        }
        return this._persistence_from_vh;
    }

    public void _persistence_set_from_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_from_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Office office = this._persistence_get_from();
            if (office != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_from((Office)object);
            }
        } else {
            this.from = null;
        }
    }

    public Office _persistence_get_from() {
        this._persistence_checkFetched("from");
        this._persistence_initialize_from_vh();
        this.from = (Office)this._persistence_from_vh.getValue();
        return this.from;
    }

    public void _persistence_set_from(Office office) {
        this._persistence_checkFetchedForSet("from");
        this._persistence_initialize_from_vh();
        this.from = (Office)this._persistence_from_vh.getValue();
        this._persistence_propertyChange("from", (Object)this.from, (Object)office);
        this.from = office;
        this._persistence_from_vh.setValue((Object)office);
    }

    public MonetaryCurrency _persistence_get_currency() {
        this._persistence_checkFetched("currency");
        return this.currency;
    }

    public void _persistence_set_currency(MonetaryCurrency monetaryCurrency) {
        this._persistence_checkFetchedForSet("currency");
        this._persistence_propertyChange("currency", (Object)this.currency, (Object)monetaryCurrency);
        this.currency = monetaryCurrency;
    }

    protected void _persistence_initialize_to_vh() {
        if (this._persistence_to_vh == null) {
            this._persistence_to_vh = new ValueHolder((Object)this.to);
            this._persistence_to_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_to_vh() {
        Office office;
        this._persistence_initialize_to_vh();
        if ((this._persistence_to_vh.isCoordinatedWithProperty() || this._persistence_to_vh.isNewlyWeavedValueHolder()) && (office = this._persistence_get_to()) != this._persistence_to_vh.getValue()) {
            this._persistence_set_to(office);
        }
        return this._persistence_to_vh;
    }

    public void _persistence_set_to_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_to_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Office office = this._persistence_get_to();
            if (office != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_to((Office)object);
            }
        } else {
            this.to = null;
        }
    }

    public Office _persistence_get_to() {
        this._persistence_checkFetched("to");
        this._persistence_initialize_to_vh();
        this.to = (Office)this._persistence_to_vh.getValue();
        return this.to;
    }

    public void _persistence_set_to(Office office) {
        this._persistence_checkFetchedForSet("to");
        this._persistence_initialize_to_vh();
        this.to = (Office)this._persistence_to_vh.getValue();
        this._persistence_propertyChange("to", (Object)this.to, (Object)office);
        this.to = office;
        this._persistence_to_vh.setValue((Object)office);
    }

    public LocalDate _persistence_get_transactionDate() {
        this._persistence_checkFetched("transactionDate");
        return this.transactionDate;
    }

    public void _persistence_set_transactionDate(LocalDate localDate) {
        this._persistence_checkFetchedForSet("transactionDate");
        this._persistence_propertyChange("transactionDate", (Object)this.transactionDate, (Object)localDate);
        this.transactionDate = localDate;
    }
}

