/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.organisation.monetary.service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.organisation.monetary.domain.ApplicationCurrency;
import org.apache.fineract.organisation.monetary.domain.ApplicationCurrencyRepositoryWrapper;
import org.apache.fineract.organisation.monetary.domain.OrganisationCurrency;
import org.apache.fineract.organisation.monetary.domain.OrganisationCurrencyRepository;
import org.apache.fineract.organisation.monetary.exception.CurrencyInUseException;
import org.apache.fineract.organisation.monetary.serialization.CurrencyCommandFromApiJsonDeserializer;
import org.apache.fineract.organisation.monetary.service.CurrencyWritePlatformService;
import org.apache.fineract.portfolio.charge.service.ChargeReadPlatformService;
import org.apache.fineract.portfolio.loanproduct.service.LoanProductReadPlatformService;
import org.apache.fineract.portfolio.savings.service.SavingsProductReadPlatformService;
import org.springframework.transaction.annotation.Transactional;

public class CurrencyWritePlatformServiceJpaRepositoryImpl
implements CurrencyWritePlatformService {
    private final PlatformSecurityContext context;
    private final ApplicationCurrencyRepositoryWrapper applicationCurrencyRepository;
    private final OrganisationCurrencyRepository organisationCurrencyRepository;
    private final CurrencyCommandFromApiJsonDeserializer fromApiJsonDeserializer;
    private final LoanProductReadPlatformService loanProductService;
    private final SavingsProductReadPlatformService savingsProductService;
    private final ChargeReadPlatformService chargeService;

    @Transactional
    public CommandProcessingResult updateAllowedCurrencies(JsonCommand command) {
        this.context.authenticatedUser();
        this.fromApiJsonDeserializer.validateForUpdate(command.json());
        String[] currencies = command.arrayValueOfParameterNamed("currencies");
        LinkedHashMap<String, String[]> changes = new LinkedHashMap<String, String[]>();
        ArrayList<String> allowedCurrencyCodes = new ArrayList<String>();
        HashSet<OrganisationCurrency> allowedCurrencies = new HashSet<OrganisationCurrency>();
        for (String currencyCode : currencies) {
            ApplicationCurrency currency = this.applicationCurrencyRepository.findOneWithNotFoundDetection(currencyCode);
            OrganisationCurrency allowedCurrency = currency.toOrganisationCurrency();
            allowedCurrencyCodes.add(currencyCode);
            allowedCurrencies.add(allowedCurrency);
        }
        for (OrganisationCurrency priorCurrency : this.organisationCurrencyRepository.findAll()) {
            if (allowedCurrencyCodes.contains(priorCurrency.getCode()) || this.loanProductService.retrieveAllLoanProductsForCurrency(priorCurrency.getCode()).isEmpty() && this.savingsProductService.retrieveAllForCurrency(priorCurrency.getCode()).isEmpty() && this.chargeService.retrieveAllChargesForCurrency(priorCurrency.getCode()).isEmpty()) continue;
            throw new CurrencyInUseException(priorCurrency.getCode());
        }
        changes.put("currencies", allowedCurrencyCodes.toArray(new String[allowedCurrencyCodes.size()]));
        this.organisationCurrencyRepository.deleteAll();
        this.organisationCurrencyRepository.saveAll(allowedCurrencies);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).with(changes).build();
    }

    @Generated
    public CurrencyWritePlatformServiceJpaRepositoryImpl(PlatformSecurityContext context, ApplicationCurrencyRepositoryWrapper applicationCurrencyRepository, OrganisationCurrencyRepository organisationCurrencyRepository, CurrencyCommandFromApiJsonDeserializer fromApiJsonDeserializer, LoanProductReadPlatformService loanProductService, SavingsProductReadPlatformService savingsProductService, ChargeReadPlatformService chargeService) {
        this.context = context;
        this.applicationCurrencyRepository = applicationCurrencyRepository;
        this.organisationCurrencyRepository = organisationCurrencyRepository;
        this.fromApiJsonDeserializer = fromApiJsonDeserializer;
        this.loanProductService = loanProductService;
        this.savingsProductService = savingsProductService;
        this.chargeService = chargeService;
    }
}

