/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.organisation.holiday.domain;

import java.time.LocalDate;
import java.util.List;
import org.apache.fineract.organisation.holiday.domain.Holiday;
import org.apache.fineract.organisation.holiday.domain.HolidayRepository;
import org.apache.fineract.organisation.holiday.domain.HolidayStatusType;
import org.apache.fineract.organisation.holiday.exception.HolidayNotFoundException;
import org.apache.fineract.organisation.holiday.service.HolidayUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HolidayRepositoryWrapper {
    private final HolidayRepository repository;

    @Autowired
    public HolidayRepositoryWrapper(HolidayRepository repository) {
        this.repository = repository;
    }

    public Holiday findOneWithNotFoundDetection(Long id) {
        return (Holiday)this.repository.findById((Object)id).orElseThrow(() -> new HolidayNotFoundException(id));
    }

    public void save(Holiday holiday) {
        this.repository.save((Object)holiday);
    }

    public void save(Iterable<Holiday> holidays) {
        this.repository.saveAll(holidays);
    }

    public void saveAndFlush(Holiday holiday) {
        this.repository.saveAndFlush((Object)holiday);
    }

    public void delete(Holiday holiday) {
        this.repository.delete((Object)holiday);
    }

    public List<Holiday> findByOfficeIdAndGreaterThanDate(Long officeId, LocalDate date) {
        return this.repository.findByOfficeIdAndGreaterThanDate(officeId, date, HolidayStatusType.ACTIVE.getValue());
    }

    public List<Holiday> findUnprocessed() {
        return this.repository.findUnprocessed(HolidayStatusType.ACTIVE.getValue());
    }

    public boolean isHoliday(Long officeId, LocalDate transactionDate) {
        List holidays = this.findByOfficeIdAndGreaterThanDate(officeId, transactionDate);
        return HolidayUtil.isHoliday((LocalDate)transactionDate, (List)holidays);
    }
}

