/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.mix.api;

import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.ToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.mix.data.MixTaxonomyData;
import org.apache.fineract.mix.service.MixTaxonomyReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/mixtaxonomy")
@Component
@Tag(name="Mix Taxonomy", description="")
public class MixTaxonomyApiResource {
    private static final Set<String> RESPONSE_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("taxonomyId", "name", "namespace", "dimension", "description"));
    private final PlatformSecurityContext context;
    private final ToApiJsonSerializer<MixTaxonomyData> toApiJsonSerializer;
    private final MixTaxonomyReadPlatformService readTaxonomyService;
    private final ApiRequestParameterHelper apiRequestParameterHelper;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String retrieveAll(@Context UriInfo uriInfo) {
        this.context.authenticatedUser();
        List taxonomyDatas = this.readTaxonomyService.retrieveAll();
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Collection)taxonomyDatas, RESPONSE_DATA_PARAMETERS);
    }

    @Generated
    public MixTaxonomyApiResource(PlatformSecurityContext context, ToApiJsonSerializer<MixTaxonomyData> toApiJsonSerializer, MixTaxonomyReadPlatformService readTaxonomyService, ApiRequestParameterHelper apiRequestParameterHelper) {
        this.context = context;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.readTaxonomyService = readTaxonomyService;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
    }
}

