/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.sms.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.campaigns.sms.domain.SmsCampaign;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.sms.domain.SmsMessageStatusType;
import org.apache.fineract.organisation.staff.domain.Staff;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.group.domain.Group;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="sms_messages_outbound")
public class SmsMessage
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @Column(name="external_id")
    private String externalId;
    @ManyToOne
    @JoinColumn(name="group_id")
    private Group group;
    @ManyToOne
    @JoinColumn(name="client_id")
    private Client client;
    @ManyToOne
    @JoinColumn(name="staff_id")
    private Staff staff;
    @ManyToOne
    @JoinColumn(name="campaign_id")
    private SmsCampaign smsCampaign;
    @Column(name="status_enum", nullable=false)
    private Integer statusType;
    @Column(name="mobile_no", length=50)
    private String mobileNo;
    @Column(name="message", nullable=false)
    private String message;
    @Column(name="submittedon_date")
    private LocalDate submittedOnDate;
    @Column(name="delivered_on_date")
    private LocalDateTime deliveredOnDate;
    @Column(name="is_notification")
    private boolean isNotification;
    static final long serialVersionUID = 5797185240765351514L;

    public static SmsMessage pendingSms(String externalId, Group group, Client client, Staff staff, String message, String mobileNo, SmsCampaign smsCampaign, boolean isNotification) {
        return new SmsMessage().setExternalId(externalId).setGroup(group).setClient(client).setStaff(staff).setStatusType(SmsMessageStatusType.PENDING.getValue()).setMessage(message).setMobileNo(mobileNo).setSmsCampaign(smsCampaign).setNotification(isNotification).setSubmittedOnDate(DateUtils.getBusinessLocalDate());
    }

    public static SmsMessage sentSms(String externalId, Group group, Client client, Staff staff, String message, String mobileNo, SmsCampaign smsCampaign, boolean isNotification) {
        return new SmsMessage().setExternalId(externalId).setGroup(group).setClient(client).setStaff(staff).setStatusType(SmsMessageStatusType.WAITING_FOR_DELIVERY_REPORT.getValue()).setMessage(message).setMobileNo(mobileNo).setSmsCampaign(smsCampaign).setNotification(isNotification).setSubmittedOnDate(DateUtils.getBusinessLocalDate());
    }

    public static SmsMessage instance(String externalId, Group group, Client client, Staff staff, SmsMessageStatusType statusType, String message, String mobileNo, SmsCampaign smsCampaign, boolean isNotification) {
        return new SmsMessage().setExternalId(externalId).setGroup(group).setClient(client).setStaff(staff).setStatusType(statusType.getValue()).setMessage(message).setMobileNo(mobileNo).setSmsCampaign(smsCampaign).setNotification(isNotification).setSubmittedOnDate(DateUtils.getBusinessLocalDate());
    }

    public Map<String, Object> update(JsonCommand command) {
        LinkedHashMap<String, Object> actualChanges = new LinkedHashMap<String, Object>(1);
        if (command.isChangeInStringParameterNamed("message", this._persistence_get_message())) {
            String newValue = command.stringValueOfParameterNamed("message");
            actualChanges.put("message", newValue);
            this._persistence_set_message((String)StringUtils.defaultIfEmpty((CharSequence)newValue, null));
        }
        return actualChanges;
    }

    @Generated
    public String getExternalId() {
        return this._persistence_get_externalId();
    }

    @Generated
    public Group getGroup() {
        return this._persistence_get_group();
    }

    @Generated
    public Client getClient() {
        return this._persistence_get_client();
    }

    @Generated
    public Staff getStaff() {
        return this._persistence_get_staff();
    }

    @Generated
    public SmsCampaign getSmsCampaign() {
        return this._persistence_get_smsCampaign();
    }

    @Generated
    public Integer getStatusType() {
        return this._persistence_get_statusType();
    }

    @Generated
    public String getMobileNo() {
        return this._persistence_get_mobileNo();
    }

    @Generated
    public String getMessage() {
        return this._persistence_get_message();
    }

    @Generated
    public LocalDate getSubmittedOnDate() {
        return this._persistence_get_submittedOnDate();
    }

    @Generated
    public LocalDateTime getDeliveredOnDate() {
        return this._persistence_get_deliveredOnDate();
    }

    @Generated
    public boolean isNotification() {
        return this._persistence_get_isNotification();
    }

    @Generated
    public SmsMessage setExternalId(String externalId) {
        this._persistence_set_externalId(externalId);
        return this;
    }

    @Generated
    public SmsMessage setGroup(Group group) {
        this._persistence_set_group(group);
        return this;
    }

    @Generated
    public SmsMessage setClient(Client client) {
        this._persistence_set_client(client);
        return this;
    }

    @Generated
    public SmsMessage setStaff(Staff staff) {
        this._persistence_set_staff(staff);
        return this;
    }

    @Generated
    public SmsMessage setSmsCampaign(SmsCampaign smsCampaign) {
        this._persistence_set_smsCampaign(smsCampaign);
        return this;
    }

    @Generated
    public SmsMessage setStatusType(Integer statusType) {
        this._persistence_set_statusType(statusType);
        return this;
    }

    @Generated
    public SmsMessage setMobileNo(String mobileNo) {
        this._persistence_set_mobileNo(mobileNo);
        return this;
    }

    @Generated
    public SmsMessage setMessage(String message) {
        this._persistence_set_message(message);
        return this;
    }

    @Generated
    public SmsMessage setSubmittedOnDate(LocalDate submittedOnDate) {
        this._persistence_set_submittedOnDate(submittedOnDate);
        return this;
    }

    @Generated
    public SmsMessage setDeliveredOnDate(LocalDateTime deliveredOnDate) {
        this._persistence_set_deliveredOnDate(deliveredOnDate);
        return this;
    }

    @Generated
    public SmsMessage setNotification(boolean isNotification) {
        this._persistence_set_isNotification(isNotification);
        return this;
    }

    @Generated
    public SmsMessage() {
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new SmsMessage();
    }

    public Object _persistence_get(String string) {
        if (string == "statusType") {
            return this.statusType;
        }
        if (string == "externalId") {
            return this.externalId;
        }
        if (string == "client") {
            return this.client;
        }
        if (string == "staff") {
            return this.staff;
        }
        if (string == "mobileNo") {
            return this.mobileNo;
        }
        if (string == "submittedOnDate") {
            return this.submittedOnDate;
        }
        if (string == "deliveredOnDate") {
            return this.deliveredOnDate;
        }
        if (string == "smsCampaign") {
            return this.smsCampaign;
        }
        if (string == "message") {
            return this.message;
        }
        if (string == "isNotification") {
            return this.isNotification;
        }
        if (string == "group") {
            return this.group;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "statusType") {
            this.statusType = (Integer)object;
            return;
        }
        if (string == "externalId") {
            this.externalId = (String)object;
            return;
        }
        if (string == "client") {
            this.client = (Client)object;
            return;
        }
        if (string == "staff") {
            this.staff = (Staff)object;
            return;
        }
        if (string == "mobileNo") {
            this.mobileNo = (String)object;
            return;
        }
        if (string == "submittedOnDate") {
            this.submittedOnDate = (LocalDate)object;
            return;
        }
        if (string == "deliveredOnDate") {
            this.deliveredOnDate = (LocalDateTime)object;
            return;
        }
        if (string == "smsCampaign") {
            this.smsCampaign = (SmsCampaign)object;
            return;
        }
        if (string == "message") {
            this.message = (String)object;
            return;
        }
        if (string == "isNotification") {
            this.isNotification = (Boolean)object;
            return;
        }
        if (string == "group") {
            this.group = (Group)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Integer _persistence_get_statusType() {
        this._persistence_checkFetched("statusType");
        return this.statusType;
    }

    public void _persistence_set_statusType(Integer n) {
        this._persistence_checkFetchedForSet("statusType");
        this._persistence_propertyChange("statusType", (Object)this.statusType, (Object)n);
        this.statusType = n;
    }

    public String _persistence_get_externalId() {
        this._persistence_checkFetched("externalId");
        return this.externalId;
    }

    public void _persistence_set_externalId(String string) {
        this._persistence_checkFetchedForSet("externalId");
        this._persistence_propertyChange("externalId", (Object)this.externalId, (Object)string);
        this.externalId = string;
    }

    public Client _persistence_get_client() {
        this._persistence_checkFetched("client");
        return this.client;
    }

    public void _persistence_set_client(Client client) {
        this._persistence_checkFetchedForSet("client");
        this._persistence_propertyChange("client", (Object)this.client, (Object)client);
        this.client = client;
    }

    public Staff _persistence_get_staff() {
        this._persistence_checkFetched("staff");
        return this.staff;
    }

    public void _persistence_set_staff(Staff staff) {
        this._persistence_checkFetchedForSet("staff");
        this._persistence_propertyChange("staff", (Object)this.staff, (Object)staff);
        this.staff = staff;
    }

    public String _persistence_get_mobileNo() {
        this._persistence_checkFetched("mobileNo");
        return this.mobileNo;
    }

    public void _persistence_set_mobileNo(String string) {
        this._persistence_checkFetchedForSet("mobileNo");
        this._persistence_propertyChange("mobileNo", (Object)this.mobileNo, (Object)string);
        this.mobileNo = string;
    }

    public LocalDate _persistence_get_submittedOnDate() {
        this._persistence_checkFetched("submittedOnDate");
        return this.submittedOnDate;
    }

    public void _persistence_set_submittedOnDate(LocalDate localDate) {
        this._persistence_checkFetchedForSet("submittedOnDate");
        this._persistence_propertyChange("submittedOnDate", (Object)this.submittedOnDate, (Object)localDate);
        this.submittedOnDate = localDate;
    }

    public LocalDateTime _persistence_get_deliveredOnDate() {
        this._persistence_checkFetched("deliveredOnDate");
        return this.deliveredOnDate;
    }

    public void _persistence_set_deliveredOnDate(LocalDateTime localDateTime) {
        this._persistence_checkFetchedForSet("deliveredOnDate");
        this._persistence_propertyChange("deliveredOnDate", (Object)this.deliveredOnDate, (Object)localDateTime);
        this.deliveredOnDate = localDateTime;
    }

    public SmsCampaign _persistence_get_smsCampaign() {
        this._persistence_checkFetched("smsCampaign");
        return this.smsCampaign;
    }

    public void _persistence_set_smsCampaign(SmsCampaign smsCampaign) {
        this._persistence_checkFetchedForSet("smsCampaign");
        this._persistence_propertyChange("smsCampaign", (Object)this.smsCampaign, (Object)smsCampaign);
        this.smsCampaign = smsCampaign;
    }

    public String _persistence_get_message() {
        this._persistence_checkFetched("message");
        return this.message;
    }

    public void _persistence_set_message(String string) {
        this._persistence_checkFetchedForSet("message");
        this._persistence_propertyChange("message", (Object)this.message, (Object)string);
        this.message = string;
    }

    public boolean _persistence_get_isNotification() {
        this._persistence_checkFetched("isNotification");
        return this.isNotification;
    }

    public void _persistence_set_isNotification(boolean bl) {
        this._persistence_checkFetchedForSet("isNotification");
        this._persistence_propertyChange("isNotification", (Object)new Boolean(this.isNotification), (Object)new Boolean(bl));
        this.isNotification = bl;
    }

    public Group _persistence_get_group() {
        this._persistence_checkFetched("group");
        return this.group;
    }

    public void _persistence_set_group(Group group) {
        this._persistence_checkFetchedForSet("group");
        this._persistence_propertyChange("group", (Object)this.group, (Object)group);
        this.group = group;
    }
}

