/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.security.service;

import org.apache.fineract.infrastructure.security.domain.PlatformUser;
import org.apache.fineract.infrastructure.security.domain.PlatformUserRepository;
import org.apache.fineract.infrastructure.security.service.PlatformUserDetailsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.dao.DataAccessException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service(value="userDetailsService")
public class TenantAwareJpaPlatformUserDetailsService
implements PlatformUserDetailsService {
    @Autowired
    private PlatformUserRepository platformUserRepository;

    @Cacheable(value={"usersByUsername"}, key="T(org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil).getTenant().getTenantIdentifier().concat(#username+'ubu')")
    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        boolean deleted = false;
        boolean enabled = true;
        PlatformUser appUser = this.platformUserRepository.findByUsernameAndDeletedAndEnabled(username, false, true);
        if (appUser == null) {
            throw new UsernameNotFoundException(username + ": not found");
        }
        return appUser;
    }
}

