/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.security.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.ArrayList;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.data.EnumOptionData;
import org.apache.fineract.infrastructure.core.serialization.ToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.api.UserDetailsApiResourceSwagger;
import org.apache.fineract.infrastructure.security.data.AuthenticatedOauthUserData;
import org.apache.fineract.infrastructure.security.data.FineractJwtAuthenticationToken;
import org.apache.fineract.infrastructure.security.service.SpringSecurityPlatformSecurityContext;
import org.apache.fineract.useradministration.data.RoleData;
import org.apache.fineract.useradministration.domain.AppUser;
import org.apache.fineract.useradministration.domain.Role;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.stereotype.Component;

@Path(value="/v1/userdetails")
@Component
@ConditionalOnProperty(value={"fineract.security.oauth.enabled"})
@Tag(name="Fetch authenticated user details", description="")
public class UserDetailsApiResource {
    private final ToApiJsonSerializer<AuthenticatedOauthUserData> apiJsonSerializerService;
    private final SpringSecurityPlatformSecurityContext springSecurityPlatformSecurityContext;
    @Value(value="${fineract.security.2fa.enabled}")
    private boolean twoFactorEnabled;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Fetch authenticated user details\n", description="checks the Authentication and returns the set roles and permissions allowed.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=UserDetailsApiResourceSwagger.GetUserDetailsResponse.class))})})
    public String fetchAuthenticatedUserData() {
        SecurityContext context = SecurityContextHolder.getContext();
        if (context == null) {
            return null;
        }
        FineractJwtAuthenticationToken authentication = (FineractJwtAuthenticationToken)context.getAuthentication();
        if (authentication == null) {
            return null;
        }
        AppUser principal = (AppUser)authentication.getPrincipal();
        if (principal == null) {
            return null;
        }
        ArrayList<String> permissions = new ArrayList<String>();
        AuthenticatedOauthUserData authenticatedUserData = new AuthenticatedOauthUserData().setUsername(principal.getUsername()).setPermissions(permissions);
        ArrayList authorities = new ArrayList(authentication.getAuthorities());
        for (GrantedAuthority grantedAuthority : authorities) {
            permissions.add(grantedAuthority.getAuthority());
        }
        ArrayList<RoleData> roles = new ArrayList<RoleData>();
        Set userRoles = principal.getRoles();
        for (Role role : userRoles) {
            roles.add(role.toData());
        }
        Long officeId = (Long)principal.getOffice().getId();
        String officeName = principal.getOffice().getName();
        Long staffId = principal.getStaffId();
        String staffDisplayName = principal.getStaffDisplayName();
        EnumOptionData organisationalRole = principal.organisationalRoleData();
        boolean isTwoFactorRequired = this.twoFactorEnabled && !principal.hasSpecificPermissionTo("BYPASS_TWOFACTOR");
        authenticatedUserData = this.springSecurityPlatformSecurityContext.doesPasswordHasToBeRenewed(principal) ? new AuthenticatedOauthUserData().setUsername(principal.getUsername()).setUserId((Long)principal.getId()).setAccessToken(((Jwt)authentication.getToken()).getTokenValue()).setAuthenticated(true).setShouldRenewPassword(true).setTwoFactorAuthenticationRequired(isTwoFactorRequired) : new AuthenticatedOauthUserData().setUsername(principal.getUsername()).setOfficeId(officeId).setOfficeName(officeName).setStaffId(staffId).setStaffDisplayName(staffDisplayName).setOrganisationalRole(organisationalRole).setRoles(roles).setPermissions(permissions).setUserId((Long)principal.getId()).setAccessToken(((Jwt)authentication.getToken()).getTokenValue()).setAuthenticated(true).setTwoFactorAuthenticationRequired(isTwoFactorRequired);
        return this.apiJsonSerializerService.serialize((Object)authenticatedUserData);
    }

    @Generated
    public UserDetailsApiResource(ToApiJsonSerializer<AuthenticatedOauthUserData> apiJsonSerializerService, SpringSecurityPlatformSecurityContext springSecurityPlatformSecurityContext) {
        this.apiJsonSerializerService = apiJsonSerializerService;
        this.springSecurityPlatformSecurityContext = springSecurityPlatformSecurityContext;
    }
}

