/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.jobs.service;

import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.businessdate.service.BusinessDateReadPlatformService;
import org.apache.fineract.infrastructure.core.domain.ActionContext;
import org.apache.fineract.infrastructure.core.domain.FineractPlatformTenant;
import org.apache.fineract.infrastructure.core.service.JdbcTemplateFactory;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.infrastructure.core.service.tenant.TenantDetailsService;
import org.apache.fineract.infrastructure.jobs.domain.JobExecutionRepository;
import org.apache.fineract.infrastructure.jobs.service.StuckJobExecutorService;
import org.apache.fineract.useradministration.domain.AppUser;
import org.apache.fineract.useradministration.domain.AppUserRepositoryWrapper;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(value={"fineract.mode.batch-manager-enabled"}, havingValue="true")
public class StuckJobListener
implements ApplicationListener<ContextRefreshedEvent> {
    private final JobExecutionRepository jobExecutionRepository;
    private final JdbcTemplateFactory jdbcTemplateFactory;
    private final TenantDetailsService tenantDetailsService;
    private final JobRegistry jobRegistry;
    private final BusinessDateReadPlatformService businessDateReadPlatformService;
    private final StuckJobExecutorService stuckJobExecutorService;
    private final AppUserRepositoryWrapper userRepository;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (!this.jobRegistry.getJobNames().isEmpty()) {
            List allTenants = this.tenantDetailsService.findAllTenants();
            allTenants.forEach(tenant -> {
                ThreadLocalContextUtil.setTenant((FineractPlatformTenant)tenant);
                NamedParameterJdbcTemplate namedParameterJdbcTemplate = this.jdbcTemplateFactory.createNamedParameterJdbcTemplate(tenant);
                List stuckJobNames = this.jobExecutionRepository.getStuckJobNames(namedParameterJdbcTemplate);
                if (!stuckJobNames.isEmpty()) {
                    try {
                        HashMap businessDates = this.businessDateReadPlatformService.getBusinessDates();
                        ThreadLocalContextUtil.setActionContext((ActionContext)ActionContext.DEFAULT);
                        ThreadLocalContextUtil.setBusinessDates((HashMap)businessDates);
                        AppUser user = this.userRepository.fetchSystemUser();
                        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)user, (Object)user.getPassword(), user.getAuthorities());
                        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
                        stuckJobNames.forEach(arg_0 -> ((StuckJobExecutorService)this.stuckJobExecutorService).resumeStuckJob(arg_0));
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error while trying to restart stuck jobs", e);
                    }
                    finally {
                        ThreadLocalContextUtil.reset();
                    }
                }
            });
        }
    }

    @Generated
    public StuckJobListener(JobExecutionRepository jobExecutionRepository, JdbcTemplateFactory jdbcTemplateFactory, TenantDetailsService tenantDetailsService, JobRegistry jobRegistry, BusinessDateReadPlatformService businessDateReadPlatformService, StuckJobExecutorService stuckJobExecutorService, AppUserRepositoryWrapper userRepository) {
        this.jobExecutionRepository = jobExecutionRepository;
        this.jdbcTemplateFactory = jdbcTemplateFactory;
        this.tenantDetailsService = tenantDetailsService;
        this.jobRegistry = jobRegistry;
        this.businessDateReadPlatformService = businessDateReadPlatformService;
        this.stuckJobExecutorService = stuckJobExecutorService;
        this.userRepository = userRepository;
    }
}

