/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.jobs.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.UniqueConstraint;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="job", uniqueConstraints={@UniqueConstraint(columnNames={"short_name"}, name="job_short_name_key")})
public class ScheduledJobDetail
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @Column(name="name")
    private String jobName;
    @Column(name="display_name")
    private String jobDisplayName;
    @Column(name="node_id")
    private Integer nodeId;
    @Column(name="is_mismatched_job")
    private boolean isMismatchedJob;
    @Column(name="cron_expression")
    private String cronExpression;
    @Column(name="create_time")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createTime;
    @Column(name="task_priority")
    private Short taskPriority;
    @Column(name="group_name")
    private String groupName;
    @Column(name="previous_run_start_time")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date previousRunStartTime;
    @Column(name="next_run_time")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date nextRunTime;
    @Column(name="job_key")
    private String jobKey;
    @Column(name="initializing_errorlog")
    private String errorLog;
    @Column(name="is_active")
    private boolean activeSchedular;
    @Column(name="currently_running")
    private boolean currentlyRunning;
    @Column(name="updates_allowed")
    private boolean updatesAllowed;
    @Column(name="scheduler_group")
    private Short schedulerGroup;
    @Column(name="is_misfired")
    private boolean triggerMisfired;
    @Column(name="short_name", nullable=false)
    private String shortName;
    static final long serialVersionUID = -8104219045467790261L;

    public Map<String, Object> update(JsonCommand command) {
        String newValue;
        LinkedHashMap<String, Object> actualChanges = new LinkedHashMap<String, Object>(9);
        if (command.isChangeInStringParameterNamed("displayName", this._persistence_get_jobDisplayName())) {
            newValue = command.stringValueOfParameterNamed("displayName").trim();
            actualChanges.put("displayName", newValue);
            this._persistence_set_jobDisplayName((String)StringUtils.defaultIfEmpty((CharSequence)newValue, null));
        }
        if (command.isChangeInStringParameterNamed("cronExpression", this._persistence_get_cronExpression())) {
            newValue = command.stringValueOfParameterNamed("cronExpression").trim();
            actualChanges.put("cronExpression", newValue);
            this._persistence_set_cronExpression((String)StringUtils.defaultIfEmpty((CharSequence)newValue, null));
        }
        if (command.isChangeInBooleanParameterNamed("active", Boolean.valueOf(this._persistence_get_activeSchedular()))) {
            boolean newValue2 = command.booleanPrimitiveValueOfParameterNamed("active");
            actualChanges.put("active", newValue2);
            this._persistence_set_activeSchedular(newValue2);
        }
        return actualChanges;
    }

    @Generated
    public String getJobName() {
        return this._persistence_get_jobName();
    }

    @Generated
    public String getJobDisplayName() {
        return this._persistence_get_jobDisplayName();
    }

    @Generated
    public Integer getNodeId() {
        return this._persistence_get_nodeId();
    }

    @Generated
    public boolean isMismatchedJob() {
        return this._persistence_get_isMismatchedJob();
    }

    @Generated
    public String getCronExpression() {
        return this._persistence_get_cronExpression();
    }

    @Generated
    public Date getCreateTime() {
        return this._persistence_get_createTime();
    }

    @Generated
    public Short getTaskPriority() {
        return this._persistence_get_taskPriority();
    }

    @Generated
    public String getGroupName() {
        return this._persistence_get_groupName();
    }

    @Generated
    public Date getPreviousRunStartTime() {
        return this._persistence_get_previousRunStartTime();
    }

    @Generated
    public Date getNextRunTime() {
        return this._persistence_get_nextRunTime();
    }

    @Generated
    public String getJobKey() {
        return this._persistence_get_jobKey();
    }

    @Generated
    public String getErrorLog() {
        return this._persistence_get_errorLog();
    }

    @Generated
    public boolean isActiveSchedular() {
        return this._persistence_get_activeSchedular();
    }

    @Generated
    public boolean isCurrentlyRunning() {
        return this._persistence_get_currentlyRunning();
    }

    @Generated
    public boolean isUpdatesAllowed() {
        return this._persistence_get_updatesAllowed();
    }

    @Generated
    public Short getSchedulerGroup() {
        return this._persistence_get_schedulerGroup();
    }

    @Generated
    public boolean isTriggerMisfired() {
        return this._persistence_get_triggerMisfired();
    }

    @Generated
    public String getShortName() {
        return this._persistence_get_shortName();
    }

    @Generated
    public ScheduledJobDetail setJobName(String jobName) {
        this._persistence_set_jobName(jobName);
        return this;
    }

    @Generated
    public ScheduledJobDetail setJobDisplayName(String jobDisplayName) {
        this._persistence_set_jobDisplayName(jobDisplayName);
        return this;
    }

    @Generated
    public ScheduledJobDetail setNodeId(Integer nodeId) {
        this._persistence_set_nodeId(nodeId);
        return this;
    }

    @Generated
    public ScheduledJobDetail setMismatchedJob(boolean isMismatchedJob) {
        this._persistence_set_isMismatchedJob(isMismatchedJob);
        return this;
    }

    @Generated
    public ScheduledJobDetail setCronExpression(String cronExpression) {
        this._persistence_set_cronExpression(cronExpression);
        return this;
    }

    @Generated
    public ScheduledJobDetail setCreateTime(Date createTime) {
        this._persistence_set_createTime(createTime);
        return this;
    }

    @Generated
    public ScheduledJobDetail setTaskPriority(Short taskPriority) {
        this._persistence_set_taskPriority(taskPriority);
        return this;
    }

    @Generated
    public ScheduledJobDetail setGroupName(String groupName) {
        this._persistence_set_groupName(groupName);
        return this;
    }

    @Generated
    public ScheduledJobDetail setPreviousRunStartTime(Date previousRunStartTime) {
        this._persistence_set_previousRunStartTime(previousRunStartTime);
        return this;
    }

    @Generated
    public ScheduledJobDetail setNextRunTime(Date nextRunTime) {
        this._persistence_set_nextRunTime(nextRunTime);
        return this;
    }

    @Generated
    public ScheduledJobDetail setJobKey(String jobKey) {
        this._persistence_set_jobKey(jobKey);
        return this;
    }

    @Generated
    public ScheduledJobDetail setErrorLog(String errorLog) {
        this._persistence_set_errorLog(errorLog);
        return this;
    }

    @Generated
    public ScheduledJobDetail setActiveSchedular(boolean activeSchedular) {
        this._persistence_set_activeSchedular(activeSchedular);
        return this;
    }

    @Generated
    public ScheduledJobDetail setCurrentlyRunning(boolean currentlyRunning) {
        this._persistence_set_currentlyRunning(currentlyRunning);
        return this;
    }

    @Generated
    public ScheduledJobDetail setUpdatesAllowed(boolean updatesAllowed) {
        this._persistence_set_updatesAllowed(updatesAllowed);
        return this;
    }

    @Generated
    public ScheduledJobDetail setSchedulerGroup(Short schedulerGroup) {
        this._persistence_set_schedulerGroup(schedulerGroup);
        return this;
    }

    @Generated
    public ScheduledJobDetail setTriggerMisfired(boolean triggerMisfired) {
        this._persistence_set_triggerMisfired(triggerMisfired);
        return this;
    }

    @Generated
    public ScheduledJobDetail setShortName(String shortName) {
        this._persistence_set_shortName(shortName);
        return this;
    }

    @Generated
    public ScheduledJobDetail() {
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ScheduledJobDetail();
    }

    public Object _persistence_get(String string) {
        if (string == "jobName") {
            return this.jobName;
        }
        if (string == "schedulerGroup") {
            return this.schedulerGroup;
        }
        if (string == "previousRunStartTime") {
            return this.previousRunStartTime;
        }
        if (string == "taskPriority") {
            return this.taskPriority;
        }
        if (string == "jobKey") {
            return this.jobKey;
        }
        if (string == "errorLog") {
            return this.errorLog;
        }
        if (string == "jobDisplayName") {
            return this.jobDisplayName;
        }
        if (string == "updatesAllowed") {
            return this.updatesAllowed;
        }
        if (string == "cronExpression") {
            return this.cronExpression;
        }
        if (string == "groupName") {
            return this.groupName;
        }
        if (string == "nextRunTime") {
            return this.nextRunTime;
        }
        if (string == "createTime") {
            return this.createTime;
        }
        if (string == "isMismatchedJob") {
            return this.isMismatchedJob;
        }
        if (string == "activeSchedular") {
            return this.activeSchedular;
        }
        if (string == "triggerMisfired") {
            return this.triggerMisfired;
        }
        if (string == "shortName") {
            return this.shortName;
        }
        if (string == "nodeId") {
            return this.nodeId;
        }
        if (string == "currentlyRunning") {
            return this.currentlyRunning;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "jobName") {
            this.jobName = (String)object;
            return;
        }
        if (string == "schedulerGroup") {
            this.schedulerGroup = (Short)object;
            return;
        }
        if (string == "previousRunStartTime") {
            this.previousRunStartTime = (Date)object;
            return;
        }
        if (string == "taskPriority") {
            this.taskPriority = (Short)object;
            return;
        }
        if (string == "jobKey") {
            this.jobKey = (String)object;
            return;
        }
        if (string == "errorLog") {
            this.errorLog = (String)object;
            return;
        }
        if (string == "jobDisplayName") {
            this.jobDisplayName = (String)object;
            return;
        }
        if (string == "updatesAllowed") {
            this.updatesAllowed = (Boolean)object;
            return;
        }
        if (string == "cronExpression") {
            this.cronExpression = (String)object;
            return;
        }
        if (string == "groupName") {
            this.groupName = (String)object;
            return;
        }
        if (string == "nextRunTime") {
            this.nextRunTime = (Date)object;
            return;
        }
        if (string == "createTime") {
            this.createTime = (Date)object;
            return;
        }
        if (string == "isMismatchedJob") {
            this.isMismatchedJob = (Boolean)object;
            return;
        }
        if (string == "activeSchedular") {
            this.activeSchedular = (Boolean)object;
            return;
        }
        if (string == "triggerMisfired") {
            this.triggerMisfired = (Boolean)object;
            return;
        }
        if (string == "shortName") {
            this.shortName = (String)object;
            return;
        }
        if (string == "nodeId") {
            this.nodeId = (Integer)object;
            return;
        }
        if (string == "currentlyRunning") {
            this.currentlyRunning = (Boolean)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_jobName() {
        this._persistence_checkFetched("jobName");
        return this.jobName;
    }

    public void _persistence_set_jobName(String string) {
        this._persistence_checkFetchedForSet("jobName");
        this._persistence_propertyChange("jobName", (Object)this.jobName, (Object)string);
        this.jobName = string;
    }

    public Short _persistence_get_schedulerGroup() {
        this._persistence_checkFetched("schedulerGroup");
        return this.schedulerGroup;
    }

    public void _persistence_set_schedulerGroup(Short s) {
        this._persistence_checkFetchedForSet("schedulerGroup");
        this._persistence_propertyChange("schedulerGroup", (Object)this.schedulerGroup, (Object)s);
        this.schedulerGroup = s;
    }

    public Date _persistence_get_previousRunStartTime() {
        this._persistence_checkFetched("previousRunStartTime");
        return this.previousRunStartTime;
    }

    public void _persistence_set_previousRunStartTime(Date date) {
        this._persistence_checkFetchedForSet("previousRunStartTime");
        this._persistence_propertyChange("previousRunStartTime", (Object)this.previousRunStartTime, (Object)date);
        this.previousRunStartTime = date;
    }

    public Short _persistence_get_taskPriority() {
        this._persistence_checkFetched("taskPriority");
        return this.taskPriority;
    }

    public void _persistence_set_taskPriority(Short s) {
        this._persistence_checkFetchedForSet("taskPriority");
        this._persistence_propertyChange("taskPriority", (Object)this.taskPriority, (Object)s);
        this.taskPriority = s;
    }

    public String _persistence_get_jobKey() {
        this._persistence_checkFetched("jobKey");
        return this.jobKey;
    }

    public void _persistence_set_jobKey(String string) {
        this._persistence_checkFetchedForSet("jobKey");
        this._persistence_propertyChange("jobKey", (Object)this.jobKey, (Object)string);
        this.jobKey = string;
    }

    public String _persistence_get_errorLog() {
        this._persistence_checkFetched("errorLog");
        return this.errorLog;
    }

    public void _persistence_set_errorLog(String string) {
        this._persistence_checkFetchedForSet("errorLog");
        this._persistence_propertyChange("errorLog", (Object)this.errorLog, (Object)string);
        this.errorLog = string;
    }

    public String _persistence_get_jobDisplayName() {
        this._persistence_checkFetched("jobDisplayName");
        return this.jobDisplayName;
    }

    public void _persistence_set_jobDisplayName(String string) {
        this._persistence_checkFetchedForSet("jobDisplayName");
        this._persistence_propertyChange("jobDisplayName", (Object)this.jobDisplayName, (Object)string);
        this.jobDisplayName = string;
    }

    public boolean _persistence_get_updatesAllowed() {
        this._persistence_checkFetched("updatesAllowed");
        return this.updatesAllowed;
    }

    public void _persistence_set_updatesAllowed(boolean bl) {
        this._persistence_checkFetchedForSet("updatesAllowed");
        this._persistence_propertyChange("updatesAllowed", (Object)new Boolean(this.updatesAllowed), (Object)new Boolean(bl));
        this.updatesAllowed = bl;
    }

    public String _persistence_get_cronExpression() {
        this._persistence_checkFetched("cronExpression");
        return this.cronExpression;
    }

    public void _persistence_set_cronExpression(String string) {
        this._persistence_checkFetchedForSet("cronExpression");
        this._persistence_propertyChange("cronExpression", (Object)this.cronExpression, (Object)string);
        this.cronExpression = string;
    }

    public String _persistence_get_groupName() {
        this._persistence_checkFetched("groupName");
        return this.groupName;
    }

    public void _persistence_set_groupName(String string) {
        this._persistence_checkFetchedForSet("groupName");
        this._persistence_propertyChange("groupName", (Object)this.groupName, (Object)string);
        this.groupName = string;
    }

    public Date _persistence_get_nextRunTime() {
        this._persistence_checkFetched("nextRunTime");
        return this.nextRunTime;
    }

    public void _persistence_set_nextRunTime(Date date) {
        this._persistence_checkFetchedForSet("nextRunTime");
        this._persistence_propertyChange("nextRunTime", (Object)this.nextRunTime, (Object)date);
        this.nextRunTime = date;
    }

    public Date _persistence_get_createTime() {
        this._persistence_checkFetched("createTime");
        return this.createTime;
    }

    public void _persistence_set_createTime(Date date) {
        this._persistence_checkFetchedForSet("createTime");
        this._persistence_propertyChange("createTime", (Object)this.createTime, (Object)date);
        this.createTime = date;
    }

    public boolean _persistence_get_isMismatchedJob() {
        this._persistence_checkFetched("isMismatchedJob");
        return this.isMismatchedJob;
    }

    public void _persistence_set_isMismatchedJob(boolean bl) {
        this._persistence_checkFetchedForSet("isMismatchedJob");
        this._persistence_propertyChange("isMismatchedJob", (Object)new Boolean(this.isMismatchedJob), (Object)new Boolean(bl));
        this.isMismatchedJob = bl;
    }

    public boolean _persistence_get_activeSchedular() {
        this._persistence_checkFetched("activeSchedular");
        return this.activeSchedular;
    }

    public void _persistence_set_activeSchedular(boolean bl) {
        this._persistence_checkFetchedForSet("activeSchedular");
        this._persistence_propertyChange("activeSchedular", (Object)new Boolean(this.activeSchedular), (Object)new Boolean(bl));
        this.activeSchedular = bl;
    }

    public boolean _persistence_get_triggerMisfired() {
        this._persistence_checkFetched("triggerMisfired");
        return this.triggerMisfired;
    }

    public void _persistence_set_triggerMisfired(boolean bl) {
        this._persistence_checkFetchedForSet("triggerMisfired");
        this._persistence_propertyChange("triggerMisfired", (Object)new Boolean(this.triggerMisfired), (Object)new Boolean(bl));
        this.triggerMisfired = bl;
    }

    public String _persistence_get_shortName() {
        this._persistence_checkFetched("shortName");
        return this.shortName;
    }

    public void _persistence_set_shortName(String string) {
        this._persistence_checkFetchedForSet("shortName");
        this._persistence_propertyChange("shortName", (Object)this.shortName, (Object)string);
        this.shortName = string;
    }

    public Integer _persistence_get_nodeId() {
        this._persistence_checkFetched("nodeId");
        return this.nodeId;
    }

    public void _persistence_set_nodeId(Integer n) {
        this._persistence_checkFetchedForSet("nodeId");
        this._persistence_propertyChange("nodeId", (Object)this.nodeId, (Object)n);
        this.nodeId = n;
    }

    public boolean _persistence_get_currentlyRunning() {
        this._persistence_checkFetched("currentlyRunning");
        return this.currentlyRunning;
    }

    public void _persistence_set_currentlyRunning(boolean bl) {
        this._persistence_checkFetchedForSet("currentlyRunning");
        this._persistence_propertyChange("currentlyRunning", (Object)new Boolean(this.currentlyRunning), (Object)new Boolean(bl));
        this.currentlyRunning = bl;
    }
}

