/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.gcm.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.portfolio.client.domain.Client;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="client_device_registration")
public class DeviceRegistration
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @OneToOne
    @JoinColumn(name="client_id", nullable=false, unique=true)
    private Client client;
    @Column(name="registration_id", nullable=false, unique=true)
    private String registrationId;
    @Column(name="updatedon_date", nullable=false)
    private LocalDateTime updatedOnDate;
    static final long serialVersionUID = 4425076845962215061L;

    public static DeviceRegistration instance(Client client, String registrationId) {
        return new DeviceRegistration().setRegistrationId(registrationId).setClient(client).setUpdatedOnDate(DateUtils.getLocalDateTimeOfTenant());
    }

    @Generated
    public Client getClient() {
        return this._persistence_get_client();
    }

    @Generated
    public String getRegistrationId() {
        return this._persistence_get_registrationId();
    }

    @Generated
    public LocalDateTime getUpdatedOnDate() {
        return this._persistence_get_updatedOnDate();
    }

    @Generated
    public DeviceRegistration setClient(Client client) {
        this._persistence_set_client(client);
        return this;
    }

    @Generated
    public DeviceRegistration setRegistrationId(String registrationId) {
        this._persistence_set_registrationId(registrationId);
        return this;
    }

    @Generated
    public DeviceRegistration setUpdatedOnDate(LocalDateTime updatedOnDate) {
        this._persistence_set_updatedOnDate(updatedOnDate);
        return this;
    }

    @Generated
    public DeviceRegistration() {
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new DeviceRegistration();
    }

    public Object _persistence_get(String string) {
        if (string == "updatedOnDate") {
            return this.updatedOnDate;
        }
        if (string == "registrationId") {
            return this.registrationId;
        }
        if (string == "client") {
            return this.client;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "updatedOnDate") {
            this.updatedOnDate = (LocalDateTime)object;
            return;
        }
        if (string == "registrationId") {
            this.registrationId = (String)object;
            return;
        }
        if (string == "client") {
            this.client = (Client)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public LocalDateTime _persistence_get_updatedOnDate() {
        this._persistence_checkFetched("updatedOnDate");
        return this.updatedOnDate;
    }

    public void _persistence_set_updatedOnDate(LocalDateTime localDateTime) {
        this._persistence_checkFetchedForSet("updatedOnDate");
        this._persistence_propertyChange("updatedOnDate", (Object)this.updatedOnDate, (Object)localDateTime);
        this.updatedOnDate = localDateTime;
    }

    public String _persistence_get_registrationId() {
        this._persistence_checkFetched("registrationId");
        return this.registrationId;
    }

    public void _persistence_set_registrationId(String string) {
        this._persistence_checkFetchedForSet("registrationId");
        this._persistence_propertyChange("registrationId", (Object)this.registrationId, (Object)string);
        this.registrationId = string;
    }

    public Client _persistence_get_client() {
        this._persistence_checkFetched("client");
        return this.client;
    }

    public void _persistence_set_client(Client client) {
        this._persistence_checkFetchedForSet("client");
        this._persistence_propertyChange("client", (Object)this.client, (Object)client);
        this.client = client;
    }
}

