/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.event.external.service.serialization.serializer.loan;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.avro.generic.GenericContainer;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.fineract.avro.generator.ByteBufferSerializable;
import org.apache.fineract.avro.loan.v1.LoanAccountDataV1;
import org.apache.fineract.infrastructure.event.business.domain.BusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanBusinessEvent;
import org.apache.fineract.infrastructure.event.external.service.serialization.mapper.loan.LoanAccountDataMapper;
import org.apache.fineract.infrastructure.event.external.service.serialization.serializer.BusinessEventSerializer;
import org.apache.fineract.infrastructure.event.external.service.serialization.serializer.ExternalEventCustomDataSerializer;
import org.apache.fineract.infrastructure.event.external.service.serialization.serializer.loan.LoanInstallmentLevelDelinquencyEventProducer;
import org.apache.fineract.portfolio.delinquency.service.DelinquencyReadPlatformService;
import org.apache.fineract.portfolio.loanaccount.api.LoanApiConstants;
import org.apache.fineract.portfolio.loanaccount.data.CollectionData;
import org.apache.fineract.portfolio.loanaccount.data.LoanAccountData;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanSummaryBalancesRepository;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTermVariations;
import org.apache.fineract.portfolio.loanaccount.service.LoanChargeReadPlatformService;
import org.apache.fineract.portfolio.loanaccount.service.LoanReadPlatformService;
import org.apache.fineract.portfolio.loanaccount.service.LoanSummaryDataProvider;
import org.apache.fineract.portfolio.loanaccount.service.LoanSummaryProviderDelegate;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class LoanBusinessEventSerializer
implements BusinessEventSerializer {
    private final LoanReadPlatformService service;
    private final LoanAccountDataMapper mapper;
    private final LoanChargeReadPlatformService loanChargeReadPlatformService;
    private final DelinquencyReadPlatformService delinquencyReadPlatformService;
    private final LoanInstallmentLevelDelinquencyEventProducer installmentLevelDelinquencyEventProducer;
    private final LoanSummaryBalancesRepository loanSummaryBalancesRepository;
    @Lazy
    private final LoanSummaryProviderDelegate loanSummaryProviderDelegate;
    private final List<ExternalEventCustomDataSerializer<LoanBusinessEvent>> externalEventCustomDataSerializers;

    public <T> boolean canSerialize(BusinessEvent<T> event) {
        return event instanceof LoanBusinessEvent;
    }

    public <T> ByteBufferSerializable toAvroDTO(BusinessEvent<T> rawEvent) {
        LoanBusinessEvent event = (LoanBusinessEvent)rawEvent;
        Long loanId = (Long)((Loan)event.get()).getId();
        LoanAccountData data = this.service.retrieveOne(loanId);
        data = this.service.fetchRepaymentScheduleData(data);
        Collection loanCharges = this.loanChargeReadPlatformService.retrieveLoanCharges(loanId);
        if (CollectionUtils.isNotEmpty((Collection)loanCharges)) {
            data.setCharges(loanCharges);
        }
        CollectionData delinquentData = this.delinquencyReadPlatformService.calculateLoanCollectionData(loanId);
        data.setDelinquent(delinquentData);
        LoanSummaryDataProvider loanSummaryDataProvider = this.loanSummaryProviderDelegate.resolveLoanSummaryDataProvider(data.getTransactionProcessingStrategyCode());
        if (data.getSummary() != null) {
            data.setSummary(loanSummaryDataProvider.withTransactionAmountsSummary((Loan)event.get(), data.getSummary(), data.getRepaymentSchedule(), this.loanSummaryBalancesRepository.retrieveLoanSummaryBalancesByTransactionType(loanId, LoanApiConstants.LOAN_SUMMARY_TRANSACTION_TYPES)));
        } else {
            data.setSummary(loanSummaryDataProvider.withOnlyCurrencyData(data.getCurrency()));
        }
        List installmentsDelinquencyData = this.installmentLevelDelinquencyEventProducer.calculateInstallmentLevelDelinquencyData((Loan)event.get(), data.getCurrency());
        List activeLoanTermVariations = ((Loan)event.get()).getActiveLoanTermVariations();
        if (!activeLoanTermVariations.isEmpty()) {
            data.setLoanTermVariations(activeLoanTermVariations.stream().map(LoanTermVariations::toData).toList());
        }
        LoanAccountDataV1 result = this.mapper.map(data);
        result.getDelinquent().setInstallmentDelinquencyBuckets(installmentsDelinquencyData);
        result.setCustomData(this.collectCustomData(event));
        return result;
    }

    public Class<? extends GenericContainer> getSupportedSchema() {
        return LoanAccountDataV1.class;
    }

    private Map<String, ByteBuffer> collectCustomData(LoanBusinessEvent event) {
        return this.externalEventCustomDataSerializers.stream().collect(Collectors.toMap(ExternalEventCustomDataSerializer::key, serializer -> serializer.serialize((BusinessEvent)event), (existing, replacement) -> replacement));
    }

    @Generated
    public LoanBusinessEventSerializer(LoanReadPlatformService service, LoanAccountDataMapper mapper, LoanChargeReadPlatformService loanChargeReadPlatformService, DelinquencyReadPlatformService delinquencyReadPlatformService, LoanInstallmentLevelDelinquencyEventProducer installmentLevelDelinquencyEventProducer, LoanSummaryBalancesRepository loanSummaryBalancesRepository, LoanSummaryProviderDelegate loanSummaryProviderDelegate, List<ExternalEventCustomDataSerializer<LoanBusinessEvent>> externalEventCustomDataSerializers) {
        this.service = service;
        this.mapper = mapper;
        this.loanChargeReadPlatformService = loanChargeReadPlatformService;
        this.delinquencyReadPlatformService = delinquencyReadPlatformService;
        this.installmentLevelDelinquencyEventProducer = installmentLevelDelinquencyEventProducer;
        this.loanSummaryBalancesRepository = loanSummaryBalancesRepository;
        this.loanSummaryProviderDelegate = loanSummaryProviderDelegate;
        this.externalEventCustomDataSerializers = externalEventCustomDataSerializers;
    }
}

