/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.event.external.service.serialization.serializer.loan;

import java.util.Collection;
import lombok.Generated;
import org.apache.avro.generic.GenericContainer;
import org.apache.fineract.avro.generator.ByteBufferSerializable;
import org.apache.fineract.avro.loan.v1.LoanTransactionAdjustmentDataV1;
import org.apache.fineract.avro.loan.v1.LoanTransactionDataV1;
import org.apache.fineract.infrastructure.event.business.domain.BusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanAdjustTransactionBusinessEvent;
import org.apache.fineract.infrastructure.event.external.service.serialization.mapper.loan.LoanTransactionDataMapper;
import org.apache.fineract.infrastructure.event.external.service.serialization.serializer.BusinessEventSerializer;
import org.apache.fineract.portfolio.loanaccount.data.LoanTransactionData;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.loanaccount.service.LoanChargePaidByReadService;
import org.apache.fineract.portfolio.loanaccount.service.LoanReadPlatformService;
import org.springframework.stereotype.Component;

@Component
public class LoanAdjustTransactionBusinessEventSerializer
implements BusinessEventSerializer {
    private final LoanReadPlatformService service;
    private final LoanTransactionDataMapper mapper;
    private final LoanChargePaidByReadService loanChargePaidByReadService;

    public <T> boolean canSerialize(BusinessEvent<T> event) {
        return event instanceof LoanAdjustTransactionBusinessEvent;
    }

    public <T> ByteBufferSerializable toAvroDTO(BusinessEvent<T> rawEvent) {
        LoanAdjustTransactionBusinessEvent event = (LoanAdjustTransactionBusinessEvent)rawEvent;
        LoanTransaction transactionToAdjust = ((LoanAdjustTransactionBusinessEvent.Data)event.get()).getTransactionToAdjust();
        LoanTransactionData transactionToAdjustData = this.service.retrieveLoanTransaction((Long)transactionToAdjust.getLoan().getId(), (Long)transactionToAdjust.getId());
        transactionToAdjustData.setLoanChargePaidByList((Collection)this.loanChargePaidByReadService.fetchLoanChargesPaidByDataTransactionId((Long)transactionToAdjust.getId()));
        LoanTransactionDataV1 transactionToAdjustAvroDto = this.mapper.map(transactionToAdjustData);
        LoanTransaction newTransactionDetail = ((LoanAdjustTransactionBusinessEvent.Data)event.get()).getNewTransactionDetail();
        LoanTransactionDataV1 newTransactionDetailAvroDto = null;
        if (newTransactionDetail != null) {
            LoanTransactionData newTransactionDetailData = this.service.retrieveLoanTransaction((Long)newTransactionDetail.getLoan().getId(), (Long)newTransactionDetail.getId());
            newTransactionDetailData.setLoanChargePaidByList((Collection)this.loanChargePaidByReadService.fetchLoanChargesPaidByDataTransactionId((Long)newTransactionDetail.getId()));
            newTransactionDetailAvroDto = this.mapper.map(newTransactionDetailData);
        }
        return new LoanTransactionAdjustmentDataV1(transactionToAdjustAvroDto, newTransactionDetailAvroDto);
    }

    public Class<? extends GenericContainer> getSupportedSchema() {
        return LoanTransactionAdjustmentDataV1.class;
    }

    @Generated
    public LoanAdjustTransactionBusinessEventSerializer(LoanReadPlatformService service, LoanTransactionDataMapper mapper, LoanChargePaidByReadService loanChargePaidByReadService) {
        this.service = service;
        this.mapper = mapper;
        this.loanChargePaidByReadService = loanChargePaidByReadService;
    }
}

