/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.entityaccess.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.entityaccess.domain.FineractEntityRelation;
import org.apache.fineract.infrastructure.entityaccess.exception.FineractEntityToEntityMappingDateException;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="m_entity_to_entity_mapping", uniqueConstraints={@UniqueConstraint(columnNames={"rel_id", "from_id", "to_id"})})
public class FineractEntityToEntityMapping
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @ManyToOne
    @JoinColumn(name="rel_id")
    private FineractEntityRelation relationId;
    @Column(name="from_id")
    private Long fromId;
    @Column(name="to_id")
    private Long toId;
    @Column(name="start_date", nullable=true)
    private LocalDate startDate;
    @Column(name="end_date", nullable=true)
    private LocalDate endDate;
    static final long serialVersionUID = 2256952056047751081L;

    public static FineractEntityToEntityMapping newMap(FineractEntityRelation relationId, Long fromId, Long toId, LocalDate startDate, LocalDate endDate) {
        return new FineractEntityToEntityMapping().setRelationId(relationId).setFromId(fromId).setToId(toId).setStartDate(startDate).setEndDate(endDate);
    }

    public Map<String, Object> updateMap(JsonCommand command) {
        String valueAsInput;
        Long newValue;
        LinkedHashMap<String, Object> actualChanges = new LinkedHashMap<String, Object>(9);
        if (command.isChangeInLongParameterNamed("fromId", this._persistence_get_fromId())) {
            newValue = command.longValueOfParameterNamed("fromId");
            actualChanges.put("fromId", newValue);
            this._persistence_set_fromId(newValue);
        }
        if (command.isChangeInLongParameterNamed("toId", this._persistence_get_toId())) {
            newValue = command.longValueOfParameterNamed("toId");
            actualChanges.put("toId", newValue);
            this._persistence_set_toId(newValue);
        }
        if (command.isChangeInDateParameterNamed("startDate", this._persistence_get_startDate())) {
            valueAsInput = command.stringValueOfParameterNamed("startDate");
            actualChanges.put("startDate", valueAsInput);
            this._persistence_set_startDate(command.localDateValueOfParameterNamed("startDate"));
        }
        if (command.isChangeInDateParameterNamed("endDate", this._persistence_get_endDate())) {
            valueAsInput = command.stringValueOfParameterNamed("endDate");
            actualChanges.put("endDate", valueAsInput);
            this._persistence_set_endDate(command.localDateValueOfParameterNamed("endDate"));
        }
        if (this._persistence_get_endDate() != null && DateUtils.isBefore((LocalDate)this._persistence_get_endDate(), (LocalDate)this._persistence_get_startDate())) {
            throw new FineractEntityToEntityMappingDateException(this._persistence_get_startDate().toString(), this._persistence_get_endDate().toString());
        }
        return actualChanges;
    }

    @Generated
    public FineractEntityRelation getRelationId() {
        return this._persistence_get_relationId();
    }

    @Generated
    public Long getFromId() {
        return this._persistence_get_fromId();
    }

    @Generated
    public Long getToId() {
        return this._persistence_get_toId();
    }

    @Generated
    public LocalDate getStartDate() {
        return this._persistence_get_startDate();
    }

    @Generated
    public LocalDate getEndDate() {
        return this._persistence_get_endDate();
    }

    @Generated
    public FineractEntityToEntityMapping setRelationId(FineractEntityRelation relationId) {
        this._persistence_set_relationId(relationId);
        return this;
    }

    @Generated
    public FineractEntityToEntityMapping setFromId(Long fromId) {
        this._persistence_set_fromId(fromId);
        return this;
    }

    @Generated
    public FineractEntityToEntityMapping setToId(Long toId) {
        this._persistence_set_toId(toId);
        return this;
    }

    @Generated
    public FineractEntityToEntityMapping setStartDate(LocalDate startDate) {
        this._persistence_set_startDate(startDate);
        return this;
    }

    @Generated
    public FineractEntityToEntityMapping setEndDate(LocalDate endDate) {
        this._persistence_set_endDate(endDate);
        return this;
    }

    @Generated
    public FineractEntityToEntityMapping() {
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new FineractEntityToEntityMapping();
    }

    public Object _persistence_get(String string) {
        if (string == "toId") {
            return this.toId;
        }
        if (string == "endDate") {
            return this.endDate;
        }
        if (string == "relationId") {
            return this.relationId;
        }
        if (string == "fromId") {
            return this.fromId;
        }
        if (string == "startDate") {
            return this.startDate;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "toId") {
            this.toId = (Long)object;
            return;
        }
        if (string == "endDate") {
            this.endDate = (LocalDate)object;
            return;
        }
        if (string == "relationId") {
            this.relationId = (FineractEntityRelation)object;
            return;
        }
        if (string == "fromId") {
            this.fromId = (Long)object;
            return;
        }
        if (string == "startDate") {
            this.startDate = (LocalDate)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Long _persistence_get_toId() {
        this._persistence_checkFetched("toId");
        return this.toId;
    }

    public void _persistence_set_toId(Long l) {
        this._persistence_checkFetchedForSet("toId");
        this._persistence_propertyChange("toId", (Object)this.toId, (Object)l);
        this.toId = l;
    }

    public LocalDate _persistence_get_endDate() {
        this._persistence_checkFetched("endDate");
        return this.endDate;
    }

    public void _persistence_set_endDate(LocalDate localDate) {
        this._persistence_checkFetchedForSet("endDate");
        this._persistence_propertyChange("endDate", (Object)this.endDate, (Object)localDate);
        this.endDate = localDate;
    }

    public FineractEntityRelation _persistence_get_relationId() {
        this._persistence_checkFetched("relationId");
        return this.relationId;
    }

    public void _persistence_set_relationId(FineractEntityRelation fineractEntityRelation) {
        this._persistence_checkFetchedForSet("relationId");
        this._persistence_propertyChange("relationId", (Object)this.relationId, (Object)fineractEntityRelation);
        this.relationId = fineractEntityRelation;
    }

    public Long _persistence_get_fromId() {
        this._persistence_checkFetched("fromId");
        return this.fromId;
    }

    public void _persistence_set_fromId(Long l) {
        this._persistence_checkFetchedForSet("fromId");
        this._persistence_propertyChange("fromId", (Object)this.fromId, (Object)l);
        this.fromId = l;
    }

    public LocalDate _persistence_get_startDate() {
        this._persistence_checkFetched("startDate");
        return this.startDate;
    }

    public void _persistence_set_startDate(LocalDate localDate) {
        this._persistence_checkFetchedForSet("startDate");
        this._persistence_propertyChange("startDate", (Object)this.startDate, (Object)localDate);
        this.startDate = localDate;
    }
}

