/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.dataqueries.service.export;

import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.api.ApiParameterHelper;
import org.apache.fineract.infrastructure.core.serialization.ToApiJsonSerializer;
import org.apache.fineract.infrastructure.dataqueries.data.GenericResultsetData;
import org.apache.fineract.infrastructure.dataqueries.data.ReportData;
import org.apache.fineract.infrastructure.dataqueries.service.DatatableExportTargetParameter;
import org.apache.fineract.infrastructure.dataqueries.service.GenericDataService;
import org.apache.fineract.infrastructure.dataqueries.service.ReadReportingService;
import org.apache.fineract.infrastructure.dataqueries.service.export.DatatableReportExportService;
import org.apache.fineract.infrastructure.dataqueries.service.export.ResponseHolder;
import org.springframework.stereotype.Service;

@Service
public class JsonDatatableReportExportService
implements DatatableReportExportService {
    private final ReadReportingService readExtraDataAndReportingService;
    private final ToApiJsonSerializer<ReportData> toApiJsonSerializer;
    private final GenericDataService genericDataService;

    public ResponseHolder export(String reportName, MultivaluedMap<String, String> queryParams, Map<String, String> reportParams, boolean isSelfServiceUserReport, String parameterTypeValue) {
        GenericResultsetData result = this.readExtraDataAndReportingService.retrieveGenericResultset(reportName, parameterTypeValue, reportParams, isSelfServiceUserReport);
        DatatableExportTargetParameter exportMode = DatatableExportTargetParameter.resolverExportTarget(queryParams);
        boolean prettyPrint = exportMode == DatatableExportTargetParameter.PRETTY_JSON;
        boolean genericResultSetIsPassed = ApiParameterHelper.genericResultSetPassed(queryParams);
        boolean genericResultSet = ApiParameterHelper.genericResultSet(queryParams);
        String json = genericResultSetIsPassed ? (genericResultSet ? this.toApiJsonSerializer.serializePretty(prettyPrint, (Object)result) : this.genericDataService.generateJsonFromGenericResultsetData(result)) : this.toApiJsonSerializer.serializePretty(prettyPrint, (Object)result);
        return new ResponseHolder(Response.Status.OK).entity((Object)json).contentType("application/json");
    }

    public boolean supports(DatatableExportTargetParameter exportType) {
        return exportType == DatatableExportTargetParameter.JSON || exportType == DatatableExportTargetParameter.PRETTY_JSON;
    }

    @Generated
    public JsonDatatableReportExportService(ReadReportingService readExtraDataAndReportingService, ToApiJsonSerializer<ReportData> toApiJsonSerializer, GenericDataService genericDataService) {
        this.readExtraDataAndReportingService = readExtraDataAndReportingService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.genericDataService = genericDataService;
    }
}

