/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.creditbureau.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.infrastructure.creditbureau.domain.OrganisationCreditBureau;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProduct;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="m_creditbureau_loanproduct_mapping")
public class CreditBureauLoanProductMapping
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @Column(name="is_credit_check_mandatory")
    private boolean creditCheckMandatory;
    @Column(name="skip_credit_check_in_failure")
    private boolean skipCreditCheckInFailure;
    @Column(name="stale_period")
    private int stalePeriod;
    @Column(name="is_active")
    private boolean active;
    @ManyToOne
    private OrganisationCreditBureau organisation_creditbureau;
    @OneToOne
    @JoinColumn(name="loan_product_id")
    private LoanProduct loanProduct;
    static final long serialVersionUID = 7177465030063193433L;

    public static CreditBureauLoanProductMapping fromJson(JsonCommand command, OrganisationCreditBureau organisation_creditbureau, LoanProduct loanProduct) {
        Boolean isCreditCheckMandatory = false;
        Boolean skipCreditCheckInFailure = false;
        Integer stalePeriod = -1;
        Boolean isActive = false;
        if (Boolean.valueOf(command.booleanPrimitiveValueOfParameterNamed("isCreditcheckMandatory")) != null) {
            isCreditCheckMandatory = command.booleanPrimitiveValueOfParameterNamed("isCreditcheckMandatory");
        }
        if (Boolean.valueOf(command.booleanPrimitiveValueOfParameterNamed("skipCreditcheckInFailure")) != null) {
            skipCreditCheckInFailure = command.booleanPrimitiveValueOfParameterNamed("skipCreditcheckInFailure");
        }
        if (command.integerValueOfParameterNamed("stalePeriod") != null) {
            stalePeriod = command.integerValueOfParameterNamed("stalePeriod");
        }
        if (Boolean.valueOf(command.booleanPrimitiveValueOfParameterNamed("isActive")).booleanValue()) {
            isActive = command.booleanPrimitiveValueOfParameterNamed("isActive");
        }
        return new CreditBureauLoanProductMapping().setCreditCheckMandatory(isCreditCheckMandatory.booleanValue()).setSkipCreditCheckInFailure(skipCreditCheckInFailure.booleanValue()).setStalePeriod(stalePeriod.intValue()).setActive(isActive.booleanValue()).setOrganisation_creditbureau(organisation_creditbureau).setLoanProduct(loanProduct);
    }

    @Generated
    public boolean isCreditCheckMandatory() {
        return this._persistence_get_creditCheckMandatory();
    }

    @Generated
    public boolean isSkipCreditCheckInFailure() {
        return this._persistence_get_skipCreditCheckInFailure();
    }

    @Generated
    public int getStalePeriod() {
        return this._persistence_get_stalePeriod();
    }

    @Generated
    public boolean isActive() {
        return this._persistence_get_active();
    }

    @Generated
    public OrganisationCreditBureau getOrganisation_creditbureau() {
        return this._persistence_get_organisation_creditbureau();
    }

    @Generated
    public LoanProduct getLoanProduct() {
        return this._persistence_get_loanProduct();
    }

    @Generated
    public CreditBureauLoanProductMapping setCreditCheckMandatory(boolean creditCheckMandatory) {
        this._persistence_set_creditCheckMandatory(creditCheckMandatory);
        return this;
    }

    @Generated
    public CreditBureauLoanProductMapping setSkipCreditCheckInFailure(boolean skipCreditCheckInFailure) {
        this._persistence_set_skipCreditCheckInFailure(skipCreditCheckInFailure);
        return this;
    }

    @Generated
    public CreditBureauLoanProductMapping setStalePeriod(int stalePeriod) {
        this._persistence_set_stalePeriod(stalePeriod);
        return this;
    }

    @Generated
    public CreditBureauLoanProductMapping setActive(boolean active) {
        this._persistence_set_active(active);
        return this;
    }

    @Generated
    public CreditBureauLoanProductMapping setOrganisation_creditbureau(OrganisationCreditBureau organisation_creditbureau) {
        this._persistence_set_organisation_creditbureau(organisation_creditbureau);
        return this;
    }

    @Generated
    public CreditBureauLoanProductMapping setLoanProduct(LoanProduct loanProduct) {
        this._persistence_set_loanProduct(loanProduct);
        return this;
    }

    @Generated
    public CreditBureauLoanProductMapping() {
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new CreditBureauLoanProductMapping();
    }

    public Object _persistence_get(String string) {
        if (string == "organisation_creditbureau") {
            return this.organisation_creditbureau;
        }
        if (string == "stalePeriod") {
            return this.stalePeriod;
        }
        if (string == "skipCreditCheckInFailure") {
            return this.skipCreditCheckInFailure;
        }
        if (string == "loanProduct") {
            return this.loanProduct;
        }
        if (string == "active") {
            return this.active;
        }
        if (string == "creditCheckMandatory") {
            return this.creditCheckMandatory;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "organisation_creditbureau") {
            this.organisation_creditbureau = (OrganisationCreditBureau)object;
            return;
        }
        if (string == "stalePeriod") {
            this.stalePeriod = (Integer)object;
            return;
        }
        if (string == "skipCreditCheckInFailure") {
            this.skipCreditCheckInFailure = (Boolean)object;
            return;
        }
        if (string == "loanProduct") {
            this.loanProduct = (LoanProduct)object;
            return;
        }
        if (string == "active") {
            this.active = (Boolean)object;
            return;
        }
        if (string == "creditCheckMandatory") {
            this.creditCheckMandatory = (Boolean)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public OrganisationCreditBureau _persistence_get_organisation_creditbureau() {
        this._persistence_checkFetched("organisation_creditbureau");
        return this.organisation_creditbureau;
    }

    public void _persistence_set_organisation_creditbureau(OrganisationCreditBureau organisationCreditBureau) {
        this._persistence_checkFetchedForSet("organisation_creditbureau");
        this._persistence_propertyChange("organisation_creditbureau", (Object)this.organisation_creditbureau, (Object)organisationCreditBureau);
        this.organisation_creditbureau = organisationCreditBureau;
    }

    public int _persistence_get_stalePeriod() {
        this._persistence_checkFetched("stalePeriod");
        return this.stalePeriod;
    }

    public void _persistence_set_stalePeriod(int n) {
        this._persistence_checkFetchedForSet("stalePeriod");
        this._persistence_propertyChange("stalePeriod", (Object)new Integer(this.stalePeriod), (Object)new Integer(n));
        this.stalePeriod = n;
    }

    public boolean _persistence_get_skipCreditCheckInFailure() {
        this._persistence_checkFetched("skipCreditCheckInFailure");
        return this.skipCreditCheckInFailure;
    }

    public void _persistence_set_skipCreditCheckInFailure(boolean bl) {
        this._persistence_checkFetchedForSet("skipCreditCheckInFailure");
        this._persistence_propertyChange("skipCreditCheckInFailure", (Object)new Boolean(this.skipCreditCheckInFailure), (Object)new Boolean(bl));
        this.skipCreditCheckInFailure = bl;
    }

    public LoanProduct _persistence_get_loanProduct() {
        this._persistence_checkFetched("loanProduct");
        return this.loanProduct;
    }

    public void _persistence_set_loanProduct(LoanProduct loanProduct) {
        this._persistence_checkFetchedForSet("loanProduct");
        this._persistence_propertyChange("loanProduct", (Object)this.loanProduct, (Object)loanProduct);
        this.loanProduct = loanProduct;
    }

    public boolean _persistence_get_active() {
        this._persistence_checkFetched("active");
        return this.active;
    }

    public void _persistence_set_active(boolean bl) {
        this._persistence_checkFetchedForSet("active");
        this._persistence_propertyChange("active", (Object)new Boolean(this.active), (Object)new Boolean(bl));
        this.active = bl;
    }

    public boolean _persistence_get_creditCheckMandatory() {
        this._persistence_checkFetched("creditCheckMandatory");
        return this.creditCheckMandatory;
    }

    public void _persistence_set_creditCheckMandatory(boolean bl) {
        this._persistence_checkFetchedForSet("creditCheckMandatory");
        this._persistence_propertyChange("creditCheckMandatory", (Object)new Boolean(this.creditCheckMandatory), (Object)new Boolean(bl));
        this.creditCheckMandatory = bl;
    }
}

