/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.creditbureau.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.infrastructure.creditbureau.domain.OrganisationCreditBureau;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="m_creditbureau_configuration")
public class CreditBureauConfiguration
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @Column(name="configkey")
    private String configurationKey;
    @Column(name="value")
    private String value;
    @Column(name="description")
    private String description;
    @ManyToOne
    @JoinColumn(name="organisation_creditbureau_id")
    private OrganisationCreditBureau organisationCreditbureau;
    static final long serialVersionUID = 3401937939808569541L;

    public static CreditBureauConfiguration fromJson(JsonCommand command, OrganisationCreditBureau organisation_creditbureau) {
        String configkey = command.stringValueOfParameterNamed("configkey");
        String value = command.stringValueOfParameterNamed("value");
        String description = command.stringValueOfParameterNamed("description");
        return new CreditBureauConfiguration().setConfigurationKey(configkey).setValue(value).setDescription(description).setOrganisationCreditbureau(organisation_creditbureau);
    }

    public Map<String, Object> update(JsonCommand command) {
        LinkedHashMap<String, Object> actualChanges = new LinkedHashMap<String, Object>(1);
        String configurationKey = "configkey";
        if (command.isChangeInStringParameterNamed("configkey", this._persistence_get_configurationKey())) {
            String newValue = command.stringValueOfParameterNamed("configkey");
            actualChanges.put("configkey", newValue);
            this._persistence_set_configurationKey((String)StringUtils.defaultIfEmpty((CharSequence)newValue, null));
        }
        String value = "value";
        if (command.isChangeInStringParameterNamed("value", this._persistence_get_value())) {
            String newValue = command.stringValueOfParameterNamed("value");
            actualChanges.put("value", newValue);
            this._persistence_set_value((String)StringUtils.defaultIfEmpty((CharSequence)newValue, null));
        }
        String description = "description";
        if (command.isChangeInStringParameterNamed("description", this._persistence_get_configurationKey())) {
            String newValue = command.stringValueOfParameterNamed("description");
            actualChanges.put("description", newValue);
            this._persistence_set_description((String)StringUtils.defaultIfEmpty((CharSequence)newValue, null));
        }
        return actualChanges;
    }

    @Generated
    public String getConfigurationKey() {
        return this._persistence_get_configurationKey();
    }

    @Generated
    public String getValue() {
        return this._persistence_get_value();
    }

    @Generated
    public String getDescription() {
        return this._persistence_get_description();
    }

    @Generated
    public OrganisationCreditBureau getOrganisationCreditbureau() {
        return this._persistence_get_organisationCreditbureau();
    }

    @Generated
    public CreditBureauConfiguration setConfigurationKey(String configurationKey) {
        this._persistence_set_configurationKey(configurationKey);
        return this;
    }

    @Generated
    public CreditBureauConfiguration setValue(String value) {
        this._persistence_set_value(value);
        return this;
    }

    @Generated
    public CreditBureauConfiguration setDescription(String description) {
        this._persistence_set_description(description);
        return this;
    }

    @Generated
    public CreditBureauConfiguration setOrganisationCreditbureau(OrganisationCreditBureau organisationCreditbureau) {
        this._persistence_set_organisationCreditbureau(organisationCreditbureau);
        return this;
    }

    @Generated
    public CreditBureauConfiguration() {
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new CreditBureauConfiguration();
    }

    public Object _persistence_get(String string) {
        if (string == "configurationKey") {
            return this.configurationKey;
        }
        if (string == "description") {
            return this.description;
        }
        if (string == "value") {
            return this.value;
        }
        if (string == "organisationCreditbureau") {
            return this.organisationCreditbureau;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "configurationKey") {
            this.configurationKey = (String)object;
            return;
        }
        if (string == "description") {
            this.description = (String)object;
            return;
        }
        if (string == "value") {
            this.value = (String)object;
            return;
        }
        if (string == "organisationCreditbureau") {
            this.organisationCreditbureau = (OrganisationCreditBureau)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_configurationKey() {
        this._persistence_checkFetched("configurationKey");
        return this.configurationKey;
    }

    public void _persistence_set_configurationKey(String string) {
        this._persistence_checkFetchedForSet("configurationKey");
        this._persistence_propertyChange("configurationKey", (Object)this.configurationKey, (Object)string);
        this.configurationKey = string;
    }

    public String _persistence_get_description() {
        this._persistence_checkFetched("description");
        return this.description;
    }

    public void _persistence_set_description(String string) {
        this._persistence_checkFetchedForSet("description");
        this._persistence_propertyChange("description", (Object)this.description, (Object)string);
        this.description = string;
    }

    public String _persistence_get_value() {
        this._persistence_checkFetched("value");
        return this.value;
    }

    public void _persistence_set_value(String string) {
        this._persistence_checkFetchedForSet("value");
        this._persistence_propertyChange("value", (Object)this.value, (Object)string);
        this.value = string;
    }

    public OrganisationCreditBureau _persistence_get_organisationCreditbureau() {
        this._persistence_checkFetched("organisationCreditbureau");
        return this.organisationCreditbureau;
    }

    public void _persistence_set_organisationCreditbureau(OrganisationCreditBureau organisationCreditBureau) {
        this._persistence_checkFetchedForSet("organisationCreditbureau");
        this._persistence_propertyChange("organisationCreditbureau", (Object)this.organisationCreditbureau, (Object)organisationCreditBureau);
        this.organisationCreditbureau = organisationCreditBureau;
    }
}

