/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.core.service.migration;

import com.zaxxer.hikari.HikariDataSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Function;
import javax.sql.DataSource;
import liquibase.Scope;
import liquibase.ScopeManager;
import liquibase.ThreadLocalScopeManager;
import liquibase.change.custom.CustomTaskChange;
import liquibase.exception.LiquibaseException;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.config.FineractProperties;
import org.apache.fineract.infrastructure.core.domain.FineractPlatformTenant;
import org.apache.fineract.infrastructure.core.service.migration.ExtendedSpringLiquibase;
import org.apache.fineract.infrastructure.core.service.migration.ExtendedSpringLiquibaseFactory;
import org.apache.fineract.infrastructure.core.service.migration.SchemaUpgradeNeededException;
import org.apache.fineract.infrastructure.core.service.migration.TenantDataSourceFactory;
import org.apache.fineract.infrastructure.core.service.migration.TenantDatabaseStateVerifier;
import org.apache.fineract.infrastructure.core.service.tenant.TenantDetailsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class TenantDatabaseUpgradeService
implements InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantDatabaseUpgradeService.class);
    public static final String TENANT_STORE_DB_CONTEXT = "tenant_store_db";
    public static final String INITIAL_SWITCH_CONTEXT = "initial_switch";
    public static final String TENANT_DB_CONTEXT = "tenant_db";
    public static final String CUSTOM_CHANGELOG_CONTEXT = "custom_changelog";
    private final TenantDetailsService tenantDetailsService;
    @Qualifier(value="hikariTenantDataSource")
    private final DataSource tenantDataSource;
    private final FineractProperties fineractProperties;
    private final TenantDatabaseStateVerifier databaseStateVerifier;
    private final ExtendedSpringLiquibaseFactory liquibaseFactory;
    private final TenantDataSourceFactory tenantDataSourceFactory;
    private final Environment environment;
    private final List<CustomTaskChange> customTaskChangesForDependencyInjection;

    public void afterPropertiesSet() throws Exception {
        if (this.notLiquibaseOnlyMode() && (this.databaseStateVerifier.isLiquibaseDisabled() || !this.fineractProperties.getMode().isWriteEnabled())) {
            log.warn("Liquibase is disabled. Not upgrading any database.");
            if (!this.fineractProperties.getMode().isWriteEnabled()) {
                log.warn("Liquibase is disabled because the current instance is configured as a non-write Fineract instance");
            }
            return;
        }
        try {
            Scope.setScopeManager((ScopeManager)new ThreadLocalScopeManager());
            this.upgradeTenantStore();
            this.upgradeIndividualTenants();
        }
        catch (LiquibaseException e) {
            throw new RuntimeException("Error while migrating the schema", e);
        }
    }

    private boolean notLiquibaseOnlyMode() {
        List<String> activeProfiles = Arrays.asList(this.environment.getActiveProfiles());
        return !activeProfiles.contains("liquibase-only");
    }

    private void upgradeTenantStore() throws LiquibaseException {
        ExtendedSpringLiquibase liquibase;
        log.info("Upgrading tenant store DB at {}:{}", (Object)this.fineractProperties.getTenant().getHost(), (Object)this.fineractProperties.getTenant().getPort());
        this.logTenantStoreDetails();
        if (this.databaseStateVerifier.isFirstLiquibaseMigration(this.tenantDataSource)) {
            liquibase = this.liquibaseFactory.create(this.tenantDataSource, new String[]{TENANT_STORE_DB_CONTEXT, INITIAL_SWITCH_CONTEXT});
            this.applyInitialLiquibase(this.tenantDataSource, liquibase, "tenant store", ds -> !this.databaseStateVerifier.isTenantStoreOnLatestUpgradableVersion(ds));
        }
        liquibase = this.liquibaseFactory.create(this.tenantDataSource, new String[]{TENANT_STORE_DB_CONTEXT});
        liquibase.afterPropertiesSet();
        log.info("Tenant store upgrade finished");
    }

    private void logTenantStoreDetails() {
        FineractProperties.FineractTenantProperties tenant = this.fineractProperties.getTenant();
        log.info("- fineract.tenant.username: {}", (Object)tenant.getUsername());
        log.info("- fineract.tenant.password: ****");
        log.info("- fineract.tenant.parameters: {}", (Object)tenant.getParameters());
        log.info("- fineract.tenant.timezone: {}", (Object)tenant.getTimezone());
        log.info("- fineract.tenant.description: {}", (Object)tenant.getDescription());
        log.info("- fineract.tenant.identifier: {}", (Object)tenant.getIdentifier());
        log.info("- fineract.tenant.name: {}", (Object)tenant.getName());
        log.info("- liquibase.analytics.enabled: {}", (Object)System.getProperty("liquibase.analytics.enabled"));
        String readOnlyUsername = tenant.getReadOnlyUsername();
        if (StringUtils.isNotBlank((CharSequence)readOnlyUsername)) {
            log.info("- fineract.tenant.readonly.username: {}", (Object)readOnlyUsername);
            log.info("- fineract.tenant.readonly.password: {}", (Object)(StringUtils.isNotBlank((CharSequence)tenant.getReadOnlyPassword()) ? "****" : ""));
            log.info("- fineract.tenant.readonly.parameters: {}", (Object)tenant.getReadOnlyParameters());
            log.info("- fineract.tenant.readonly.name: {}", (Object)tenant.getReadOnlyName());
        }
    }

    private void upgradeIndividualTenants() {
        log.info("Upgrading all tenants");
        List tenants = this.tenantDetailsService.findAllTenants();
        ArrayList<Future> futures = new ArrayList<Future>();
        ThreadPoolTaskExecutor tenantUpgradeThreadPoolTaskExecutor = this.createTenantUpgradeThreadPoolTaskExecutor();
        if (CollectionUtils.isNotEmpty((Collection)tenants)) {
            for (FineractPlatformTenant tenant : tenants) {
                futures.add(tenantUpgradeThreadPoolTaskExecutor.submit(() -> {
                    this.upgradeIndividualTenant(tenant);
                    return tenant.getName();
                }));
            }
        }
        try {
            for (Future future : futures) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            throw new RuntimeException(exception);
        }
        finally {
            tenantUpgradeThreadPoolTaskExecutor.shutdown();
        }
        log.info("Tenant upgrades have finished");
    }

    private ThreadPoolTaskExecutor createTenantUpgradeThreadPoolTaskExecutor() {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
        threadPoolTaskExecutor.setCorePoolSize(this.fineractProperties.getTaskExecutor().getTenantUpgradeTaskExecutorCorePoolSize());
        threadPoolTaskExecutor.setMaxPoolSize(this.fineractProperties.getTaskExecutor().getTenantUpgradeTaskExecutorMaxPoolSize());
        threadPoolTaskExecutor.setQueueCapacity(this.fineractProperties.getTaskExecutor().getTenantUpgradeTaskExecutorQueueCapacity());
        threadPoolTaskExecutor.initialize();
        return threadPoolTaskExecutor;
    }

    private void upgradeIndividualTenant(FineractPlatformTenant tenant) throws LiquibaseException {
        log.info("Upgrade for tenant {} has started", (Object)tenant.getTenantIdentifier());
        try (HikariDataSource tenantDataSource = this.tenantDataSourceFactory.create(tenant);){
            if (this.databaseStateVerifier.isFirstLiquibaseMigration((DataSource)tenantDataSource)) {
                ExtendedSpringLiquibase liquibase = this.liquibaseFactory.create((DataSource)tenantDataSource, new String[]{TENANT_DB_CONTEXT, CUSTOM_CHANGELOG_CONTEXT, INITIAL_SWITCH_CONTEXT, tenant.getTenantIdentifier()});
                this.applyInitialLiquibase((DataSource)tenantDataSource, liquibase, tenant.getTenantIdentifier(), ds -> !this.databaseStateVerifier.isTenantOnLatestUpgradableVersion(ds));
            }
            ExtendedSpringLiquibase tenantLiquibase = this.liquibaseFactory.create((DataSource)tenantDataSource, new String[]{TENANT_DB_CONTEXT, CUSTOM_CHANGELOG_CONTEXT, tenant.getTenantIdentifier()});
            tenantLiquibase.afterPropertiesSet();
            log.info("Upgrade for tenant {} has finished", (Object)tenant.getTenantIdentifier());
        }
    }

    private void applyInitialLiquibase(DataSource dataSource, ExtendedSpringLiquibase liquibase, String id, Function<DataSource, Boolean> isUpgradableFn) throws LiquibaseException {
        if (this.databaseStateVerifier.isFlywayPresent(dataSource)) {
            if (isUpgradableFn.apply(dataSource).booleanValue()) {
                log.error("Cannot proceed with upgrading database {}", (Object)id);
                log.error("It seems the database doesn't have the latest schema changes applied until the 1.6 release");
                throw new SchemaUpgradeNeededException("Make sure to upgrade to Fineract 1.6 first and then to a newer version");
            }
            log.info("This is the first Liquibase migration for {}. We'll sync the changelog for you and then apply everything else", (Object)id);
            liquibase.changeLogSync();
            log.info("Liquibase changelog sync is complete");
        } else {
            liquibase.afterPropertiesSet();
        }
    }

    @Generated
    public TenantDatabaseUpgradeService(TenantDetailsService tenantDetailsService, @Qualifier(value="hikariTenantDataSource") DataSource tenantDataSource, FineractProperties fineractProperties, TenantDatabaseStateVerifier databaseStateVerifier, ExtendedSpringLiquibaseFactory liquibaseFactory, TenantDataSourceFactory tenantDataSourceFactory, Environment environment, List<CustomTaskChange> customTaskChangesForDependencyInjection) {
        this.tenantDetailsService = tenantDetailsService;
        this.tenantDataSource = tenantDataSource;
        this.fineractProperties = fineractProperties;
        this.databaseStateVerifier = databaseStateVerifier;
        this.liquibaseFactory = liquibaseFactory;
        this.tenantDataSourceFactory = tenantDataSourceFactory;
        this.environment = environment;
        this.customTaskChangesForDependencyInjection = customTaskChangesForDependencyInjection;
    }

    static {
        System.setProperty("liquibase.analytics.enabled", "false");
    }
}

