/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.core.jersey;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.util.ArrayList;
import java.util.List;
import org.apache.fineract.infrastructure.core.jersey.converter.JsonConverter;
import org.apache.fineract.infrastructure.core.jersey.serializer.JacksonDeserializerAdapter;
import org.apache.fineract.infrastructure.core.jersey.serializer.JacksonSerializerAdapter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

@Configuration
public class JerseyJacksonConverterConfig {
    @Bean
    public MappingJackson2HttpMessageConverter jacksonHttpConverter(List<JsonSerializer<?>> serializers, List<JsonDeserializer<?>> deserializers, List<JsonConverter<?>> jsonConverters) {
        ArrayList mergedSerializers = new ArrayList(serializers);
        mergedSerializers.addAll(jsonConverters.stream().map(JacksonSerializerAdapter::new).toList());
        ArrayList mergedDeserializers = new ArrayList(deserializers);
        mergedDeserializers.addAll(jsonConverters.stream().map(JacksonDeserializerAdapter::new).toList());
        return new MappingJackson2HttpMessageConverter(new Jackson2ObjectMapperBuilder().indentOutput(true).serializers(mergedSerializers.toArray(new JsonSerializer[0])).deserializers(mergedDeserializers.toArray(new JsonDeserializer[0])).serializationInclusion(JsonInclude.Include.NON_NULL).featuresToEnable(new Object[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS}).modulesToInstall(new Module[]{new ParameterNamesModule()}).build());
    }
}

