/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.core.config.cache;

import java.time.Duration;
import javax.cache.Caching;
import javax.cache.spi.CachingProvider;
import org.apache.fineract.infrastructure.core.config.cache.SpecifiedCacheSupportingCacheManager;
import org.apache.fineract.infrastructure.core.config.cache.TransactionBoundCacheManager;
import org.ehcache.config.Builder;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.ExpiryPolicyBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.jsr107.Eh107Configuration;
import org.springframework.cache.CacheManager;
import org.springframework.cache.jcache.JCacheCacheManager;
import org.springframework.cache.support.NoOpCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CacheConfig {
    public static final String CONFIG_BY_NAME_CACHE_NAME = "configByName";

    @Bean
    public TransactionBoundCacheManager defaultCacheManager(JCacheCacheManager ehCacheManager) {
        SpecifiedCacheSupportingCacheManager cacheManager = new SpecifiedCacheSupportingCacheManager();
        cacheManager.setNoOpCacheManager(new NoOpCacheManager());
        cacheManager.setDelegateCacheManager(ehCacheManager);
        cacheManager.setSupportedCaches(new String[]{CONFIG_BY_NAME_CACHE_NAME});
        return new TransactionBoundCacheManager((CacheManager)cacheManager);
    }

    @Bean
    public JCacheCacheManager ehCacheManager() {
        JCacheCacheManager jCacheCacheManager = new JCacheCacheManager();
        jCacheCacheManager.setCacheManager(this.getInternalEhCacheManager());
        return jCacheCacheManager;
    }

    private javax.cache.CacheManager getInternalEhCacheManager() {
        CachingProvider provider = Caching.getCachingProvider();
        javax.cache.CacheManager cacheManager = provider.getCacheManager();
        javax.cache.configuration.Configuration defaultTemplate = Eh107Configuration.fromEhcacheCacheConfiguration((CacheConfiguration)CacheConfigurationBuilder.newCacheConfigurationBuilder(Object.class, Object.class, (Builder)ResourcePoolsBuilder.heap((long)10000L)).withExpiry(ExpiryPolicyBuilder.noExpiration()).build());
        if (cacheManager.getCache("users") == null) {
            cacheManager.createCache("users", defaultTemplate);
        }
        if (cacheManager.getCache("usersByUsername") == null) {
            cacheManager.createCache("usersByUsername", defaultTemplate);
        }
        if (cacheManager.getCache("tenantsById") == null) {
            cacheManager.createCache("tenantsById", defaultTemplate);
        }
        if (cacheManager.getCache("offices") == null) {
            cacheManager.createCache("offices", defaultTemplate);
        }
        if (cacheManager.getCache("officesForDropdown") == null) {
            cacheManager.createCache("officesForDropdown", defaultTemplate);
        }
        if (cacheManager.getCache("officesById") == null) {
            cacheManager.createCache("officesById", defaultTemplate);
        }
        if (cacheManager.getCache("charges") == null) {
            cacheManager.createCache("charges", defaultTemplate);
        }
        if (cacheManager.getCache("funds") == null) {
            cacheManager.createCache("funds", defaultTemplate);
        }
        if (cacheManager.getCache("code_values") == null) {
            cacheManager.createCache("code_values", defaultTemplate);
        }
        if (cacheManager.getCache("codes") == null) {
            cacheManager.createCache("codes", defaultTemplate);
        }
        if (cacheManager.getCache("hooks") == null) {
            cacheManager.createCache("hooks", defaultTemplate);
        }
        if (cacheManager.getCache("tfConfig") == null) {
            cacheManager.createCache("tfConfig", defaultTemplate);
        }
        if (cacheManager.getCache(CONFIG_BY_NAME_CACHE_NAME) == null) {
            cacheManager.createCache(CONFIG_BY_NAME_CACHE_NAME, defaultTemplate);
        }
        javax.cache.configuration.Configuration accessTokenTemplate = Eh107Configuration.fromEhcacheCacheConfiguration((CacheConfiguration)CacheConfigurationBuilder.newCacheConfigurationBuilder(Object.class, Object.class, (Builder)ResourcePoolsBuilder.heap((long)10000L)).withExpiry(ExpiryPolicyBuilder.timeToIdleExpiration((Duration)Duration.ofHours(2L))).build());
        if (cacheManager.getCache("userTFAccessToken") == null) {
            cacheManager.createCache("userTFAccessToken", accessTokenTemplate);
        }
        return cacheManager;
    }
}

