/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.core.auditing;

import org.apache.fineract.infrastructure.core.auditing.CustomDateTimeProvider;
import org.apache.fineract.infrastructure.core.domain.AbstractAuditableWithUTCDateTimeCustom;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.auditing.AuditingHandler;
import org.springframework.data.auditing.DateTimeProvider;
import org.springframework.data.domain.AuditorAware;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.util.Assert;

public class CustomAuditingHandler
extends AuditingHandler {
    public CustomAuditingHandler(PersistentEntities entities) {
        super(entities);
    }

    public CustomAuditingHandler(MappingContext<? extends PersistentEntity<?, ?>, ? extends PersistentProperty<?>> mappingContext, AuditorAware<?> auditorAware) {
        this(PersistentEntities.of((MappingContext[])new MappingContext[]{mappingContext}));
        this.setAuditorAware(auditorAware);
    }

    private DateTimeProvider fetchDateTimeProvider(Object bean) {
        if (bean instanceof AbstractAuditableWithUTCDateTimeCustom) {
            return CustomDateTimeProvider.UTC;
        }
        return CustomDateTimeProvider.INSTANCE;
    }

    @NotNull
    public <T> T markCreated(@NotNull T source) {
        Assert.notNull(source, (String)"Source entity must not be null");
        this.setDateTimeProvider(this.fetchDateTimeProvider(source));
        return (T)super.markCreated(source);
    }

    @NotNull
    public <T> T markModified(@NotNull T source) {
        Assert.notNull(source, (String)"Source entity must not be null");
        this.setDateTimeProvider(this.fetchDateTimeProvider(source));
        return (T)super.markModified(source);
    }
}

