/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.configuration.service;

import java.util.List;
import org.apache.fineract.infrastructure.configuration.data.GlobalConfigurationData;
import org.apache.fineract.infrastructure.configuration.data.GlobalConfigurationPropertyData;
import org.apache.fineract.infrastructure.configuration.service.ConfigurationReadPlatformService;
import org.apache.fineract.infrastructure.configuration.service.ConfigurationReadPlatformServiceImpl;
import org.apache.fineract.infrastructure.dataqueries.api.DataTableApiConstant;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class ConfigurationReadPlatformServiceImpl
implements ConfigurationReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final PlatformSecurityContext context;
    private final RowMapper<GlobalConfigurationPropertyData> rm;

    @Autowired
    public ConfigurationReadPlatformServiceImpl(PlatformSecurityContext context, JdbcTemplate jdbcTemplate) {
        this.context = context;
        this.jdbcTemplate = jdbcTemplate;
        this.rm = new GlobalConfigurationRowMapper();
    }

    public GlobalConfigurationData retrieveGlobalConfiguration(boolean survey) {
        Object[] objectArray;
        this.context.authenticatedUser();
        Object sql = "SELECT c.id, c.name, c.enabled, c.value, c.date_value, c.description,c.string_value, c.is_trap_door FROM c_configuration c ";
        if (survey) {
            sql = (String)sql + " JOIN x_registered_table on x_registered_table.registered_table_name = c.name ";
            sql = (String)sql + " WHERE x_registered_table.category = ?";
        }
        sql = (String)sql + "  order by c.id";
        if (survey) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = DataTableApiConstant.CATEGORY_PPI;
        } else {
            objectArray = new Object[]{};
        }
        List globalConfiguration = this.jdbcTemplate.query((String)sql, this.rm, objectArray);
        return new GlobalConfigurationData().setGlobalConfiguration(globalConfiguration);
    }

    public GlobalConfigurationPropertyData retrieveGlobalConfiguration(String name) {
        this.context.authenticatedUser();
        String sql = "SELECT c.id, c.name, c.enabled, c.value, c.date_value, c.string_value, c.description, c.is_trap_door FROM c_configuration c where c.name=? order by c.id";
        GlobalConfigurationPropertyData globalConfiguration = (GlobalConfigurationPropertyData)this.jdbcTemplate.queryForObject("SELECT c.id, c.name, c.enabled, c.value, c.date_value, c.string_value, c.description, c.is_trap_door FROM c_configuration c where c.name=? order by c.id", this.rm, new Object[]{name});
        return globalConfiguration;
    }

    public GlobalConfigurationPropertyData retrieveGlobalConfiguration(Long configId) {
        this.context.authenticatedUser();
        String sql = "SELECT c.id, c.name, c.enabled, c.value, c.date_value, c.string_value ,c.description, c.is_trap_door FROM c_configuration c where c.id=? order by c.id";
        GlobalConfigurationPropertyData globalConfiguration = (GlobalConfigurationPropertyData)this.jdbcTemplate.queryForObject("SELECT c.id, c.name, c.enabled, c.value, c.date_value, c.string_value ,c.description, c.is_trap_door FROM c_configuration c where c.id=? order by c.id", this.rm, new Object[]{configId});
        return globalConfiguration;
    }
}

