/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.campaigns.email.service;

import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.campaigns.email.data.EmailConfigurationValidator;
import org.apache.fineract.infrastructure.campaigns.email.domain.EmailConfiguration;
import org.apache.fineract.infrastructure.campaigns.email.domain.EmailConfigurationRepository;
import org.apache.fineract.infrastructure.campaigns.email.exception.EmailConfigurationSMTPUsernameNotValid;
import org.apache.fineract.infrastructure.campaigns.email.service.EmailConfigurationWritePlatformService;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.springframework.stereotype.Service;

@Service
public class EmailConfigurationWritePlatformServiceImpl
implements EmailConfigurationWritePlatformService {
    private final PlatformSecurityContext context;
    private final EmailConfigurationRepository repository;
    private final EmailConfigurationValidator emailConfigurationValidator;

    public CommandProcessingResult update(JsonCommand command) {
        this.context.authenticatedUser();
        this.emailConfigurationValidator.validateUpdateConfiguration(command.json());
        String smtpUsername = command.stringValueOfParameterNamed("SMTP_USERNAME");
        if (!this.emailConfigurationValidator.isValidEmail(smtpUsername)) {
            throw new EmailConfigurationSMTPUsernameNotValid(smtpUsername);
        }
        HashMap<String, String> changes = new HashMap<String, String>(4);
        List configurations = this.repository.findAll();
        for (EmailConfiguration config : configurations) {
            if (config.getName() == null) continue;
            String value = command.stringValueOfParameterNamed(config.getName());
            config.setValue(value);
            changes.put(config.getName(), value);
            this.repository.saveAndFlush((Object)config);
        }
        return new CommandProcessingResultBuilder().with(changes).build();
    }

    @Generated
    public EmailConfigurationWritePlatformServiceImpl(PlatformSecurityContext context, EmailConfigurationRepository repository, EmailConfigurationValidator emailConfigurationValidator) {
        this.context = context;
        this.repository = repository;
        this.emailConfigurationValidator = emailConfigurationValidator;
    }
}

