/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.util.HashSet;
import org.apache.fineract.infrastructure.bulkimport.data.BulkImportEvent;
import org.apache.fineract.infrastructure.bulkimport.data.Count;
import org.apache.fineract.infrastructure.bulkimport.data.GlobalEntityType;
import org.apache.fineract.infrastructure.bulkimport.domain.ImportDocument;
import org.apache.fineract.infrastructure.bulkimport.domain.ImportDocumentRepository;
import org.apache.fineract.infrastructure.bulkimport.importhandler.ImportHandler;
import org.apache.fineract.infrastructure.bulkimport.service.BulkImportEventListener;
import org.apache.fineract.infrastructure.core.domain.FineractContext;
import org.apache.fineract.infrastructure.core.exception.GeneralPlatformDomainRuleException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.infrastructure.core.service.tenant.TenantDetailsService;
import org.apache.fineract.infrastructure.documentmanagement.command.DocumentCommand;
import org.apache.fineract.infrastructure.documentmanagement.domain.Document;
import org.apache.fineract.infrastructure.documentmanagement.service.DocumentWritePlatformService;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Service;

@Service
public class BulkImportEventListener
implements ApplicationListener<BulkImportEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(BulkImportEventListener.class);
    private final TenantDetailsService tenantDetailsService;
    private final ApplicationContext applicationContext;
    private final ImportDocumentRepository importRepository;
    private final DocumentWritePlatformService documentService;

    @Autowired
    public BulkImportEventListener(TenantDetailsService tenantDetailsService, ApplicationContext context, ImportDocumentRepository importRepository, DocumentWritePlatformService documentService) {
        this.tenantDetailsService = tenantDetailsService;
        this.applicationContext = context;
        this.importRepository = importRepository;
        this.documentService = documentService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(BulkImportEvent event) {
        ThreadLocalContextUtil.init((FineractContext)event.getContext());
        ImportHandler importHandler = null;
        ImportDocument importDocument = this.importRepository.findById((Object)event.getImportId()).orElse(null);
        GlobalEntityType entityType = GlobalEntityType.fromInt((int)importDocument.getEntityType());
        switch (1.$SwitchMap$org$apache$fineract$infrastructure$bulkimport$data$GlobalEntityType[entityType.ordinal()]) {
            case 1: {
                importHandler = (ImportHandler)this.applicationContext.getBean("officeImportHandler", ImportHandler.class);
                break;
            }
            case 2: {
                importHandler = (ImportHandler)this.applicationContext.getBean("centerImportHandler", ImportHandler.class);
                break;
            }
            case 3: {
                importHandler = (ImportHandler)this.applicationContext.getBean("chartOfAccountsImportHandler", ImportHandler.class);
                break;
            }
            case 4: {
                importHandler = (ImportHandler)this.applicationContext.getBean("clientEntityImportHandler", ImportHandler.class);
                break;
            }
            case 5: {
                importHandler = (ImportHandler)this.applicationContext.getBean("clientPersonImportHandler", ImportHandler.class);
                break;
            }
            case 6: {
                importHandler = (ImportHandler)this.applicationContext.getBean("fixedDepositImportHandler", ImportHandler.class);
                break;
            }
            case 7: {
                importHandler = (ImportHandler)this.applicationContext.getBean("fixedDepositTransactionImportHandler", ImportHandler.class);
                break;
            }
            case 8: {
                importHandler = (ImportHandler)this.applicationContext.getBean("groupImportHandler", ImportHandler.class);
                break;
            }
            case 9: {
                importHandler = (ImportHandler)this.applicationContext.getBean("guarantorImportHandler", ImportHandler.class);
                break;
            }
            case 10: {
                importHandler = (ImportHandler)this.applicationContext.getBean("journalEntriesImportHandler", ImportHandler.class);
                break;
            }
            case 11: {
                importHandler = (ImportHandler)this.applicationContext.getBean("loanImportHandler", ImportHandler.class);
                break;
            }
            case 12: {
                importHandler = (ImportHandler)this.applicationContext.getBean("loanRepaymentImportHandler", ImportHandler.class);
                break;
            }
            case 13: {
                importHandler = (ImportHandler)this.applicationContext.getBean("recurringDepositImportHandler", ImportHandler.class);
                break;
            }
            case 14: {
                importHandler = (ImportHandler)this.applicationContext.getBean("recurringDepositTransactionImportHandler", ImportHandler.class);
                break;
            }
            case 15: {
                importHandler = (ImportHandler)this.applicationContext.getBean("savingsImportHandler", ImportHandler.class);
                break;
            }
            case 16: {
                importHandler = (ImportHandler)this.applicationContext.getBean("savingsTransactionImportHandler", ImportHandler.class);
                break;
            }
            case 17: {
                importHandler = (ImportHandler)this.applicationContext.getBean("sharedAccountImportHandler", ImportHandler.class);
                break;
            }
            case 18: {
                importHandler = (ImportHandler)this.applicationContext.getBean("staffImportHandler", ImportHandler.class);
                break;
            }
            case 19: {
                importHandler = (ImportHandler)this.applicationContext.getBean("userImportHandler", ImportHandler.class);
                break;
            }
            default: {
                throw new GeneralPlatformDomainRuleException("error.msg.unable.to.find.resource", "Unable to find requested resource", new Object[0]);
            }
        }
        Workbook workbook = event.getWorkbook();
        Count count = importHandler.process(workbook, event.getLocale(), event.getDateFormat());
        importDocument.update(DateUtils.getLocalDateTimeOfTenant(), count.getSuccessCount(), count.getErrorCount());
        this.importRepository.saveAndFlush((Object)importDocument);
        HashSet<String> modifiedParams = new HashSet<String>();
        modifiedParams.add("fileName");
        modifiedParams.add("size");
        modifiedParams.add("type");
        modifiedParams.add("location");
        Document document = importDocument.getDocument();
        DocumentCommand documentCommand = new DocumentCommand(modifiedParams, (Long)document.getId(), entityType.name(), null, document.getName(), document.getFileName(), document.getSize(), URLConnection.guessContentTypeFromName(document.getFileName()), null, null);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            try {
                workbook.write((OutputStream)bos);
            }
            finally {
                bos.close();
            }
        }
        catch (IOException io) {
            LOG.error("Problem occurred in onApplicationEvent function", (Throwable)io);
        }
        byte[] bytes = bos.toByteArray();
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        this.documentService.updateDocument(documentCommand, (InputStream)bis);
    }
}

