/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.populator.fixeddeposits;

import java.util.List;
import org.apache.fineract.infrastructure.bulkimport.constants.TemplatePopulateImportConstants;
import org.apache.fineract.infrastructure.bulkimport.populator.AbstractWorkbookPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.ClientSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.FixedDepositProductSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.OfficeSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.PersonnelSheetPopulator;
import org.apache.fineract.portfolio.savings.data.FixedDepositProductData;
import org.apache.poi.hssf.usermodel.HSSFDataValidationHelper;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedDepositWorkbookPopulator
extends AbstractWorkbookPopulator {
    private static final Logger LOG = LoggerFactory.getLogger(FixedDepositWorkbookPopulator.class);
    private final OfficeSheetPopulator officeSheetPopulator;
    private final ClientSheetPopulator clientSheetPopulator;
    private final PersonnelSheetPopulator personnelSheetPopulator;
    private final FixedDepositProductSheetPopulator productSheetPopulator;

    public FixedDepositWorkbookPopulator(OfficeSheetPopulator officeSheetPopulator, ClientSheetPopulator clientSheetPopulator, PersonnelSheetPopulator personnelSheetPopulator, FixedDepositProductSheetPopulator fixedDepositProductSheetPopulator) {
        this.officeSheetPopulator = officeSheetPopulator;
        this.clientSheetPopulator = clientSheetPopulator;
        this.personnelSheetPopulator = personnelSheetPopulator;
        this.productSheetPopulator = fixedDepositProductSheetPopulator;
    }

    public void populate(Workbook workbook, String dateFormat) {
        Sheet fixedDepositSheet = workbook.createSheet("FixedDeposit");
        this.officeSheetPopulator.populate(workbook, dateFormat);
        this.clientSheetPopulator.populate(workbook, dateFormat);
        this.personnelSheetPopulator.populate(workbook, dateFormat);
        this.productSheetPopulator.populate(workbook, dateFormat);
        this.setRules(fixedDepositSheet, dateFormat);
        this.setDefaults(fixedDepositSheet, dateFormat);
        this.setClientAndGroupDateLookupTable(fixedDepositSheet, this.clientSheetPopulator.getClients(), null, 31, 32, TemplatePopulateImportConstants.CONTAINS_CLIENT_EXTERNAL_ID == false, dateFormat);
        this.setLayout(fixedDepositSheet);
    }

    private void setRules(Sheet worksheet, String dateFormat) {
        CellRangeAddressList officeNameRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 0, 0);
        CellRangeAddressList clientNameRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 1, 1);
        CellRangeAddressList productNameRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 2, 2);
        CellRangeAddressList fieldOfficerRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 3, 3);
        CellRangeAddressList submittedDateRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 4, 4);
        CellRangeAddressList approvedDateRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 5, 5);
        CellRangeAddressList activationDateRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 6, 6);
        CellRangeAddressList interestCompudingPeriodRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 7, 7);
        CellRangeAddressList interestPostingPeriodRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 8, 8);
        CellRangeAddressList interestCalculationRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 9, 9);
        CellRangeAddressList interestCalculationDaysInYearRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 10, 10);
        CellRangeAddressList lockinPeriodFrequencyRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 12, 12);
        CellRangeAddressList depositAmountRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 13, 13);
        CellRangeAddressList depositPeriodTypeRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 15, 15);
        HSSFDataValidationHelper validationHelper = new HSSFDataValidationHelper((HSSFSheet)worksheet);
        this.setNames(worksheet);
        DataValidationConstraint officeNameConstraint = validationHelper.createFormulaListConstraint("Office");
        DataValidationConstraint clientNameConstraint = validationHelper.createFormulaListConstraint("INDIRECT(CONCATENATE(\"Client_\",$A1))");
        DataValidationConstraint productNameConstraint = validationHelper.createFormulaListConstraint("Products");
        DataValidationConstraint fieldOfficerNameConstraint = validationHelper.createFormulaListConstraint("INDIRECT(CONCATENATE(\"Staff_\",$A1))");
        DataValidationConstraint submittedDateConstraint = validationHelper.createDateConstraint(0, "=VLOOKUP($B1,$AF$2:$AG$" + (this.clientSheetPopulator.getClientsSize() + 1) + ",2,FALSE)", "=TODAY()", dateFormat);
        DataValidationConstraint approvalDateConstraint = validationHelper.createDateConstraint(0, "=$E1", "=TODAY()", dateFormat);
        DataValidationConstraint activationDateConstraint = validationHelper.createDateConstraint(0, "=$F1", "=TODAY()", dateFormat);
        DataValidationConstraint interestCompudingPeriodConstraint = validationHelper.createExplicitListConstraint(new String[]{"Daily", "Monthly", "Quarterly", "Semi-Annual", "Annually"});
        DataValidationConstraint interestPostingPeriodConstraint = validationHelper.createExplicitListConstraint(new String[]{"Monthly", "Quarterly", "BiAnnual", "Annually"});
        DataValidationConstraint interestCalculationConstraint = validationHelper.createExplicitListConstraint(new String[]{"Daily Balance", "Average Daily Balance"});
        DataValidationConstraint interestCalculationDaysInYearConstraint = validationHelper.createExplicitListConstraint(new String[]{"360 Days", "365 Days"});
        DataValidationConstraint frequency = validationHelper.createExplicitListConstraint(new String[]{"Days", "Weeks", "Months", "Years"});
        DataValidationConstraint depositConstraint = validationHelper.createDecimalConstraint(6, "=INDIRECT(CONCATENATE(\"Min_Deposit_\",$C1))", null);
        DataValidation officeValidation = validationHelper.createValidation(officeNameConstraint, officeNameRange);
        DataValidation clientValidation = validationHelper.createValidation(clientNameConstraint, clientNameRange);
        DataValidation productNameValidation = validationHelper.createValidation(productNameConstraint, productNameRange);
        DataValidation fieldOfficerValidation = validationHelper.createValidation(fieldOfficerNameConstraint, fieldOfficerRange);
        DataValidation interestCompudingPeriodValidation = validationHelper.createValidation(interestCompudingPeriodConstraint, interestCompudingPeriodRange);
        DataValidation interestPostingPeriodValidation = validationHelper.createValidation(interestPostingPeriodConstraint, interestPostingPeriodRange);
        DataValidation interestCalculationValidation = validationHelper.createValidation(interestCalculationConstraint, interestCalculationRange);
        DataValidation interestCalculationDaysInYearValidation = validationHelper.createValidation(interestCalculationDaysInYearConstraint, interestCalculationDaysInYearRange);
        DataValidation lockinPeriodFrequencyValidation = validationHelper.createValidation(frequency, lockinPeriodFrequencyRange);
        DataValidation depositPeriodTypeValidation = validationHelper.createValidation(frequency, depositPeriodTypeRange);
        DataValidation submittedDateValidation = validationHelper.createValidation(submittedDateConstraint, submittedDateRange);
        DataValidation approvalDateValidation = validationHelper.createValidation(approvalDateConstraint, approvedDateRange);
        DataValidation activationDateValidation = validationHelper.createValidation(activationDateConstraint, activationDateRange);
        DataValidation depositAmountValidation = validationHelper.createValidation(depositConstraint, depositAmountRange);
        worksheet.addValidationData(officeValidation);
        worksheet.addValidationData(clientValidation);
        worksheet.addValidationData(productNameValidation);
        worksheet.addValidationData(fieldOfficerValidation);
        worksheet.addValidationData(submittedDateValidation);
        worksheet.addValidationData(approvalDateValidation);
        worksheet.addValidationData(activationDateValidation);
        worksheet.addValidationData(interestCompudingPeriodValidation);
        worksheet.addValidationData(interestPostingPeriodValidation);
        worksheet.addValidationData(interestCalculationValidation);
        worksheet.addValidationData(interestCalculationDaysInYearValidation);
        worksheet.addValidationData(lockinPeriodFrequencyValidation);
        worksheet.addValidationData(depositPeriodTypeValidation);
        worksheet.addValidationData(depositAmountValidation);
    }

    private void setNames(Sheet worksheet) {
        Workbook savingsWorkbook = worksheet.getWorkbook();
        List officeNames = this.officeSheetPopulator.getOfficeNames();
        List products = this.productSheetPopulator.getProducts();
        Name officeGroup = savingsWorkbook.createName();
        officeGroup.setNameName("Office");
        officeGroup.setRefersToFormula("Offices!$B$2:$B$" + (officeNames.size() + 1));
        Integer i = 0;
        while (i < officeNames.size()) {
            Object officeNameToBeginEndIndexesOfClients = (Integer[])this.clientSheetPopulator.getOfficeNameToBeginEndIndexesOfClients().get(i);
            Integer[] officeNameToBeginEndIndexesOfStaff = (Integer[])this.personnelSheetPopulator.getOfficeNameToBeginEndIndexesOfStaff().get(i);
            Name clientName = savingsWorkbook.createName();
            Name fieldOfficerName = savingsWorkbook.createName();
            if (officeNameToBeginEndIndexesOfStaff != null) {
                this.setSanitized(fieldOfficerName, "Staff_" + (String)officeNames.get(i));
                fieldOfficerName.setRefersToFormula("Staff!$B$" + officeNameToBeginEndIndexesOfStaff[0] + ":$B$" + officeNameToBeginEndIndexesOfStaff[1]);
            }
            if (officeNameToBeginEndIndexesOfClients != null) {
                this.setSanitized(clientName, "Client_" + (String)officeNames.get(i));
                clientName.setRefersToFormula("Clients!$B$" + officeNameToBeginEndIndexesOfClients[0] + ":$B$" + officeNameToBeginEndIndexesOfClients[1]);
            }
            officeNameToBeginEndIndexesOfClients = i;
            i = i + 1;
        }
        Name productGroup = savingsWorkbook.createName();
        productGroup.setNameName("Products");
        productGroup.setRefersToFormula("Products!$B$2:$B$" + (this.productSheetPopulator.getProductsSize() + 1));
        Integer i2 = 0;
        while (i2 < products.size()) {
            Name interestCompoundingPeriodName = savingsWorkbook.createName();
            Name interestPostingPeriodName = savingsWorkbook.createName();
            Name interestCalculationName = savingsWorkbook.createName();
            Name daysInYearName = savingsWorkbook.createName();
            Name lockinPeriodName = savingsWorkbook.createName();
            Name lockinPeriodFrequencyName = savingsWorkbook.createName();
            Name depositName = savingsWorkbook.createName();
            Name minDepositName = savingsWorkbook.createName();
            Name maxDepositName = savingsWorkbook.createName();
            Name minDepositTermTypeName = savingsWorkbook.createName();
            FixedDepositProductData product = (FixedDepositProductData)products.get(i2);
            String productName = product.getName().replaceAll("[ ]", "_");
            this.setSanitized(interestCompoundingPeriodName, "Interest_Compouding_" + productName);
            this.setSanitized(interestPostingPeriodName, "Interest_Posting_" + productName);
            this.setSanitized(interestCalculationName, "Interest_Calculation_" + productName);
            this.setSanitized(daysInYearName, "Days_In_Year_" + productName);
            this.setSanitized(minDepositName, "Min_Deposit_" + productName);
            this.setSanitized(maxDepositName, "Max_Deposit_" + productName);
            this.setSanitized(depositName, "Deposit_" + productName);
            interestCompoundingPeriodName.setRefersToFormula("Products!$E$" + (i2 + 2));
            interestPostingPeriodName.setRefersToFormula("Products!$F$" + (i2 + 2));
            interestCalculationName.setRefersToFormula("Products!$G$" + (i2 + 2));
            daysInYearName.setRefersToFormula("Products!$H$" + (i2 + 2));
            depositName.setRefersToFormula("Products!$N$" + (i2 + 2));
            minDepositName.setRefersToFormula("Products!$L$" + (i2 + 2));
            maxDepositName.setRefersToFormula("Products!$M$" + (i2 + 2));
            if (product.getMinDepositTermType() != null) {
                this.setSanitized(minDepositTermTypeName, "Term_Type_" + productName);
                minDepositTermTypeName.setRefersToFormula("Products!$P$" + (i2 + 2));
            }
            if (product.getLockinPeriodFrequency() != null) {
                this.setSanitized(lockinPeriodName, "Lockin_Period_" + productName);
                lockinPeriodName.setRefersToFormula("Products!$I$" + (i2 + 2));
            }
            if (product.getLockinPeriodFrequencyType() != null) {
                this.setSanitized(lockinPeriodFrequencyName, "Lockin_Frequency_" + productName);
                lockinPeriodFrequencyName.setRefersToFormula("Products!$J$" + (i2 + 2));
            }
            Integer n = i2;
            i2 = i2 + 1;
        }
    }

    private void setDefaults(Sheet worksheet, String dateFormat) {
        Workbook workbook = worksheet.getWorkbook();
        CellStyle dateCellStyle = workbook.createCellStyle();
        short df = workbook.createDataFormat().getFormat(dateFormat);
        dateCellStyle.setDataFormat(df);
        try {
            Integer rowNo = 1;
            while (rowNo < 1000) {
                Row row = worksheet.createRow(rowNo.intValue());
                this.writeFormula(7, row, "IF(ISERROR(INDIRECT(CONCATENATE(\"Interest_Compouding_\",$C" + (rowNo + 1) + "))),\"\",INDIRECT(CONCATENATE(\"Interest_Compouding_\",$C" + (rowNo + 1) + ")))");
                this.writeFormula(8, row, "IF(ISERROR(INDIRECT(CONCATENATE(\"Interest_Posting_\",$C" + (rowNo + 1) + "))),\"\",INDIRECT(CONCATENATE(\"Interest_Posting_\",$C" + (rowNo + 1) + ")))");
                this.writeFormula(9, row, "IF(ISERROR(INDIRECT(CONCATENATE(\"Interest_Calculation_\",$C" + (rowNo + 1) + "))),\"\",INDIRECT(CONCATENATE(\"Interest_Calculation_\",$C" + (rowNo + 1) + ")))");
                this.writeFormula(10, row, "IF(ISERROR(INDIRECT(CONCATENATE(\"Days_In_Year_\",$C" + (rowNo + 1) + "))),\"\",INDIRECT(CONCATENATE(\"Days_In_Year_\",$C" + (rowNo + 1) + ")))");
                this.writeFormula(11, row, "IF(ISERROR(INDIRECT(CONCATENATE(\"Lockin_Period_\",$C" + (rowNo + 1) + "))),\"\",INDIRECT(CONCATENATE(\"Lockin_Period_\",$C" + (rowNo + 1) + ")))");
                this.writeFormula(12, row, "IF(ISERROR(INDIRECT(CONCATENATE(\"Lockin_Frequency_\",$C" + (rowNo + 1) + "))),\"\",INDIRECT(CONCATENATE(\"Lockin_Frequency_\",$C" + (rowNo + 1) + ")))");
                this.writeFormula(13, row, "IF(ISERROR(INDIRECT(CONCATENATE(\"Deposit_\",$C" + (rowNo + 1) + "))),\"\",INDIRECT(CONCATENATE(\"Deposit_\",$C" + (rowNo + 1) + ")))");
                this.writeFormula(15, row, "IF(ISERROR(INDIRECT(CONCATENATE(\"Term_Type_\",$C" + (rowNo + 1) + "))),\"\",INDIRECT(CONCATENATE(\"Term_Type_\",$C" + (rowNo + 1) + ")))");
                Integer n = rowNo;
                rowNo = rowNo + 1;
            }
        }
        catch (RuntimeException re) {
            LOG.error("Problem occurred in setDefaults function", (Throwable)re);
        }
    }

    private void setLayout(Sheet worksheet) {
        Row rowHeader = worksheet.createRow(0);
        rowHeader.setHeight((short)500);
        worksheet.setColumnWidth(0, 4000);
        worksheet.setColumnWidth(1, 4000);
        worksheet.setColumnWidth(2, 4000);
        worksheet.setColumnWidth(3, 4000);
        worksheet.setColumnWidth(4, 4000);
        worksheet.setColumnWidth(5, 4000);
        worksheet.setColumnWidth(6, 4000);
        worksheet.setColumnWidth(7, 4000);
        worksheet.setColumnWidth(8, 4000);
        worksheet.setColumnWidth(9, 4000);
        worksheet.setColumnWidth(10, 4000);
        worksheet.setColumnWidth(11, 4000);
        worksheet.setColumnWidth(12, 4000);
        worksheet.setColumnWidth(13, 4000);
        worksheet.setColumnWidth(14, 4000);
        worksheet.setColumnWidth(15, 4000);
        worksheet.setColumnWidth(16, 4000);
        worksheet.setColumnWidth(18, 6000);
        worksheet.setColumnWidth(19, 6000);
        worksheet.setColumnWidth(20, 6000);
        worksheet.setColumnWidth(21, 6000);
        worksheet.setColumnWidth(22, 6000);
        worksheet.setColumnWidth(23, 6000);
        worksheet.setColumnWidth(31, 6000);
        worksheet.setColumnWidth(32, 6000);
        this.writeString(0, rowHeader, "Office Name*");
        this.writeString(1, rowHeader, "Client Name*");
        this.writeString(2, rowHeader, "Product*");
        this.writeString(3, rowHeader, "Field Officer*");
        this.writeString(4, rowHeader, "Submitted On*");
        this.writeString(5, rowHeader, "Approved On*");
        this.writeString(6, rowHeader, "Activation Date*");
        this.writeString(7, rowHeader, "Interest Compounding Period*");
        this.writeString(8, rowHeader, "Interest Posting Period*");
        this.writeString(9, rowHeader, "Interest Calculated*");
        this.writeString(10, rowHeader, "# Days in Year*");
        this.writeString(11, rowHeader, "Locked In For");
        this.writeString(13, rowHeader, "Deposit Amount");
        this.writeString(14, rowHeader, "Deposit Period");
        this.writeString(16, rowHeader, "External Id");
        this.writeString(18, rowHeader, "Charge Id");
        this.writeString(19, rowHeader, "Charged Amount");
        this.writeString(20, rowHeader, "Charged On Date");
        this.writeString(21, rowHeader, "Charge Id");
        this.writeString(22, rowHeader, "Charged Amount");
        this.writeString(23, rowHeader, "Charged On Date");
        this.writeString(24, rowHeader, "Close on Date");
        this.writeString(25, rowHeader, "Action(Account Transfer(200) or cash(100) ");
        this.writeString(26, rowHeader, "Transfered Account No.");
        this.writeString(31, rowHeader, "Client Name");
        this.writeString(32, rowHeader, "Client Activation Date");
    }
}

