/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.populator.client;

import java.util.List;
import org.apache.fineract.infrastructure.bulkimport.populator.AbstractWorkbookPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.OfficeSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.PersonnelSheetPopulator;
import org.apache.fineract.infrastructure.codes.data.CodeValueData;
import org.apache.fineract.organisation.office.data.OfficeData;
import org.apache.poi.hssf.usermodel.HSSFDataValidationHelper;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;

public class ClientPersonWorkbookPopulator
extends AbstractWorkbookPopulator {
    private final OfficeSheetPopulator officeSheetPopulator;
    private final PersonnelSheetPopulator personnelSheetPopulator;
    private final List<CodeValueData> clientTypeCodeValues;
    private final List<CodeValueData> genderCodeValues;
    private final List<CodeValueData> clientClassificationCodeValues;
    private final List<CodeValueData> addressTypesCodeValues;
    private final List<CodeValueData> stateProvinceCodeValues;
    private final List<CodeValueData> countryCodeValues;

    public ClientPersonWorkbookPopulator(OfficeSheetPopulator officeSheetPopulator, PersonnelSheetPopulator personnelSheetPopulator, List<CodeValueData> clientTypeCodeValues, List<CodeValueData> genderCodeValues, List<CodeValueData> clientClassification, List<CodeValueData> addressTypesCodeValues, List<CodeValueData> stateProvinceCodeValues, List<CodeValueData> countryCodeValues) {
        this.officeSheetPopulator = officeSheetPopulator;
        this.personnelSheetPopulator = personnelSheetPopulator;
        this.clientTypeCodeValues = clientTypeCodeValues;
        this.genderCodeValues = genderCodeValues;
        this.clientClassificationCodeValues = clientClassification;
        this.addressTypesCodeValues = addressTypesCodeValues;
        this.stateProvinceCodeValues = stateProvinceCodeValues;
        this.countryCodeValues = countryCodeValues;
    }

    public void populate(Workbook workbook, String dateFormat) {
        Sheet clientSheet = workbook.createSheet("ClientPerson");
        this.personnelSheetPopulator.populate(workbook, dateFormat);
        this.officeSheetPopulator.populate(workbook, dateFormat);
        this.setLayout(clientSheet);
        this.setOfficeDateLookupTable(clientSheet, this.officeSheetPopulator.getOffices(), 35, 36, dateFormat);
        this.setClientDataLookupTable(clientSheet);
        this.setRules(clientSheet, dateFormat);
    }

    private void setClientDataLookupTable(Sheet clientSheet) {
        Row row;
        int rowIndex = 0;
        for (CodeValueData clientTypeCodeValue : this.clientTypeCodeValues) {
            if ((row = clientSheet.getRow(++rowIndex)) == null) {
                row = clientSheet.createRow(rowIndex);
            }
            this.writeString(39, row, clientTypeCodeValue.getName() + "-" + clientTypeCodeValue.getId());
        }
        rowIndex = 0;
        for (CodeValueData clientClassificationCodeValue : this.clientClassificationCodeValues) {
            if ((row = clientSheet.getRow(++rowIndex)) == null) {
                row = clientSheet.createRow(rowIndex);
            }
            this.writeString(38, row, clientClassificationCodeValue.getName() + "-" + clientClassificationCodeValue.getId());
        }
        rowIndex = 0;
        for (CodeValueData genderCodeValue : this.genderCodeValues) {
            if ((row = clientSheet.getRow(++rowIndex)) == null) {
                row = clientSheet.createRow(rowIndex);
            }
            this.writeString(37, row, genderCodeValue.getName() + "-" + genderCodeValue.getId());
        }
        rowIndex = 0;
        for (CodeValueData addressTypeCodeValue : this.addressTypesCodeValues) {
            if ((row = clientSheet.getRow(++rowIndex)) == null) {
                row = clientSheet.createRow(rowIndex);
            }
            this.writeString(40, row, addressTypeCodeValue.getName() + "-" + addressTypeCodeValue.getId());
        }
        rowIndex = 0;
        for (CodeValueData stateCodeValue : this.stateProvinceCodeValues) {
            if ((row = clientSheet.getRow(++rowIndex)) == null) {
                row = clientSheet.createRow(rowIndex);
            }
            this.writeString(41, row, stateCodeValue.getName() + "-" + stateCodeValue.getId());
        }
        rowIndex = 0;
        for (CodeValueData countryCodeValue : this.countryCodeValues) {
            if ((row = clientSheet.getRow(++rowIndex)) == null) {
                row = clientSheet.createRow(rowIndex);
            }
            this.writeString(42, row, countryCodeValue.getName() + "-" + countryCodeValue.getId());
        }
    }

    private void setLayout(Sheet worksheet) {
        Row rowHeader = worksheet.createRow(0);
        rowHeader.setHeight((short)500);
        worksheet.setColumnWidth(0, 6000);
        worksheet.setColumnWidth(1, 6000);
        worksheet.setColumnWidth(2, 6000);
        this.writeString(0, rowHeader, "First Name*");
        this.writeString(1, rowHeader, "Last Name*");
        this.writeString(2, rowHeader, "Middle Name");
        worksheet.setColumnWidth(3, 6000);
        worksheet.setColumnWidth(4, 6000);
        worksheet.setColumnWidth(5, 4000);
        worksheet.setColumnWidth(8, 4000);
        worksheet.setColumnWidth(7, 4000);
        worksheet.setColumnWidth(6, 4000);
        worksheet.setColumnWidth(9, 6000);
        worksheet.setColumnWidth(10, 4000);
        worksheet.setColumnWidth(11, 4000);
        worksheet.setColumnWidth(12, 4000);
        worksheet.setColumnWidth(13, 6000);
        worksheet.setColumnWidth(14, 4000);
        worksheet.setColumnWidth(15, 4000);
        worksheet.setColumnWidth(16, 4000);
        worksheet.setColumnWidth(17, 4000);
        worksheet.setColumnWidth(18, 6000);
        worksheet.setColumnWidth(19, 6000);
        worksheet.setColumnWidth(20, 6000);
        worksheet.setColumnWidth(21, 4000);
        worksheet.setColumnWidth(22, 4000);
        worksheet.setColumnWidth(23, 4000);
        worksheet.setColumnWidth(24, 4000);
        worksheet.setColumnWidth(25, 4000);
        worksheet.setColumnWidth(26, 6000);
        worksheet.setColumnWidth(35, 6000);
        worksheet.setColumnWidth(36, 4000);
        worksheet.setColumnWidth(37, 4000);
        worksheet.setColumnWidth(39, 4000);
        worksheet.setColumnWidth(38, 4000);
        worksheet.setColumnWidth(40, 4000);
        worksheet.setColumnWidth(41, 4000);
        worksheet.setColumnWidth(42, 4000);
        this.writeString(3, rowHeader, "Office Name*");
        this.writeString(4, rowHeader, "Staff Name");
        this.writeString(5, rowHeader, "External ID ");
        this.writeString(8, rowHeader, "Submitted On Date");
        this.writeString(7, rowHeader, "Activation date");
        this.writeString(6, rowHeader, "Active*");
        this.writeString(9, rowHeader, "Mobile number");
        this.writeString(10, rowHeader, "Date of Birth ");
        this.writeString(11, rowHeader, "Client Type ");
        this.writeString(14, rowHeader, "Is a staff memeber ");
        this.writeString(12, rowHeader, "Gender ");
        this.writeString(15, rowHeader, "Address Enabled *");
        this.writeString(13, rowHeader, "Client Classification ");
        this.writeString(16, rowHeader, "Address Type ");
        this.writeString(17, rowHeader, "Street  ");
        this.writeString(18, rowHeader, "Address Line 1");
        this.writeString(19, rowHeader, "Address Line 2");
        this.writeString(20, rowHeader, "Address Line 3 ");
        this.writeString(21, rowHeader, "City ");
        this.writeString(22, rowHeader, "State/ Province ");
        this.writeString(23, rowHeader, "Country ");
        this.writeString(24, rowHeader, "Postal Code ");
        this.writeString(25, rowHeader, "Is active Address ? ");
        this.writeString(26, rowHeader, "All * marked fields are compulsory.");
        this.writeString(35, rowHeader, "Lookup office Name  ");
        this.writeString(36, rowHeader, "Lookup Office Opened Date ");
        this.writeString(37, rowHeader, "Lookup Gender ");
        this.writeString(39, rowHeader, "Lookup Client Types ");
        this.writeString(38, rowHeader, "Lookup Client Classification ");
        this.writeString(40, rowHeader, "Lookup AddressType ");
        this.writeString(41, rowHeader, "Lookup State/Province ");
        this.writeString(42, rowHeader, "Lookup Country ");
    }

    private void setRules(Sheet worksheet, String dateformat) {
        CellRangeAddressList officeNameRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 3, 3);
        CellRangeAddressList staffNameRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 4, 4);
        CellRangeAddressList submittedOnDateRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 8, 8);
        CellRangeAddressList activationDateRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 7, 7);
        CellRangeAddressList activeRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 6, 6);
        CellRangeAddressList clientTypeRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 11, 11);
        CellRangeAddressList dobRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 10, 10);
        CellRangeAddressList isStaffRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 14, 14);
        CellRangeAddressList genderRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 12, 12);
        CellRangeAddressList clientClassificationRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 13, 13);
        CellRangeAddressList enabledAddressRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 15, 15);
        CellRangeAddressList addressTypeRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 16, 16);
        CellRangeAddressList stateProvinceRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 22, 22);
        CellRangeAddressList countryRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 23, 23);
        CellRangeAddressList activeAddressRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 25, 25);
        HSSFDataValidationHelper validationHelper = new HSSFDataValidationHelper((HSSFSheet)worksheet);
        List offices = this.officeSheetPopulator.getOffices();
        this.setNames(worksheet, offices);
        DataValidationConstraint officeNameConstraint = validationHelper.createFormulaListConstraint("Office");
        DataValidationConstraint staffNameConstraint = validationHelper.createFormulaListConstraint("INDIRECT(CONCATENATE(\"Staff_\",$D1))");
        DataValidationConstraint submittedOnDateConstraint = validationHelper.createDateConstraint(7, "=$I1", null, dateformat);
        DataValidationConstraint activationDateConstraint = validationHelper.createDateConstraint(0, "=VLOOKUP($D1,$AJ$2:$AK" + (offices.size() + 1) + ",2,FALSE)", "=TODAY()", dateformat);
        DataValidationConstraint dobDateConstraint = validationHelper.createDateConstraint(7, "=TODAY()", null, dateformat);
        DataValidationConstraint activeConstraint = validationHelper.createExplicitListConstraint(new String[]{"True", "False"});
        DataValidationConstraint clientTypesConstraint = validationHelper.createFormulaListConstraint("ClientTypes");
        DataValidationConstraint isStaffConstraint = validationHelper.createExplicitListConstraint(new String[]{"True", "False"});
        DataValidationConstraint genderConstraint = validationHelper.createFormulaListConstraint("Gender");
        DataValidationConstraint clientClassificationConstraint = validationHelper.createFormulaListConstraint("ClientClassification");
        DataValidationConstraint enabledAddressConstraint = validationHelper.createExplicitListConstraint(new String[]{"True", "False"});
        DataValidationConstraint addressTypeConstraint = validationHelper.createFormulaListConstraint("AddressType");
        DataValidationConstraint stateProvinceConstraint = validationHelper.createFormulaListConstraint("StateProvince");
        DataValidationConstraint countryConstraint = validationHelper.createFormulaListConstraint("Country");
        DataValidationConstraint activeAddressConstraint = validationHelper.createExplicitListConstraint(new String[]{"True", "False"});
        DataValidation officeValidation = validationHelper.createValidation(officeNameConstraint, officeNameRange);
        DataValidation staffValidation = validationHelper.createValidation(staffNameConstraint, staffNameRange);
        DataValidation submittedOnDateValidation = validationHelper.createValidation(submittedOnDateConstraint, submittedOnDateRange);
        DataValidation activationDateValidation = validationHelper.createValidation(activationDateConstraint, activationDateRange);
        DataValidation dobDateValidation = validationHelper.createValidation(dobDateConstraint, dobRange);
        DataValidation activeValidation = validationHelper.createValidation(activeConstraint, activeRange);
        DataValidation clientTypeValidation = validationHelper.createValidation(clientTypesConstraint, clientTypeRange);
        DataValidation isStaffValidation = validationHelper.createValidation(isStaffConstraint, isStaffRange);
        DataValidation genderValidation = validationHelper.createValidation(genderConstraint, genderRange);
        DataValidation clientClassificationValidation = validationHelper.createValidation(clientClassificationConstraint, clientClassificationRange);
        DataValidation enabledAddressValidation = validationHelper.createValidation(enabledAddressConstraint, enabledAddressRange);
        DataValidation addressTypeValidation = validationHelper.createValidation(addressTypeConstraint, addressTypeRange);
        DataValidation stateProvinceValidation = validationHelper.createValidation(stateProvinceConstraint, stateProvinceRange);
        DataValidation countryValidation = validationHelper.createValidation(countryConstraint, countryRange);
        DataValidation activeAddressValidation = validationHelper.createValidation(activeAddressConstraint, activeAddressRange);
        worksheet.addValidationData(activeValidation);
        worksheet.addValidationData(officeValidation);
        worksheet.addValidationData(staffValidation);
        worksheet.addValidationData(activationDateValidation);
        worksheet.addValidationData(submittedOnDateValidation);
        worksheet.addValidationData(dobDateValidation);
        worksheet.addValidationData(clientTypeValidation);
        worksheet.addValidationData(isStaffValidation);
        worksheet.addValidationData(genderValidation);
        worksheet.addValidationData(clientClassificationValidation);
        worksheet.addValidationData(enabledAddressValidation);
        worksheet.addValidationData(addressTypeValidation);
        worksheet.addValidationData(stateProvinceValidation);
        worksheet.addValidationData(countryValidation);
        worksheet.addValidationData(activeAddressValidation);
    }

    private void setNames(Sheet worksheet, List<OfficeData> offices) {
        Workbook clientWorkbook = worksheet.getWorkbook();
        Name officeGroup = clientWorkbook.createName();
        officeGroup.setNameName("Office");
        officeGroup.setRefersToFormula("Offices!$B$2:$B$" + (offices.size() + 1));
        Name clientTypeGroup = clientWorkbook.createName();
        clientTypeGroup.setNameName("ClientTypes");
        clientTypeGroup.setRefersToFormula("ClientPerson!$AN$2:$AN$" + (this.clientTypeCodeValues.size() + 1));
        Name genderGroup = clientWorkbook.createName();
        genderGroup.setNameName("Gender");
        genderGroup.setRefersToFormula("ClientPerson!$AL$2:$AL$" + (this.genderCodeValues.size() + 1));
        Name clientClassficationGroup = clientWorkbook.createName();
        clientClassficationGroup.setNameName("ClientClassification");
        clientClassficationGroup.setRefersToFormula("ClientPerson!$AM$2:$AM$" + (this.clientClassificationCodeValues.size() + 1));
        Name addressTypeGroup = clientWorkbook.createName();
        addressTypeGroup.setNameName("AddressType");
        addressTypeGroup.setRefersToFormula("ClientPerson!$AO$2:$AO$" + (this.addressTypesCodeValues.size() + 1));
        Name stateProvinceGroup = clientWorkbook.createName();
        stateProvinceGroup.setNameName("StateProvince");
        stateProvinceGroup.setRefersToFormula("ClientPerson!$AP$2:$AP$" + (this.stateProvinceCodeValues.size() + 1));
        Name countryGroup = clientWorkbook.createName();
        countryGroup.setNameName("Country");
        countryGroup.setRefersToFormula("ClientPerson!$AQ$2:$AQ$" + (this.countryCodeValues.size() + 1));
        Integer i = 0;
        while (i < offices.size()) {
            Integer[] officeNameToBeginEndIndexesOfStaff = (Integer[])this.personnelSheetPopulator.getOfficeNameToBeginEndIndexesOfStaff().get(i);
            if (officeNameToBeginEndIndexesOfStaff != null) {
                Name name = clientWorkbook.createName();
                this.setSanitized(name, "Staff_" + offices.get(i).getName());
                name.setRefersToFormula("Staff!$B$" + officeNameToBeginEndIndexesOfStaff[0] + ":$B$" + officeNameToBeginEndIndexesOfStaff[1]);
            }
            Integer n = i;
            i = i + 1;
        }
    }
}

