/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.populator.client;

import java.util.List;
import org.apache.fineract.infrastructure.bulkimport.populator.AbstractWorkbookPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.OfficeSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.PersonnelSheetPopulator;
import org.apache.fineract.infrastructure.codes.data.CodeValueData;
import org.apache.fineract.organisation.office.data.OfficeData;
import org.apache.poi.hssf.usermodel.HSSFDataValidationHelper;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;

public class ClientEntityWorkbookPopulator
extends AbstractWorkbookPopulator {
    private final OfficeSheetPopulator officeSheetPopulator;
    private final PersonnelSheetPopulator personnelSheetPopulator;
    private final List<CodeValueData> clientTypeCodeValues;
    private final List<CodeValueData> constitutionCodeValues;
    private final List<CodeValueData> clientClassificationCodeValues;
    private final List<CodeValueData> addressTypesCodeValues;
    private final List<CodeValueData> stateProvinceCodeValues;
    private final List<CodeValueData> countryCodeValues;
    private final List<CodeValueData> mainBusinesslineCodeValues;

    public ClientEntityWorkbookPopulator(OfficeSheetPopulator officeSheetPopulator, PersonnelSheetPopulator personnelSheetPopulator, List<CodeValueData> clientTypeCodeValues, List<CodeValueData> constitutionCodeValues, List<CodeValueData> mainBusinessline, List<CodeValueData> clientClassification, List<CodeValueData> addressTypesCodeValues, List<CodeValueData> stateProvinceCodeValues, List<CodeValueData> countryCodeValues) {
        this.officeSheetPopulator = officeSheetPopulator;
        this.personnelSheetPopulator = personnelSheetPopulator;
        this.clientTypeCodeValues = clientTypeCodeValues;
        this.constitutionCodeValues = constitutionCodeValues;
        this.clientClassificationCodeValues = clientClassification;
        this.addressTypesCodeValues = addressTypesCodeValues;
        this.stateProvinceCodeValues = stateProvinceCodeValues;
        this.countryCodeValues = countryCodeValues;
        this.mainBusinesslineCodeValues = mainBusinessline;
    }

    public void populate(Workbook workbook, String dateFormat) {
        Sheet clientSheet = workbook.createSheet("ClientEntity");
        this.personnelSheetPopulator.populate(workbook, dateFormat);
        this.officeSheetPopulator.populate(workbook, dateFormat);
        this.setLayout(clientSheet);
        this.setOfficeDateLookupTable(clientSheet, this.officeSheetPopulator.getOffices(), 35, 36, dateFormat);
        this.setClientDataLookupTable(clientSheet);
        this.setRules(clientSheet, dateFormat);
    }

    private void setClientDataLookupTable(Sheet clientSheet) {
        Row row;
        int rowIndex = 0;
        for (CodeValueData clientTypeCodeValue : this.clientTypeCodeValues) {
            if ((row = clientSheet.getRow(++rowIndex)) == null) {
                row = clientSheet.createRow(rowIndex);
            }
            this.writeString(39, row, clientTypeCodeValue.getName() + "-" + clientTypeCodeValue.getId());
        }
        rowIndex = 0;
        for (CodeValueData clientClassificationCodeValue : this.clientClassificationCodeValues) {
            if ((row = clientSheet.getRow(++rowIndex)) == null) {
                row = clientSheet.createRow(rowIndex);
            }
            this.writeString(38, row, clientClassificationCodeValue.getName() + "-" + clientClassificationCodeValue.getId());
        }
        rowIndex = 0;
        for (CodeValueData constitutionCodeValue : this.constitutionCodeValues) {
            if ((row = clientSheet.getRow(++rowIndex)) == null) {
                row = clientSheet.createRow(rowIndex);
            }
            this.writeString(37, row, constitutionCodeValue.getName() + "-" + constitutionCodeValue.getId());
        }
        rowIndex = 0;
        for (CodeValueData mainBusinessCodeValue : this.mainBusinesslineCodeValues) {
            if ((row = clientSheet.getRow(++rowIndex)) == null) {
                row = clientSheet.createRow(rowIndex);
            }
            this.writeString(43, row, mainBusinessCodeValue.getName() + "-" + mainBusinessCodeValue.getId());
        }
        rowIndex = 0;
        for (CodeValueData addressTypeCodeValue : this.addressTypesCodeValues) {
            if ((row = clientSheet.getRow(++rowIndex)) == null) {
                row = clientSheet.createRow(rowIndex);
            }
            this.writeString(40, row, addressTypeCodeValue.getName() + "-" + addressTypeCodeValue.getId());
        }
        rowIndex = 0;
        for (CodeValueData stateCodeValue : this.stateProvinceCodeValues) {
            if ((row = clientSheet.getRow(++rowIndex)) == null) {
                row = clientSheet.createRow(rowIndex);
            }
            this.writeString(41, row, stateCodeValue.getName() + "-" + stateCodeValue.getId());
        }
        rowIndex = 0;
        for (CodeValueData countryCodeValue : this.countryCodeValues) {
            if ((row = clientSheet.getRow(++rowIndex)) == null) {
                row = clientSheet.createRow(rowIndex);
            }
            this.writeString(42, row, countryCodeValue.getName() + "-" + countryCodeValue.getId());
        }
    }

    private void setLayout(Sheet worksheet) {
        Row rowHeader = worksheet.createRow(0);
        rowHeader.setHeight((short)500);
        worksheet.setColumnWidth(0, 6000);
        this.writeString(0, rowHeader, "Name*");
        worksheet.setColumnWidth(1, 6000);
        worksheet.setColumnWidth(2, 6000);
        worksheet.setColumnWidth(3, 6000);
        worksheet.setColumnWidth(4, 6000);
        worksheet.setColumnWidth(5, 6000);
        worksheet.setColumnWidth(6, 4000);
        worksheet.setColumnWidth(7, 6000);
        worksheet.setColumnWidth(8, 6000);
        worksheet.setColumnWidth(9, 4000);
        worksheet.setColumnWidth(10, 4000);
        worksheet.setColumnWidth(11, 8000);
        worksheet.setColumnWidth(12, 4000);
        worksheet.setColumnWidth(15, 4000);
        worksheet.setColumnWidth(13, 4000);
        worksheet.setColumnWidth(14, 4000);
        worksheet.setColumnWidth(16, 4000);
        worksheet.setColumnWidth(17, 4000);
        worksheet.setColumnWidth(18, 4000);
        worksheet.setColumnWidth(19, 6000);
        worksheet.setColumnWidth(20, 6000);
        worksheet.setColumnWidth(21, 6000);
        worksheet.setColumnWidth(22, 4000);
        worksheet.setColumnWidth(23, 4000);
        worksheet.setColumnWidth(24, 4000);
        worksheet.setColumnWidth(25, 4000);
        worksheet.setColumnWidth(26, 4000);
        worksheet.setColumnWidth(26, 6000);
        worksheet.setColumnWidth(35, 6000);
        worksheet.setColumnWidth(36, 4000);
        worksheet.setColumnWidth(37, 4000);
        worksheet.setColumnWidth(39, 4000);
        worksheet.setColumnWidth(38, 4000);
        worksheet.setColumnWidth(40, 4000);
        worksheet.setColumnWidth(41, 4000);
        worksheet.setColumnWidth(42, 4000);
        worksheet.setColumnWidth(43, 6000);
        this.writeString(0, rowHeader, "Name");
        this.writeString(1, rowHeader, "Office Name*");
        this.writeString(2, rowHeader, "Staff Name");
        this.writeString(3, rowHeader, "Incorporation Date");
        this.writeString(4, rowHeader, "Incorporation Validity Till Date");
        this.writeString(5, rowHeader, "Mobile number");
        this.writeString(6, rowHeader, "Client Type ");
        this.writeString(7, rowHeader, "Client Classification ");
        this.writeString(8, rowHeader, "Incorporation Number");
        this.writeString(9, rowHeader, "Main Business Line");
        this.writeString(10, rowHeader, "Constitution");
        this.writeString(11, rowHeader, "Remarks");
        this.writeString(12, rowHeader, "External ID ");
        this.writeString(15, rowHeader, "Submitted On Date");
        this.writeString(13, rowHeader, "Active*");
        this.writeString(14, rowHeader, "Activation Date ");
        this.writeString(16, rowHeader, "Address Enabled ");
        this.writeString(17, rowHeader, "Address Type ");
        this.writeString(18, rowHeader, "Street  ");
        this.writeString(19, rowHeader, "Address Line 1");
        this.writeString(20, rowHeader, "Address Line 2");
        this.writeString(21, rowHeader, "Address Line 3");
        this.writeString(22, rowHeader, "City");
        this.writeString(23, rowHeader, "State/ Province");
        this.writeString(24, rowHeader, "Country");
        this.writeString(25, rowHeader, "Postal Code");
        this.writeString(26, rowHeader, "Is active Address ? ");
        this.writeString(26, rowHeader, "All * marked fields are compulsory.");
        this.writeString(35, rowHeader, "Lookup office Name  ");
        this.writeString(36, rowHeader, "Lookup Office Opened Date ");
        this.writeString(37, rowHeader, "Lookup Constitution ");
        this.writeString(39, rowHeader, "Lookup Client Types ");
        this.writeString(38, rowHeader, "Lookup Client Classification ");
        this.writeString(40, rowHeader, "Lookup AddressType ");
        this.writeString(41, rowHeader, "Lookup State/Province ");
        this.writeString(42, rowHeader, "Lookup Country ");
        this.writeString(43, rowHeader, "Lookup Business Line");
    }

    private void setRules(Sheet worksheet, String dateFormat) {
        CellRangeAddressList officeNameRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 1, 1);
        CellRangeAddressList staffNameRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 2, 2);
        CellRangeAddressList submittedOnDateRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 15, 15);
        CellRangeAddressList dateRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 14, 14);
        CellRangeAddressList activeRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 13, 13);
        CellRangeAddressList clientTypeRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 6, 6);
        CellRangeAddressList constitutionRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 10, 10);
        CellRangeAddressList mainBusinessLineRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 9, 9);
        CellRangeAddressList clientClassificationRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 7, 7);
        CellRangeAddressList enabledAddressRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 16, 16);
        CellRangeAddressList addressTypeRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 17, 17);
        CellRangeAddressList stateProvinceRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 23, 23);
        CellRangeAddressList countryRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 24, 24);
        CellRangeAddressList activeAddressRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 26, 26);
        CellRangeAddressList incorporateDateRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 3, 3);
        CellRangeAddressList incorporateDateTillRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 4, 4);
        HSSFDataValidationHelper validationHelper = new HSSFDataValidationHelper((HSSFSheet)worksheet);
        List offices = this.officeSheetPopulator.getOffices();
        this.setNames(worksheet, offices);
        DataValidationConstraint officeNameConstraint = validationHelper.createFormulaListConstraint("Office");
        DataValidationConstraint staffNameConstraint = validationHelper.createFormulaListConstraint("INDIRECT(CONCATENATE(\"Staff_\",$B1))");
        DataValidationConstraint submittedOnDateConstraint = validationHelper.createDateConstraint(7, "=$O1", null, dateFormat);
        DataValidationConstraint activationDateConstraint = validationHelper.createDateConstraint(0, "=VLOOKUP($B1,$AJ$2:$AK" + (offices.size() + 1) + ",2,FALSE)", "=TODAY()", dateFormat);
        DataValidationConstraint activeConstraint = validationHelper.createExplicitListConstraint(new String[]{"True", "False"});
        DataValidationConstraint clientTypesConstraint = validationHelper.createFormulaListConstraint("ClientTypes");
        DataValidationConstraint constitutionConstraint = validationHelper.createFormulaListConstraint("Constitution");
        DataValidationConstraint mainBusinessLineConstraint = validationHelper.createFormulaListConstraint("MainBusinessLine");
        DataValidationConstraint clientClassificationConstraint = validationHelper.createFormulaListConstraint("ClientClassification");
        DataValidationConstraint enabledAddressConstraint = validationHelper.createExplicitListConstraint(new String[]{"True", "False"});
        DataValidationConstraint addressTypeConstraint = validationHelper.createFormulaListConstraint("AddressType");
        DataValidationConstraint stateProvinceConstraint = validationHelper.createFormulaListConstraint("StateProvince");
        DataValidationConstraint countryConstraint = validationHelper.createFormulaListConstraint("Country");
        DataValidationConstraint activeAddressConstraint = validationHelper.createExplicitListConstraint(new String[]{"True", "False"});
        DataValidationConstraint incorpDateConstraint = validationHelper.createDateConstraint(7, "=TODAY()", null, dateFormat);
        DataValidationConstraint incorpDateTillConstraint = validationHelper.createDateConstraint(6, "=TODAY()", null, dateFormat);
        DataValidation officeValidation = validationHelper.createValidation(officeNameConstraint, officeNameRange);
        DataValidation staffValidation = validationHelper.createValidation(staffNameConstraint, staffNameRange);
        DataValidation submittedOnDateValidation = validationHelper.createValidation(submittedOnDateConstraint, submittedOnDateRange);
        DataValidation activationDateValidation = validationHelper.createValidation(activationDateConstraint, dateRange);
        DataValidation activeValidation = validationHelper.createValidation(activeConstraint, activeRange);
        DataValidation clientTypeValidation = validationHelper.createValidation(clientTypesConstraint, clientTypeRange);
        DataValidation constitutionValidation = validationHelper.createValidation(constitutionConstraint, constitutionRange);
        DataValidation mainBusinessLineValidation = validationHelper.createValidation(mainBusinessLineConstraint, mainBusinessLineRange);
        DataValidation clientClassificationValidation = validationHelper.createValidation(clientClassificationConstraint, clientClassificationRange);
        DataValidation enabledAddressValidation = validationHelper.createValidation(enabledAddressConstraint, enabledAddressRange);
        DataValidation addressTypeValidation = validationHelper.createValidation(addressTypeConstraint, addressTypeRange);
        DataValidation stateProvinceValidation = validationHelper.createValidation(stateProvinceConstraint, stateProvinceRange);
        DataValidation countryValidation = validationHelper.createValidation(countryConstraint, countryRange);
        DataValidation activeAddressValidation = validationHelper.createValidation(activeAddressConstraint, activeAddressRange);
        DataValidation incorporateDateValidation = validationHelper.createValidation(incorpDateConstraint, incorporateDateRange);
        DataValidation incorporateDateTillValidation = validationHelper.createValidation(incorpDateTillConstraint, incorporateDateTillRange);
        worksheet.addValidationData(activeValidation);
        worksheet.addValidationData(officeValidation);
        worksheet.addValidationData(staffValidation);
        worksheet.addValidationData(activationDateValidation);
        worksheet.addValidationData(submittedOnDateValidation);
        worksheet.addValidationData(clientTypeValidation);
        worksheet.addValidationData(constitutionValidation);
        worksheet.addValidationData(mainBusinessLineValidation);
        worksheet.addValidationData(clientClassificationValidation);
        worksheet.addValidationData(enabledAddressValidation);
        worksheet.addValidationData(addressTypeValidation);
        worksheet.addValidationData(stateProvinceValidation);
        worksheet.addValidationData(countryValidation);
        worksheet.addValidationData(activeAddressValidation);
        worksheet.addValidationData(incorporateDateValidation);
        worksheet.addValidationData(incorporateDateTillValidation);
    }

    private void setNames(Sheet worksheet, List<OfficeData> offices) {
        Workbook clientWorkbook = worksheet.getWorkbook();
        Name officeGroup = clientWorkbook.createName();
        officeGroup.setNameName("Office");
        officeGroup.setRefersToFormula("Offices!$B$2:$B$" + (offices.size() + 1));
        Name clientTypeGroup = clientWorkbook.createName();
        clientTypeGroup.setNameName("ClientTypes");
        clientTypeGroup.setRefersToFormula("ClientEntity!$AN$2:$AN$" + (this.clientTypeCodeValues.size() + 1));
        Name constitutionGroup = clientWorkbook.createName();
        constitutionGroup.setNameName("Constitution");
        constitutionGroup.setRefersToFormula("ClientEntity!$AL$2:$AL$" + (this.constitutionCodeValues.size() + 1));
        Name mainBusinessLineGroup = clientWorkbook.createName();
        mainBusinessLineGroup.setNameName("MainBusinessLine");
        mainBusinessLineGroup.setRefersToFormula("ClientEntity!$AR$2:$AR$" + (this.mainBusinesslineCodeValues.size() + 1));
        Name clientClassficationGroup = clientWorkbook.createName();
        clientClassficationGroup.setNameName("ClientClassification");
        clientClassficationGroup.setRefersToFormula("ClientEntity!$AM$2:$AM$" + (this.clientClassificationCodeValues.size() + 1));
        Name addressTypeGroup = clientWorkbook.createName();
        addressTypeGroup.setNameName("AddressType");
        addressTypeGroup.setRefersToFormula("ClientEntity!$AO$2:$AO$" + (this.addressTypesCodeValues.size() + 1));
        Name stateProvinceGroup = clientWorkbook.createName();
        stateProvinceGroup.setNameName("StateProvince");
        stateProvinceGroup.setRefersToFormula("ClientEntity!$AP$2:$AP$" + (this.stateProvinceCodeValues.size() + 1));
        Name countryGroup = clientWorkbook.createName();
        countryGroup.setNameName("Country");
        countryGroup.setRefersToFormula("ClientEntity!$AQ$2:$AQ$" + (this.countryCodeValues.size() + 1));
        Integer i = 0;
        while (i < offices.size()) {
            Integer[] officeNameToBeginEndIndexesOfStaff = (Integer[])this.personnelSheetPopulator.getOfficeNameToBeginEndIndexesOfStaff().get(i);
            if (officeNameToBeginEndIndexesOfStaff != null) {
                Name name = clientWorkbook.createName();
                this.setSanitized(name, "Staff_" + offices.get(i).getName());
                name.setRefersToFormula("Staff!$B$" + officeNameToBeginEndIndexesOfStaff[0] + ":$B$" + officeNameToBeginEndIndexesOfStaff[1]);
            }
            Integer n = i;
            i = i + 1;
        }
    }
}

