/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.populator.chartofaccounts;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.fineract.accounting.glaccount.data.GLAccountData;
import org.apache.fineract.accounting.glaccount.domain.GLAccountType;
import org.apache.fineract.accounting.glaccount.domain.GLAccountUsage;
import org.apache.fineract.infrastructure.bulkimport.populator.AbstractWorkbookPopulator;
import org.apache.fineract.organisation.monetary.data.CurrencyData;
import org.apache.fineract.organisation.office.data.OfficeData;
import org.apache.poi.hssf.usermodel.HSSFDataValidationHelper;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChartOfAccountsWorkbook
extends AbstractWorkbookPopulator {
    private static final Logger LOG = LoggerFactory.getLogger(ChartOfAccountsWorkbook.class);
    private final List<GLAccountData> glAccounts;
    private final List<OfficeData> offices;
    private List<CurrencyData> currencies;
    private Map<String, List<String>> accountTypeToAccountNameAndTag;
    private Map<Integer, Integer[]> accountTypeToBeginEndIndexesofAccountNames;
    private List<String> accountTypesNoDuplicatesList;

    public ChartOfAccountsWorkbook(List<GLAccountData> glAccounts, List<OfficeData> offices, List<CurrencyData> currencies) {
        this.glAccounts = glAccounts;
        this.offices = offices;
        this.currencies = currencies;
    }

    public void populate(Workbook workbook, String dateFormat) {
        Sheet chartOfAccountsSheet = workbook.createSheet("ChartOfAccounts");
        this.setLayout(chartOfAccountsSheet);
        this.setAccountTypeToAccountNameAndTag();
        this.setLookupTable(chartOfAccountsSheet);
        this.setRules(chartOfAccountsSheet);
        this.setDefaults(chartOfAccountsSheet);
    }

    private void setAccountTypeToAccountNameAndTag() {
        this.accountTypeToAccountNameAndTag = new HashMap();
        for (GLAccountData glAccount : this.glAccounts) {
            this.addToaccountTypeToAccountNameMap(glAccount.getType().getValue(), glAccount.getName() + "-" + glAccount.getId() + "-" + glAccount.getTagId().getName() + "-" + glAccount.getTagId().getId());
        }
    }

    private void addToaccountTypeToAccountNameMap(String key, String value) {
        ArrayList<String> values = (ArrayList<String>)this.accountTypeToAccountNameAndTag.get(key);
        if (values == null) {
            values = new ArrayList<String>();
        }
        if (!values.contains(value)) {
            values.add(value);
            this.accountTypeToAccountNameAndTag.put(key, values);
        }
    }

    private String[] getCurrency() {
        String[] currencyCode = new String[this.currencies.size()];
        int currencyIndex = 0;
        for (CurrencyData currencies : this.currencies) {
            currencyCode[currencyIndex] = currencies.getCode();
            ++currencyIndex;
        }
        return currencyCode;
    }

    private void setRules(Sheet chartOfAccountsSheet) {
        CellRangeAddressList accountTypeRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 0, 0);
        CellRangeAddressList accountUsageRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 2, 2);
        CellRangeAddressList manualEntriesAllowedRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 3, 3);
        CellRangeAddressList parentRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 4, 4);
        CellRangeAddressList tagRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 7, 7);
        CellRangeAddressList officeNameRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 10, 10);
        CellRangeAddressList currencyCodeRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 12, 12);
        HSSFDataValidationHelper validationHelper = new HSSFDataValidationHelper((HSSFSheet)chartOfAccountsSheet);
        this.setNames(chartOfAccountsSheet, this.accountTypesNoDuplicatesList, this.offices);
        DataValidationConstraint accountTypeConstraint = validationHelper.createExplicitListConstraint(new String[]{GLAccountType.ASSET.toString(), GLAccountType.LIABILITY.toString(), GLAccountType.EQUITY.toString(), GLAccountType.INCOME.toString(), GLAccountType.EXPENSE.toString()});
        DataValidationConstraint accountUsageConstraint = validationHelper.createExplicitListConstraint(new String[]{GLAccountUsage.DETAIL.toString(), GLAccountUsage.HEADER.toString()});
        DataValidationConstraint booleanConstraint = validationHelper.createExplicitListConstraint(new String[]{"True", "False"});
        DataValidationConstraint parentConstraint = validationHelper.createFormulaListConstraint("INDIRECT(CONCATENATE(\"AccountName_\",$A1))");
        DataValidationConstraint tagConstraint = validationHelper.createFormulaListConstraint("INDIRECT(CONCATENATE(\"Tags_\",$A1))");
        DataValidationConstraint officeNameConstraint = validationHelper.createFormulaListConstraint("Office");
        DataValidationConstraint currencyCodeConstraint = validationHelper.createExplicitListConstraint(this.getCurrency());
        DataValidation accountTypeValidation = validationHelper.createValidation(accountTypeConstraint, accountTypeRange);
        DataValidation accountUsageValidation = validationHelper.createValidation(accountUsageConstraint, accountUsageRange);
        DataValidation manualEntriesValidation = validationHelper.createValidation(booleanConstraint, manualEntriesAllowedRange);
        DataValidation parentValidation = validationHelper.createValidation(parentConstraint, parentRange);
        DataValidation tagValidation = validationHelper.createValidation(tagConstraint, tagRange);
        DataValidation officeNameValidation = validationHelper.createValidation(officeNameConstraint, officeNameRange);
        DataValidation currencyCodeValidation = validationHelper.createValidation(currencyCodeConstraint, currencyCodeRange);
        chartOfAccountsSheet.addValidationData(accountTypeValidation);
        chartOfAccountsSheet.addValidationData(accountUsageValidation);
        chartOfAccountsSheet.addValidationData(manualEntriesValidation);
        chartOfAccountsSheet.addValidationData(parentValidation);
        chartOfAccountsSheet.addValidationData(tagValidation);
        chartOfAccountsSheet.addValidationData(officeNameValidation);
        chartOfAccountsSheet.addValidationData(currencyCodeValidation);
    }

    private void setNames(Sheet chartOfAccountsSheet, List<String> accountTypesNoDuplicatesList, List<OfficeData> offices) {
        Workbook chartOfAccountsWorkbook = chartOfAccountsSheet.getWorkbook();
        Integer i = 0;
        while (i < accountTypesNoDuplicatesList.size()) {
            Name tags = chartOfAccountsWorkbook.createName();
            Integer[] tagValueBeginEndIndexes = (Integer[])this.accountTypeToBeginEndIndexesofAccountNames.get(i);
            if (this.accountTypeToBeginEndIndexesofAccountNames != null) {
                this.setSanitized(tags, "Tags_" + accountTypesNoDuplicatesList.get(i));
                tags.setRefersToFormula("ChartOfAccounts!$V$" + tagValueBeginEndIndexes[0] + ":$V$" + tagValueBeginEndIndexes[1]);
            }
            Name accountNames = chartOfAccountsWorkbook.createName();
            Integer[] accountNamesBeginEndIndexes = (Integer[])this.accountTypeToBeginEndIndexesofAccountNames.get(i);
            if (accountNamesBeginEndIndexes != null) {
                this.setSanitized(accountNames, "AccountName_" + accountTypesNoDuplicatesList.get(i));
                accountNames.setRefersToFormula("ChartOfAccounts!$T$" + accountNamesBeginEndIndexes[0] + ":$T$" + accountNamesBeginEndIndexes[1]);
            }
            Integer n = i;
            i = i + 1;
        }
        Name officeGroup = chartOfAccountsWorkbook.createName();
        officeGroup.setNameName("Office");
        officeGroup.setRefersToFormula("ChartOfAccounts!$X$2:$X$" + (offices.size() + 1));
    }

    private void setDefaults(Sheet worksheet) {
        try {
            Integer rowNo = 1;
            while (rowNo < 3000) {
                Row row = worksheet.getRow(rowNo.intValue());
                if (row == null) {
                    row = worksheet.createRow(rowNo.intValue());
                }
                this.writeFormula(5, row, "IF(ISERROR(VLOOKUP($E" + (rowNo + 1) + ",$T$2:$U$" + (this.glAccounts.size() + 1) + ",2,FALSE)),\"\",(VLOOKUP($E" + (rowNo + 1) + ",$T$2:$U$" + (this.glAccounts.size() + 1) + ",2,FALSE)))");
                this.writeFormula(8, row, "IF(ISERROR(VLOOKUP($H" + (rowNo + 1) + ",$V$2:$W$" + (this.glAccounts.size() + 1) + ",2,FALSE)),\"\",(VLOOKUP($H" + (rowNo + 1) + ",$V$2:$W$" + (this.glAccounts.size() + 1) + ",2,FALSE)))");
                this.writeFormula(11, row, "IF(ISERROR(VLOOKUP($K" + (rowNo + 1) + ",$X$2:$Y$" + (this.offices.size() + 1) + ",2,FALSE)),\"\",(VLOOKUP($K" + (rowNo + 1) + ",$X$2:$Y$" + (this.offices.size() + 1) + ",2,FALSE)))");
                Integer n = rowNo;
                rowNo = rowNo + 1;
            }
        }
        catch (Exception e) {
            LOG.error("Problem occurred in setDefaults function", (Throwable)e);
        }
    }

    private void setLookupTable(Sheet chartOfAccountsSheet) {
        Row row;
        this.accountTypesNoDuplicatesList = new ArrayList();
        for (GLAccountData glAccount : this.glAccounts) {
            if (this.accountTypesNoDuplicatesList.contains(glAccount.getType().getValue())) continue;
            this.accountTypesNoDuplicatesList.add(glAccount.getType().getValue());
        }
        int rowIndex = 1;
        int startIndex = 1;
        int accountTypeIndex = 0;
        this.accountTypeToBeginEndIndexesofAccountNames = new HashMap();
        for (String accountType : this.accountTypesNoDuplicatesList) {
            startIndex = rowIndex + 1;
            row = chartOfAccountsSheet.createRow(rowIndex);
            this.writeString(18, row, accountType);
            List accountNamesandTags = (List)this.accountTypeToAccountNameAndTag.get(accountType);
            if (!accountNamesandTags.isEmpty()) {
                for (String accountNameandTag : accountNamesandTags) {
                    List accountNameAndTagAr;
                    if (chartOfAccountsSheet.getRow(rowIndex) != null) {
                        accountNameAndTagAr = Splitter.on((char)'-').splitToList((CharSequence)accountNameandTag);
                        this.writeString(19, row, (String)accountNameAndTagAr.get(0));
                        this.writeString(20, row, (String)accountNameAndTagAr.get(1));
                        this.writeString(21, row, (String)accountNameAndTagAr.get(2));
                        this.writeString(22, row, (String)accountNameAndTagAr.get(3));
                        ++rowIndex;
                        continue;
                    }
                    row = chartOfAccountsSheet.createRow(rowIndex);
                    accountNameAndTagAr = Splitter.on((char)'-').splitToList((CharSequence)accountNameandTag);
                    this.writeString(19, row, (String)accountNameAndTagAr.get(0));
                    this.writeString(20, row, (String)accountNameAndTagAr.get(1));
                    this.writeString(21, row, (String)accountNameAndTagAr.get(2));
                    this.writeString(22, row, (String)accountNameAndTagAr.get(3));
                    ++rowIndex;
                }
                this.accountTypeToBeginEndIndexesofAccountNames.put(accountTypeIndex++, new Integer[]{startIndex, rowIndex});
                continue;
            }
            ++accountTypeIndex;
        }
        startIndex = 1;
        rowIndex = 1;
        for (OfficeData office : this.offices) {
            startIndex = rowIndex + 1;
            if (chartOfAccountsSheet.getRow(rowIndex) != null) {
                row = chartOfAccountsSheet.getRow(rowIndex);
                this.writeString(23, row, office.getName());
                this.writeLong(24, row, office.getId().longValue());
                ++rowIndex;
                continue;
            }
            row = chartOfAccountsSheet.createRow(rowIndex);
            this.writeString(23, row, office.getName());
            this.writeLong(24, row, office.getId().longValue());
            ++rowIndex;
        }
    }

    private void setLayout(Sheet chartOfAccountsSheet) {
        Row rowHeader = chartOfAccountsSheet.createRow(0);
        chartOfAccountsSheet.setColumnWidth(0, 4000);
        chartOfAccountsSheet.setColumnWidth(1, 4000);
        chartOfAccountsSheet.setColumnWidth(2, 4000);
        chartOfAccountsSheet.setColumnWidth(3, 4000);
        chartOfAccountsSheet.setColumnWidth(4, 6000);
        chartOfAccountsSheet.setColumnWidth(5, 4000);
        chartOfAccountsSheet.setColumnWidth(6, 4000);
        chartOfAccountsSheet.setColumnWidth(7, 4000);
        chartOfAccountsSheet.setColumnWidth(8, 4000);
        chartOfAccountsSheet.setColumnWidth(9, 10000);
        chartOfAccountsSheet.setColumnWidth(10, 6000);
        chartOfAccountsSheet.setColumnWidth(11, 4000);
        chartOfAccountsSheet.setColumnWidth(12, 6000);
        chartOfAccountsSheet.setColumnWidth(13, 4000);
        chartOfAccountsSheet.setColumnWidth(14, 4000);
        chartOfAccountsSheet.setColumnWidth(18, 4000);
        chartOfAccountsSheet.setColumnWidth(19, 6000);
        chartOfAccountsSheet.setColumnWidth(20, 6000);
        chartOfAccountsSheet.setColumnWidth(21, 4000);
        chartOfAccountsSheet.setColumnWidth(22, 4000);
        chartOfAccountsSheet.setColumnWidth(23, 6000);
        chartOfAccountsSheet.setColumnWidth(24, 4000);
        this.writeString(0, rowHeader, "Account Type*");
        this.writeString(6, rowHeader, "GL Code *");
        this.writeString(2, rowHeader, "Account Usage *");
        this.writeString(3, rowHeader, "Manual entries allowed *");
        this.writeString(4, rowHeader, "Parent");
        this.writeString(5, rowHeader, "Parent Id");
        this.writeString(1, rowHeader, "Account Name");
        this.writeString(7, rowHeader, "Tag");
        this.writeString(8, rowHeader, "Tag Id");
        this.writeString(9, rowHeader, "Description *");
        this.writeString(10, rowHeader, "Parent Office for Opening Balance");
        this.writeString(11, rowHeader, "Parent Office Code Opening Balance");
        this.writeString(12, rowHeader, "Currency Code");
        this.writeString(13, rowHeader, "Debit Amount");
        this.writeString(14, rowHeader, "Credit Amount");
        this.writeString(18, rowHeader, "Lookup Account type");
        this.writeString(21, rowHeader, "Lookup Tag");
        this.writeString(22, rowHeader, "Lookup Tag Id");
        this.writeString(19, rowHeader, "Lookup Account name *");
        this.writeString(20, rowHeader, "Lookup Account Id");
        this.writeString(23, rowHeader, "Lookup Office Name");
        this.writeString(24, rowHeader, "Lookup Office Id");
    }
}

