/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.importhandler.journalentry;

import com.google.gson.GsonBuilder;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.apache.fineract.accounting.journalentry.data.CreditDebit;
import org.apache.fineract.accounting.journalentry.data.JournalEntryData;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.bulkimport.data.Count;
import org.apache.fineract.infrastructure.bulkimport.importhandler.ImportHandler;
import org.apache.fineract.infrastructure.bulkimport.importhandler.ImportHandlerUtils;
import org.apache.fineract.infrastructure.bulkimport.importhandler.helper.CurrencyDateCodeSerializer;
import org.apache.fineract.infrastructure.bulkimport.importhandler.helper.DateSerializer;
import org.apache.fineract.infrastructure.core.serialization.GoogleGsonSerializerHelper;
import org.apache.fineract.organisation.monetary.data.CurrencyData;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JournalEntriesImportHandler
implements ImportHandler {
    private static final Logger LOG = LoggerFactory.getLogger(JournalEntriesImportHandler.class);
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;

    @Autowired
    public JournalEntriesImportHandler(PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService) {
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
    }

    public Count process(Workbook workbook, String locale, String dateFormat) {
        List glTransactions = this.readExcelFile(workbook, locale, dateFormat);
        return this.importEntity(workbook, glTransactions, dateFormat);
    }

    private List<JournalEntryData> readExcelFile(Workbook workbook, String locale, String dateFormat) {
        ArrayList<JournalEntryData> glTransactions = new ArrayList<JournalEntryData>();
        String currentTransactionId = null;
        String prevTransactionId = null;
        JournalEntryData journalEntry = null;
        LocalDate transactionDate = null;
        Sheet addJournalEntriesSheet = workbook.getSheet("AddJournalEntries");
        Integer noOfEntries = ImportHandlerUtils.getNumberOfRows((Sheet)addJournalEntriesSheet, (int)4);
        for (int rowIndex = 1; rowIndex <= noOfEntries; ++rowIndex) {
            Row row = addJournalEntriesSheet.getRow(rowIndex);
            currentTransactionId = ImportHandlerUtils.readAsString((int)4, (Row)row);
            if (currentTransactionId.equals(prevTransactionId)) {
                if (journalEntry != null) {
                    String creditGLAcct = ImportHandlerUtils.readAsString((int)5, (Row)row);
                    Long glAccountIdCredit = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("GlAccounts"), (String)creditGLAcct);
                    String debitGLAcct = ImportHandlerUtils.readAsString((int)7, (Row)row);
                    Long glAccountIdDebit = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("GlAccounts"), (String)debitGLAcct);
                    BigDecimal creditAmt = null;
                    if (ImportHandlerUtils.readAsDouble((int)6, (Row)row) != null) {
                        creditAmt = BigDecimal.valueOf(ImportHandlerUtils.readAsDouble((int)6, (Row)row));
                    }
                    BigDecimal debitAmount = null;
                    if (ImportHandlerUtils.readAsDouble((int)8, (Row)row) != null) {
                        debitAmount = BigDecimal.valueOf(ImportHandlerUtils.readAsDouble((int)8, (Row)row));
                    }
                    if (creditGLAcct != null) {
                        CreditDebit credit = new CreditDebit(glAccountIdCredit, creditAmt);
                        journalEntry.addCredits(credit);
                    }
                    if (debitGLAcct != null) {
                        CreditDebit debit = new CreditDebit(glAccountIdDebit, debitAmount);
                        journalEntry.addDebits(debit);
                    }
                }
            } else {
                if (journalEntry != null) {
                    glTransactions.add(journalEntry);
                }
                journalEntry = this.readAddJournalEntries(workbook, row, transactionDate, locale, dateFormat);
            }
            prevTransactionId = currentTransactionId;
        }
        glTransactions.add(journalEntry);
        return glTransactions;
    }

    private JournalEntryData readAddJournalEntries(Workbook workbook, Row row, LocalDate transactionDate, String locale, String dateFormat) {
        LocalDate transactionDateCheck = ImportHandlerUtils.readAsDate((int)1, (Row)row);
        if (transactionDateCheck != null) {
            transactionDate = transactionDateCheck;
        }
        String officeName = ImportHandlerUtils.readAsString((int)0, (Row)row);
        Long officeId = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("Offices"), (String)officeName);
        String paymentType = ImportHandlerUtils.readAsString((int)3, (Row)row);
        Long paymentTypeId = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("Extras"), (String)paymentType);
        String currencyName = ImportHandlerUtils.readAsString((int)2, (Row)row);
        String currencyCode = ImportHandlerUtils.getCodeByName((Sheet)workbook.getSheet("Extras"), (String)currencyName);
        String glAccountNameCredit = ImportHandlerUtils.readAsString((int)5, (Row)row);
        Long glAccountIdCredit = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("GlAccounts"), (String)glAccountNameCredit);
        String glAccountNameDebit = ImportHandlerUtils.readAsString((int)7, (Row)row);
        Long glAccountIdDebit = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("GlAccounts"), (String)glAccountNameDebit);
        ArrayList<CreditDebit> credits = new ArrayList<CreditDebit>();
        ArrayList<CreditDebit> debits = new ArrayList<CreditDebit>();
        if (glAccountNameCredit != null) {
            if (ImportHandlerUtils.readAsDouble((int)6, (Row)row) != null) {
                credits.add(new CreditDebit(glAccountIdCredit, BigDecimal.valueOf(ImportHandlerUtils.readAsDouble((int)6, (Row)row))));
            } else {
                credits.add(new CreditDebit(glAccountIdCredit, null));
            }
        }
        if (glAccountNameDebit != null) {
            if (ImportHandlerUtils.readAsDouble((int)8, (Row)row) != null) {
                debits.add(new CreditDebit(glAccountIdDebit, BigDecimal.valueOf(ImportHandlerUtils.readAsDouble((int)8, (Row)row))));
            } else {
                debits.add(new CreditDebit(glAccountIdDebit, null));
            }
        }
        String accountNo = ImportHandlerUtils.readAsString((int)10, (Row)row);
        String chequeNo = ImportHandlerUtils.readAsString((int)11, (Row)row);
        String routingCode = ImportHandlerUtils.readAsString((int)12, (Row)row);
        String receiptNo = ImportHandlerUtils.readAsString((int)13, (Row)row);
        String bankNo = ImportHandlerUtils.readAsString((int)14, (Row)row);
        String comments = ImportHandlerUtils.readAsString((int)15, (Row)row);
        return JournalEntryData.importInstance((Long)officeId, (LocalDate)transactionDate, (String)currencyCode, (Long)paymentTypeId, (Integer)row.getRowNum(), credits, debits, (String)accountNo, (String)chequeNo, (String)routingCode, (String)receiptNo, (String)bankNo, (String)comments, (String)locale, (String)dateFormat);
    }

    private Count importEntity(Workbook workbook, List<JournalEntryData> glTransactions, String dateFormat) {
        Sheet addJournalEntriesSheet = workbook.getSheet("AddJournalEntries");
        int successCount = 0;
        int errorCount = 0;
        String errorMessage = "";
        GsonBuilder gsonBuilder = GoogleGsonSerializerHelper.createGsonBuilder();
        gsonBuilder.registerTypeAdapter(LocalDate.class, (Object)new DateSerializer(dateFormat));
        gsonBuilder.registerTypeAdapter(CurrencyData.class, (Object)new CurrencyDateCodeSerializer());
        for (JournalEntryData transaction : glTransactions) {
            try {
                String payload = gsonBuilder.create().toJson((Object)transaction);
                CommandWrapper commandRequest = new CommandWrapperBuilder().createJournalEntry().withJson(payload).build();
                this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
                ++successCount;
                Cell statusCell = addJournalEntriesSheet.getRow(transaction.getRowIndex().intValue()).createCell(9);
                statusCell.setCellValue("Imported");
                statusCell.setCellStyle(ImportHandlerUtils.getCellStyle((Workbook)workbook, (IndexedColors)IndexedColors.LIGHT_GREEN));
            }
            catch (RuntimeException ex) {
                ++errorCount;
                LOG.error("Problem occurred in importEntity function", (Throwable)ex);
                errorMessage = ImportHandlerUtils.getErrorMessage((RuntimeException)ex);
                ImportHandlerUtils.writeErrorMessage((Sheet)addJournalEntriesSheet, (Integer)transaction.getRowIndex(), (String)errorMessage, (int)9);
            }
        }
        addJournalEntriesSheet.setColumnWidth(9, 4000);
        ImportHandlerUtils.writeString((int)9, (Row)addJournalEntriesSheet.getRow(0), (String)"Status");
        return Count.instance((Integer)successCount, (Integer)errorCount);
    }
}

