/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.importhandler.client;

import com.google.common.base.Splitter;
import com.google.gson.GsonBuilder;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.bulkimport.data.Count;
import org.apache.fineract.infrastructure.bulkimport.importhandler.ImportHandler;
import org.apache.fineract.infrastructure.bulkimport.importhandler.ImportHandlerUtils;
import org.apache.fineract.infrastructure.bulkimport.importhandler.helper.DateSerializer;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.serialization.GoogleGsonSerializerHelper;
import org.apache.fineract.infrastructure.core.service.ExternalIdFactory;
import org.apache.fineract.portfolio.address.data.AddressData;
import org.apache.fineract.portfolio.client.data.ClientData;
import org.apache.fineract.portfolio.client.data.ClientNonPersonData;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ClientEntityImportHandler
implements ImportHandler {
    public static final String SEPARATOR = "-";
    private static final Logger LOG = LoggerFactory.getLogger(ClientEntityImportHandler.class);
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final ExternalIdFactory externalIdFactory;

    public Count process(Workbook workbook, String locale, String dateFormat) {
        List clients = this.readExcelFile(workbook, locale, dateFormat);
        return this.importEntity(workbook, clients, dateFormat);
    }

    private List<ClientData> readExcelFile(Workbook workbook, String locale, String dateFormat) {
        ArrayList<ClientData> clients = new ArrayList<ClientData>();
        Sheet clientSheet = workbook.getSheet("ClientEntity");
        Integer noOfEntries = ImportHandlerUtils.getNumberOfRows((Sheet)clientSheet, (int)0);
        for (int rowIndex = 1; rowIndex <= noOfEntries; ++rowIndex) {
            Row row = clientSheet.getRow(rowIndex);
            if (!ImportHandlerUtils.isNotImported((Row)row, (int)27)) continue;
            clients.add(this.readClient(workbook, row, locale, dateFormat));
        }
        return clients;
    }

    private ClientData readClient(Workbook workbook, Row row, String locale, String dateFormat) {
        List constitutionAr;
        List mainBusinessLineAr;
        List clientClassificationAr;
        List clientTypeAr;
        Long legalFormId = 2L;
        String name = ImportHandlerUtils.readAsString((int)0, (Row)row);
        String officeName = ImportHandlerUtils.readAsString((int)1, (Row)row);
        Long officeId = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("Offices"), (String)officeName);
        if (officeId == 0L) {
            officeId = null;
        }
        String staffName = ImportHandlerUtils.readAsString((int)2, (Row)row);
        Long staffId = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("Staff"), (String)staffName);
        if (staffId == 0L) {
            staffId = null;
        }
        LocalDate incorportionDate = ImportHandlerUtils.readAsDate((int)3, (Row)row);
        LocalDate incorporationTill = ImportHandlerUtils.readAsDate((int)4, (Row)row);
        String mobileNo = null;
        if (ImportHandlerUtils.readAsLong((int)5, (Row)row) != null) {
            mobileNo = Objects.requireNonNull(ImportHandlerUtils.readAsLong((int)5, (Row)row)).toString();
        }
        String clientType = ImportHandlerUtils.readAsString((int)6, (Row)row);
        Long clientTypeId = null;
        if (clientType != null && (clientTypeAr = Splitter.on((String)SEPARATOR).splitToList((CharSequence)clientType)).get(1) != null) {
            clientTypeId = Long.parseLong((String)clientTypeAr.get(1));
        }
        String clientClassification = ImportHandlerUtils.readAsString((int)7, (Row)row);
        Long clientClassicationId = null;
        if (clientClassification != null && (clientClassificationAr = Splitter.on((String)SEPARATOR).splitToList((CharSequence)clientClassification)).get(1) != null) {
            clientClassicationId = Long.parseLong((String)clientClassificationAr.get(1));
        }
        String incorporationNo = ImportHandlerUtils.readAsString((int)8, (Row)row);
        String mainBusinessLine = ImportHandlerUtils.readAsString((int)9, (Row)row);
        Long mainBusinessId = null;
        if (mainBusinessLine != null && (mainBusinessLineAr = Splitter.on((String)SEPARATOR).splitToList((CharSequence)Objects.requireNonNull(ImportHandlerUtils.readAsString((int)9, (Row)row)))).get(1) != null) {
            mainBusinessId = Long.parseLong((String)mainBusinessLineAr.get(1));
        }
        String constitution = ImportHandlerUtils.readAsString((int)10, (Row)row);
        Long constitutionId = null;
        if (constitution != null && (constitutionAr = Splitter.on((String)SEPARATOR).splitToList((CharSequence)constitution)).get(1) != null) {
            constitutionId = Long.parseLong((String)constitutionAr.get(1));
        }
        String remarks = ImportHandlerUtils.readAsString((int)11, (Row)row);
        ClientNonPersonData clientNonPersonData = ClientNonPersonData.importInstance((String)incorporationNo, (LocalDate)incorporationTill, (String)remarks, (Long)mainBusinessId, constitutionId, (String)locale, (String)dateFormat);
        ExternalId externalId = this.externalIdFactory.create(ImportHandlerUtils.readAsString((int)12, (Row)row));
        Boolean active = ImportHandlerUtils.readAsBoolean((int)13, (Row)row);
        LocalDate submittedOn = ImportHandlerUtils.readAsDate((int)15, (Row)row);
        LocalDate activationDate = ImportHandlerUtils.readAsDate((int)14, (Row)row);
        if (!active.booleanValue()) {
            activationDate = submittedOn;
        }
        ArrayList<AddressData> addressList = null;
        if (ImportHandlerUtils.readAsBoolean((int)16, (Row)row).booleanValue()) {
            List countryAr;
            List stateProvinceAr;
            List addressTypeAr;
            String addressType = ImportHandlerUtils.readAsString((int)17, (Row)row);
            Long addressTypeId = null;
            if (addressType != null && (addressTypeAr = Splitter.on((String)SEPARATOR).splitToList((CharSequence)addressType)).get(1) != null) {
                addressTypeId = Long.parseLong((String)addressTypeAr.get(1));
            }
            String street = ImportHandlerUtils.readAsString((int)18, (Row)row);
            String addressLine1 = ImportHandlerUtils.readAsString((int)19, (Row)row);
            String addressLine2 = ImportHandlerUtils.readAsString((int)20, (Row)row);
            String addressLine3 = ImportHandlerUtils.readAsString((int)21, (Row)row);
            String city = ImportHandlerUtils.readAsString((int)22, (Row)row);
            String postalCode = ImportHandlerUtils.readAsString((int)25, (Row)row);
            Boolean isActiveAddress = ImportHandlerUtils.readAsBoolean((int)26, (Row)row);
            String stateProvince = ImportHandlerUtils.readAsString((int)23, (Row)row);
            Long stateProvinceId = null;
            if (stateProvince != null && (stateProvinceAr = Splitter.on((String)SEPARATOR).splitToList((CharSequence)stateProvince)).get(1) != null) {
                stateProvinceId = Long.parseLong((String)stateProvinceAr.get(1));
            }
            String country = ImportHandlerUtils.readAsString((int)24, (Row)row);
            Long countryId = null;
            if (country != null && (countryAr = Splitter.on((String)SEPARATOR).splitToList((CharSequence)country)).get(1) != null) {
                countryId = Long.parseLong((String)countryAr.get(1));
            }
            AddressData addressDataObj = new AddressData(addressTypeId, street, addressLine1, addressLine2, addressLine3, city, postalCode, isActiveAddress, stateProvinceId, countryId);
            addressList = new ArrayList<AddressData>(List.of(addressDataObj));
        }
        return ClientData.importClientEntityInstance((Long)legalFormId, (Integer)row.getRowNum(), (String)name, (Long)officeId, (Long)clientTypeId, (Long)clientClassicationId, (Long)staffId, (Boolean)active, (LocalDate)activationDate, (LocalDate)submittedOn, (ExternalId)externalId, (LocalDate)incorportionDate, (String)mobileNo, (ClientNonPersonData)clientNonPersonData, addressList, (String)locale, (String)dateFormat);
    }

    private Count importEntity(Workbook workbook, List<ClientData> clients, String dateFormat) {
        Sheet clientSheet = workbook.getSheet("ClientEntity");
        int successCount = 0;
        int errorCount = 0;
        GsonBuilder gsonBuilder = GoogleGsonSerializerHelper.createGsonBuilder();
        gsonBuilder.registerTypeAdapter(LocalDate.class, (Object)new DateSerializer(dateFormat));
        for (ClientData client : clients) {
            try {
                String payload = gsonBuilder.create().toJson((Object)client);
                CommandWrapper commandRequest = new CommandWrapperBuilder().createClient().withJson(payload).build();
                this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
                ++successCount;
                Cell statusCell = clientSheet.getRow(client.getRowIndex().intValue()).createCell(27);
                statusCell.setCellValue("Imported");
                statusCell.setCellStyle(ImportHandlerUtils.getCellStyle((Workbook)workbook, (IndexedColors)IndexedColors.LIGHT_GREEN));
            }
            catch (RuntimeException ex) {
                ++errorCount;
                LOG.error("Problem occurred in importEntity function", (Throwable)ex);
                String errorMessage = ImportHandlerUtils.getErrorMessage((RuntimeException)ex);
                ImportHandlerUtils.writeErrorMessage((Sheet)clientSheet, (Integer)client.getRowIndex(), (String)errorMessage, (int)27);
            }
        }
        clientSheet.setColumnWidth(27, 4000);
        ImportHandlerUtils.writeString((int)27, (Row)clientSheet.getRow(0), (String)"Status");
        return Count.instance((Integer)successCount, (Integer)errorCount);
    }

    @Generated
    public ClientEntityImportHandler(PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, ExternalIdFactory externalIdFactory) {
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.externalIdFactory = externalIdFactory;
    }
}

