/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.importhandler.chartofaccounts;

import com.google.gson.GsonBuilder;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.fineract.accounting.glaccount.data.GLAccountData;
import org.apache.fineract.accounting.glaccount.domain.GLAccount;
import org.apache.fineract.accounting.glaccount.domain.GLAccountRepositoryWrapper;
import org.apache.fineract.accounting.glaccount.domain.GLAccountType;
import org.apache.fineract.accounting.glaccount.domain.GLAccountUsage;
import org.apache.fineract.accounting.glaccount.exception.GLAccountNotFoundException;
import org.apache.fineract.accounting.journalentry.data.CreditDebit;
import org.apache.fineract.accounting.journalentry.data.JournalEntryData;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.bulkimport.data.Count;
import org.apache.fineract.infrastructure.bulkimport.importhandler.ImportHandler;
import org.apache.fineract.infrastructure.bulkimport.importhandler.ImportHandlerUtils;
import org.apache.fineract.infrastructure.bulkimport.importhandler.helper.CodeValueDataIdSerializer;
import org.apache.fineract.infrastructure.bulkimport.importhandler.helper.CurrencyDateCodeSerializer;
import org.apache.fineract.infrastructure.bulkimport.importhandler.helper.DateSerializer;
import org.apache.fineract.infrastructure.bulkimport.importhandler.helper.EnumOptionDataIdSerializer;
import org.apache.fineract.infrastructure.codes.data.CodeValueData;
import org.apache.fineract.infrastructure.core.data.EnumOptionData;
import org.apache.fineract.infrastructure.core.serialization.GoogleGsonSerializerHelper;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.organisation.monetary.data.CurrencyData;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ChartOfAccountsImportHandler
implements ImportHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ChartOfAccountsImportHandler.class);
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final GLAccountRepositoryWrapper glAccountRepository;

    @Autowired
    public ChartOfAccountsImportHandler(PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, GLAccountRepositoryWrapper glAccountRepository) {
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.glAccountRepository = glAccountRepository;
    }

    public Count process(Workbook workbook, String locale, String dateFormat) {
        ArrayList glAccounts = new ArrayList();
        ArrayList glTransactions = new ArrayList();
        ArrayList credits = new ArrayList();
        ArrayList debits = new ArrayList();
        boolean flagForOpBal = this.readExcelFile(workbook, glAccounts);
        return this.importEntity(workbook, glAccounts, glTransactions, credits, debits, flagForOpBal, locale, dateFormat);
    }

    private boolean readExcelFile(Workbook workbook, List<GLAccountData> glAccounts) {
        Sheet chartOfAccountsSheet = workbook.getSheet("ChartOfAccounts");
        Integer noOfEntries = ImportHandlerUtils.getNumberOfRows((Sheet)chartOfAccountsSheet, (int)0);
        boolean flagForOpBal = false;
        for (int rowIndex = 1; rowIndex <= noOfEntries; ++rowIndex) {
            Row row = chartOfAccountsSheet.getRow(rowIndex);
            if (!ImportHandlerUtils.isNotImported((Row)row, (int)25)) continue;
            glAccounts.add(this.readGlAccounts(row));
            flagForOpBal = ImportHandlerUtils.readAsString((int)10, (Row)row) != null ? Boolean.TRUE.booleanValue() : Boolean.FALSE.booleanValue();
        }
        return flagForOpBal;
    }

    private GLAccountData readGlAccounts(Row row) {
        String accountType = ImportHandlerUtils.readAsString((int)0, (Row)row);
        EnumOptionData accountTypeEnum = GLAccountType.fromString((String)accountType);
        String accountName = ImportHandlerUtils.readAsString((int)1, (Row)row);
        String usage = ImportHandlerUtils.readAsString((int)2, (Row)row);
        Long usageId = null;
        EnumOptionData usageEnum = null;
        if (usage != null && usage.equals(GLAccountUsage.DETAIL.toString())) {
            usageId = 1L;
            usageEnum = new EnumOptionData(usageId, null, null);
        } else if (usage != null && usage.equals(GLAccountUsage.HEADER.toString())) {
            usageId = 2L;
            usageEnum = new EnumOptionData(usageId, null, null);
        }
        Boolean manualEntriesAllowed = ImportHandlerUtils.readAsBoolean((int)3, (Row)row);
        Long parentId = null;
        if (ImportHandlerUtils.readAsString((int)5, (Row)row) != null) {
            parentId = Long.parseLong(Objects.requireNonNull(ImportHandlerUtils.readAsString((int)5, (Row)row)));
        }
        String glCode = ImportHandlerUtils.readAsString((int)6, (Row)row);
        Long tagId = null;
        CodeValueData tagIdCodeValueData = null;
        if (ImportHandlerUtils.readAsString((int)8, (Row)row) != null) {
            tagId = Long.parseLong(Objects.requireNonNull(ImportHandlerUtils.readAsString((int)8, (Row)row)));
            tagIdCodeValueData = new CodeValueData().setId(tagId);
        }
        String description = ImportHandlerUtils.readAsString((int)9, (Row)row);
        return new GLAccountData().setName(accountName).setParentId(parentId).setGlCode(glCode).setManualEntriesAllowed(manualEntriesAllowed).setType(accountTypeEnum).setUsage(usageEnum).setDescription(description).setTagId(tagIdCodeValueData).setRowIndex(Integer.valueOf(row.getRowNum()));
    }

    private Count importEntity(Workbook workbook, List<GLAccountData> glAccounts, List<JournalEntryData> glTransactions, List<CreditDebit> credits, List<CreditDebit> debits, boolean flagForOpBal, String locale, String dateFormat) {
        Sheet chartOfAccountsSheet = workbook.getSheet("ChartOfAccounts");
        GsonBuilder gsonBuilder = GoogleGsonSerializerHelper.createGsonBuilder();
        gsonBuilder.registerTypeAdapter(EnumOptionData.class, (Object)new EnumOptionDataIdSerializer());
        gsonBuilder.registerTypeAdapter(CodeValueData.class, (Object)new CodeValueDataIdSerializer());
        gsonBuilder.registerTypeAdapter(LocalDate.class, (Object)new DateSerializer(dateFormat));
        gsonBuilder.registerTypeAdapter(CurrencyData.class, (Object)new CurrencyDateCodeSerializer());
        int successCount = 0;
        int errorCount = 0;
        String errorMessage = "";
        if (glAccounts != null) {
            for (GLAccountData glAccount : glAccounts) {
                try {
                    String payload = gsonBuilder.create().toJson((Object)glAccount);
                    CommandWrapper commandRequest = new CommandWrapperBuilder().createGLAccount().withJson(payload).build();
                    this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
                    ++successCount;
                    Cell statusCell = chartOfAccountsSheet.getRow(glAccount.getRowIndex().intValue()).createCell(25);
                    statusCell.setCellValue("Imported");
                    statusCell.setCellStyle(ImportHandlerUtils.getCellStyle((Workbook)workbook, (IndexedColors)IndexedColors.LIGHT_GREEN));
                }
                catch (RuntimeException ex) {
                    ++errorCount;
                    LOG.error("Problem occurred in importEntity function", (Throwable)ex);
                    errorMessage = ImportHandlerUtils.getErrorMessage((RuntimeException)ex);
                    ImportHandlerUtils.writeErrorMessage((Sheet)chartOfAccountsSheet, (Integer)glAccount.getRowIndex(), (String)errorMessage, (int)25);
                }
            }
            if (flagForOpBal) {
                try {
                    this.readExcelFileForOpBal(workbook, glTransactions, credits, debits, locale, dateFormat);
                    JournalEntryData transaction = glTransactions.get(glTransactions.size() - 1);
                    String payload = gsonBuilder.create().toJson((Object)transaction);
                    CommandWrapper commandRequest = new CommandWrapperBuilder().defineOpeningBalanceForJournalEntry().withJson(payload).build();
                    this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
                    ++successCount;
                    Cell statusCell = chartOfAccountsSheet.getRow(1).createCell(25);
                    statusCell.setCellValue("Imported");
                    statusCell.setCellStyle(ImportHandlerUtils.getCellStyle((Workbook)workbook, (IndexedColors)IndexedColors.LIGHT_GREEN));
                }
                catch (RuntimeException ex) {
                    ++errorCount;
                    LOG.error("Problem occurred in importEntity function", (Throwable)ex);
                    errorMessage = ImportHandlerUtils.getErrorMessage((RuntimeException)ex);
                    ImportHandlerUtils.writeErrorMessage((Sheet)chartOfAccountsSheet, (Integer)1, (String)errorMessage, (int)25);
                }
            }
            chartOfAccountsSheet.setColumnWidth(25, 4000);
            ImportHandlerUtils.writeString((int)25, (Row)chartOfAccountsSheet.getRow(0), (String)"Status");
            return Count.instance((Integer)successCount, (Integer)errorCount);
        }
        chartOfAccountsSheet.setColumnWidth(25, 4000);
        ImportHandlerUtils.writeString((int)25, (Row)chartOfAccountsSheet.getRow(0), (String)"Status");
        return Count.instance((Integer)successCount, (Integer)errorCount);
    }

    private void readExcelFileForOpBal(Workbook workbook, List<JournalEntryData> glTransactions, List<CreditDebit> credits, List<CreditDebit> debits, String locale, String dateFormat) {
        Sheet chartOfAccountsSheet = workbook.getSheet("ChartOfAccounts");
        Integer noOfEntries = ImportHandlerUtils.getNumberOfRows((Sheet)chartOfAccountsSheet, (int)0);
        for (int rowIndex = 1; rowIndex <= noOfEntries; ++rowIndex) {
            Row row = chartOfAccountsSheet.getRow(rowIndex);
            JournalEntryData journalEntry = this.readAddJournalEntries(row, credits, debits, locale, dateFormat);
            glTransactions.add(journalEntry);
        }
    }

    private JournalEntryData readAddJournalEntries(Row row, List<CreditDebit> credits, List<CreditDebit> debits, String locale, String dateFormat) {
        LocalDate transactionDate = DateUtils.getBusinessLocalDate();
        Long officeId = ImportHandlerUtils.readAsLong((int)11, (Row)row);
        String currencyCode = ImportHandlerUtils.readAsString((int)12, (Row)row);
        String accountToBeDebitedCredited = ImportHandlerUtils.readAsString((int)1, (Row)row);
        String glCode = ImportHandlerUtils.readAsString((int)6, (Row)row);
        GLAccount glAccount = this.glAccountRepository.findOneByGlCodeWithNotFoundDetection(glCode);
        Long glAccountIdToDebitedCredited = (Long)glAccount.getId();
        if (glAccountIdToDebitedCredited == null) {
            throw new GLAccountNotFoundException("Account does not exist");
        }
        if (accountToBeDebitedCredited != null) {
            if (ImportHandlerUtils.readAsLong((int)14, (Row)row) != null) {
                credits.add(new CreditDebit(glAccountIdToDebitedCredited, BigDecimal.valueOf(ImportHandlerUtils.readAsLong((int)14, (Row)row))));
            } else if (ImportHandlerUtils.readAsLong((int)13, (Row)row) != null) {
                debits.add(new CreditDebit(glAccountIdToDebitedCredited, BigDecimal.valueOf(ImportHandlerUtils.readAsLong((int)13, (Row)row))));
            }
        }
        return JournalEntryData.importInstance1((Long)officeId, (LocalDate)transactionDate, (String)currencyCode, credits, debits, (String)locale, (String)dateFormat);
    }
}

