/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.importhandler.center;

import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.IdempotencyKeyGenerator;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.bulkimport.data.Count;
import org.apache.fineract.infrastructure.bulkimport.importhandler.ImportHandler;
import org.apache.fineract.infrastructure.bulkimport.importhandler.ImportHandlerUtils;
import org.apache.fineract.infrastructure.bulkimport.importhandler.helper.DateSerializer;
import org.apache.fineract.infrastructure.bulkimport.importhandler.helper.EnumOptionDataValueSerializer;
import org.apache.fineract.infrastructure.bulkimport.importhandler.helper.GroupIdSerializer;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.EnumOptionData;
import org.apache.fineract.infrastructure.core.serialization.GoogleGsonSerializerHelper;
import org.apache.fineract.portfolio.calendar.data.CalendarData;
import org.apache.fineract.portfolio.group.data.CenterData;
import org.apache.fineract.portfolio.group.data.GroupGeneralData;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CenterImportHandler
implements ImportHandler {
    public static final String EMPTY_STR = "";
    private static final Logger LOG = LoggerFactory.getLogger(CenterImportHandler.class);
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final IdempotencyKeyGenerator idempotencyKeyGenerator;

    @Autowired
    public CenterImportHandler(PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, IdempotencyKeyGenerator idempotencyKeyGenerator) {
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.idempotencyKeyGenerator = idempotencyKeyGenerator;
    }

    public Count process(Workbook workbook, String locale, String dateFormat) {
        ArrayList centers = new ArrayList();
        ArrayList meetings = new ArrayList();
        ArrayList statuses = new ArrayList();
        this.readExcelFile(workbook, centers, meetings, statuses, locale, dateFormat);
        return this.importEntity(workbook, centers, meetings, statuses, dateFormat);
    }

    private void readExcelFile(Workbook workbook, List<CenterData> centers, List<CalendarData> meetings, List<String> statuses, String locale, String dateFormat) {
        Sheet centersSheet = workbook.getSheet("Centers");
        Integer noOfEntries = ImportHandlerUtils.getNumberOfRows((Sheet)centersSheet, (int)0);
        for (int rowIndex = 1; rowIndex <= noOfEntries; ++rowIndex) {
            Row row = centersSheet.getRow(rowIndex);
            if (!ImportHandlerUtils.isNotImported((Row)row, (int)12)) continue;
            centers.add(this.readCenter(workbook, statuses, row, locale, dateFormat));
            meetings.add(this.readMeeting(row, locale, dateFormat));
        }
    }

    private CalendarData readMeeting(Row row, String locale, String dateFormat) {
        LocalDate meetingStartDate = ImportHandlerUtils.readAsDate((int)7, (Row)row);
        Boolean isRepeating = ImportHandlerUtils.readAsBoolean((int)8, (Row)row);
        String frequency = ImportHandlerUtils.readAsString((int)9, (Row)row);
        EnumOptionData frequencyEnum = new EnumOptionData(null, null, ImportHandlerUtils.getFrequencyId((String)frequency));
        Integer interval = ImportHandlerUtils.readAsInt((int)10, (Row)row);
        String repeatsOnDay = ImportHandlerUtils.readAsString((int)11, (Row)row);
        EnumOptionData repeatsOnDayEnum = new EnumOptionData(null, null, ImportHandlerUtils.getRepeatsOnDayId((String)repeatsOnDay));
        if (meetingStartDate == null) {
            return null;
        }
        if (repeatsOnDay == null) {
            return CalendarData.importInstanceNoRepeatsOnDay((LocalDate)meetingStartDate, (boolean)isRepeating, (EnumOptionData)frequencyEnum, (Integer)interval, (Integer)row.getRowNum(), (String)locale, (String)dateFormat);
        }
        return CalendarData.importInstanceWithRepeatsOnDay((LocalDate)meetingStartDate, (boolean)isRepeating, (EnumOptionData)frequencyEnum, (Integer)interval, (EnumOptionData)repeatsOnDayEnum, (Integer)row.getRowNum(), (String)locale, (String)dateFormat);
    }

    private CenterData readCenter(Workbook workbook, List<String> statuses, Row row, String locale, String dateFormat) {
        String groupName;
        String status = ImportHandlerUtils.readAsString((int)12, (Row)row);
        String officeName = ImportHandlerUtils.readAsString((int)1, (Row)row);
        Long officeId = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("Offices"), (String)officeName);
        String staffName = ImportHandlerUtils.readAsString((int)2, (Row)row);
        Long staffId = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("Staff"), (String)staffName);
        String externalId = ImportHandlerUtils.readAsString((int)3, (Row)row);
        Boolean active = ImportHandlerUtils.readAsBoolean((int)4, (Row)row);
        LocalDate submittedOn = ImportHandlerUtils.readAsDate((int)6, (Row)row);
        LocalDate activationDate = Boolean.TRUE.equals(active) ? ImportHandlerUtils.readAsDate((int)5, (Row)row) : submittedOn;
        String centerName = ImportHandlerUtils.readAsString((int)0, (Row)row);
        if (centerName == null || centerName.equals(EMPTY_STR)) {
            throw new IllegalArgumentException("Name is blank");
        }
        ArrayList<GroupGeneralData> groupMembers = new ArrayList<GroupGeneralData>();
        for (int cellNo = 15; cellNo < 250 && (groupName = ImportHandlerUtils.readAsString((int)cellNo, (Row)row)) != null && !groupName.equals(EMPTY_STR); ++cellNo) {
            Long groupId = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("Groups"), (String)groupName);
            GroupGeneralData group = new GroupGeneralData(groupId);
            if (this.containsGroupId(groupMembers, groupId)) continue;
            groupMembers.add(group);
        }
        statuses.add(status);
        return CenterData.importInstance((String)centerName, groupMembers, (LocalDate)activationDate, (boolean)active, (LocalDate)submittedOn, (String)externalId, (Long)officeId, (Long)staffId, (Integer)row.getRowNum(), (String)dateFormat, (String)locale);
    }

    private boolean containsGroupId(List<GroupGeneralData> groupMembers, Long groupId) {
        for (GroupGeneralData group : groupMembers) {
            if (!group.getId().equals(groupId)) continue;
            return true;
        }
        return false;
    }

    private Count importEntity(Workbook workbook, List<CenterData> centers, List<CalendarData> meetings, List<String> statuses, String dateFormat) {
        Sheet centerSheet = workbook.getSheet("Centers");
        int progressLevel = 0;
        String centerId = EMPTY_STR;
        int successCount = 0;
        int errorCount = 0;
        for (int i = 0; i < centers.size(); ++i) {
            Row row = centerSheet.getRow(centers.get(i).getRowIndex().intValue());
            Cell errorReportCell = row.createCell(14);
            Cell statusCell = row.createCell(12);
            CommandProcessingResult result = null;
            try {
                String status = statuses.get(i);
                progressLevel = this.getProgressLevel(status);
                if (progressLevel == 0) {
                    result = this.importCenter(centers, i, dateFormat);
                    centerId = result.getGroupId().toString();
                    progressLevel = 1;
                } else {
                    centerId = Objects.requireNonNull(ImportHandlerUtils.readAsInt((int)13, (Row)centerSheet.getRow(centers.get(i).getRowIndex().intValue()))).toString();
                }
                if (meetings.get(i) != null) {
                    progressLevel = this.importCenterMeeting(meetings, Objects.requireNonNull(result), i, dateFormat);
                }
                ++successCount;
                statusCell.setCellValue("Imported");
                statusCell.setCellStyle(ImportHandlerUtils.getCellStyle((Workbook)workbook, (IndexedColors)IndexedColors.LIGHT_GREEN));
                continue;
            }
            catch (RuntimeException ex) {
                ++errorCount;
                LOG.error("Runtime Exception occured in importEntity function", (Throwable)ex);
                String errorMessage = ImportHandlerUtils.getErrorMessage((RuntimeException)ex);
                this.writeCenterErrorMessage(workbook, centerId, errorMessage, progressLevel, statusCell, errorReportCell, row);
            }
        }
        this.setReportHeaders(centerSheet);
        return Count.instance((Integer)successCount, (Integer)errorCount);
    }

    private void writeCenterErrorMessage(Workbook workbook, String centerId, String errorMessage, int progressLevel, Cell statusCell, Cell errorReportCell, Row row) {
        String status = EMPTY_STR;
        if (progressLevel == 0) {
            status = "Creation failed";
        } else if (progressLevel == 1) {
            status = "Meeting failed";
        }
        statusCell.setCellValue(status);
        statusCell.setCellStyle(ImportHandlerUtils.getCellStyle((Workbook)workbook, (IndexedColors)IndexedColors.RED));
        if (progressLevel > 0) {
            row.createCell(13).setCellValue((double)Integer.parseInt(centerId));
        }
        errorReportCell.setCellValue(errorMessage);
    }

    private int getProgressLevel(String status) {
        if (status == null || status.equals("Creation failed")) {
            return 0;
        }
        if (status.equals("Meeting failed")) {
            return 1;
        }
        return 0;
    }

    private CommandProcessingResult importCenter(List<CenterData> centers, int rowIndex, String dateFormat) {
        GsonBuilder gsonBuilder = GoogleGsonSerializerHelper.createGsonBuilder();
        gsonBuilder.registerTypeAdapter(LocalDate.class, (Object)new DateSerializer(dateFormat));
        Type groupCollectionType = new /* Unavailable Anonymous Inner Class!! */.getType();
        gsonBuilder.registerTypeAdapter(groupCollectionType, (Object)new GroupIdSerializer());
        String payload = gsonBuilder.create().toJson((Object)centers.get(rowIndex));
        CommandWrapper commandRequest = new CommandWrapperBuilder().createCenter().withJson(payload).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    private void setReportHeaders(Sheet sheet) {
        ImportHandlerUtils.writeString((int)12, (Row)sheet.getRow(0), (String)"Status");
        ImportHandlerUtils.writeString((int)13, (Row)sheet.getRow(0), (String)"Center Id");
        ImportHandlerUtils.writeString((int)14, (Row)sheet.getRow(0), (String)"Failure Report");
    }

    private Integer importCenterMeeting(List<CalendarData> meetings, CommandProcessingResult result, int rowIndex, String dateFormat) {
        CalendarData calendarData = meetings.get(rowIndex);
        calendarData.setTitle("centers_" + result.getGroupId().toString() + "_CollectionMeeting");
        GsonBuilder gsonBuilder = GoogleGsonSerializerHelper.createGsonBuilder();
        gsonBuilder.registerTypeAdapter(LocalDate.class, (Object)new DateSerializer(dateFormat));
        gsonBuilder.registerTypeAdapter(EnumOptionData.class, (Object)new EnumOptionDataValueSerializer());
        String payload = gsonBuilder.create().toJson((Object)calendarData);
        CommandWrapper commandWrapper = new CommandWrapper(result.getOfficeId(), result.getGroupId(), result.getClientId(), result.getLoanId(), result.getSavingsId(), null, null, null, null, null, payload, result.getTransactionId(), result.getProductId(), null, null, null, null, this.idempotencyKeyGenerator.create(), null);
        CommandWrapper commandRequest = new CommandWrapperBuilder().createCalendar(commandWrapper, "CENTER", result.getGroupId()).withJson(payload).build();
        this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return 2;
    }
}

