/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.documentmanagement.domain.Document;
import org.apache.fineract.useradministration.domain.AppUser;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="m_import_document")
public class ImportDocument
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @OneToOne
    @JoinColumn(name="document_id")
    private Document document;
    @Column(name="import_time")
    private LocalDateTime importTime;
    @Column(name="end_time")
    private LocalDateTime endTime;
    @Column(name="completed", nullable=false)
    private Boolean completed;
    @Column(name="entity_type")
    private Integer entityType;
    @ManyToOne
    @JoinColumn(name="createdby_id")
    private AppUser createdBy;
    @Column(name="total_records", nullable=true)
    private Integer totalRecords;
    @Column(name="success_count", nullable=true)
    private Integer successCount;
    @Column(name="failure_count", nullable=true)
    private Integer failureCount;
    static final long serialVersionUID = -4167331237982590796L;

    protected ImportDocument() {
    }

    public static ImportDocument instance(Document document, LocalDateTime importTime, Integer entityType, AppUser createdBy, Integer totalRecords) {
        Boolean completed = Boolean.FALSE;
        Integer successCount = 0;
        Integer failureCount = 0;
        LocalDateTime endTime = DateUtils.getLocalDateTimeOfTenant();
        return new ImportDocument(document, importTime, endTime, completed, entityType, createdBy, totalRecords, successCount, failureCount);
    }

    private ImportDocument(Document document, LocalDateTime importTime, LocalDateTime endTime, Boolean completed, Integer entityType, AppUser createdBy, Integer totalRecords, Integer successCount, Integer failureCount) {
        this.document = document;
        this.importTime = importTime;
        this.endTime = endTime;
        this.completed = completed;
        this.entityType = entityType;
        this.createdBy = createdBy;
        this.totalRecords = totalRecords;
        this.successCount = successCount;
        this.failureCount = failureCount;
    }

    public void update(LocalDateTime endTime, Integer successCount, Integer errorCount) {
        this._persistence_set_endTime(endTime);
        this._persistence_set_completed(Boolean.TRUE);
        this._persistence_set_successCount(successCount);
        this._persistence_set_failureCount(errorCount);
    }

    public Document getDocument() {
        return this._persistence_get_document();
    }

    public Integer getEntityType() {
        return this._persistence_get_entityType();
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ImportDocument();
    }

    public Object _persistence_get(String string) {
        if (string == "totalRecords") {
            return this.totalRecords;
        }
        if (string == "createdBy") {
            return this.createdBy;
        }
        if (string == "entityType") {
            return this.entityType;
        }
        if (string == "document") {
            return this.document;
        }
        if (string == "successCount") {
            return this.successCount;
        }
        if (string == "endTime") {
            return this.endTime;
        }
        if (string == "completed") {
            return this.completed;
        }
        if (string == "importTime") {
            return this.importTime;
        }
        if (string == "failureCount") {
            return this.failureCount;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "totalRecords") {
            this.totalRecords = (Integer)object;
            return;
        }
        if (string == "createdBy") {
            this.createdBy = (AppUser)object;
            return;
        }
        if (string == "entityType") {
            this.entityType = (Integer)object;
            return;
        }
        if (string == "document") {
            this.document = (Document)object;
            return;
        }
        if (string == "successCount") {
            this.successCount = (Integer)object;
            return;
        }
        if (string == "endTime") {
            this.endTime = (LocalDateTime)object;
            return;
        }
        if (string == "completed") {
            this.completed = (Boolean)object;
            return;
        }
        if (string == "importTime") {
            this.importTime = (LocalDateTime)object;
            return;
        }
        if (string == "failureCount") {
            this.failureCount = (Integer)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Integer _persistence_get_totalRecords() {
        this._persistence_checkFetched("totalRecords");
        return this.totalRecords;
    }

    public void _persistence_set_totalRecords(Integer n) {
        this._persistence_checkFetchedForSet("totalRecords");
        this._persistence_propertyChange("totalRecords", (Object)this.totalRecords, (Object)n);
        this.totalRecords = n;
    }

    public AppUser _persistence_get_createdBy() {
        this._persistence_checkFetched("createdBy");
        return this.createdBy;
    }

    public void _persistence_set_createdBy(AppUser appUser) {
        this._persistence_checkFetchedForSet("createdBy");
        this._persistence_propertyChange("createdBy", (Object)this.createdBy, (Object)appUser);
        this.createdBy = appUser;
    }

    public Integer _persistence_get_entityType() {
        this._persistence_checkFetched("entityType");
        return this.entityType;
    }

    public void _persistence_set_entityType(Integer n) {
        this._persistence_checkFetchedForSet("entityType");
        this._persistence_propertyChange("entityType", (Object)this.entityType, (Object)n);
        this.entityType = n;
    }

    public Document _persistence_get_document() {
        this._persistence_checkFetched("document");
        return this.document;
    }

    public void _persistence_set_document(Document document) {
        this._persistence_checkFetchedForSet("document");
        this._persistence_propertyChange("document", (Object)this.document, (Object)document);
        this.document = document;
    }

    public Integer _persistence_get_successCount() {
        this._persistence_checkFetched("successCount");
        return this.successCount;
    }

    public void _persistence_set_successCount(Integer n) {
        this._persistence_checkFetchedForSet("successCount");
        this._persistence_propertyChange("successCount", (Object)this.successCount, (Object)n);
        this.successCount = n;
    }

    public LocalDateTime _persistence_get_endTime() {
        this._persistence_checkFetched("endTime");
        return this.endTime;
    }

    public void _persistence_set_endTime(LocalDateTime localDateTime) {
        this._persistence_checkFetchedForSet("endTime");
        this._persistence_propertyChange("endTime", (Object)this.endTime, (Object)localDateTime);
        this.endTime = localDateTime;
    }

    public Boolean _persistence_get_completed() {
        this._persistence_checkFetched("completed");
        return this.completed;
    }

    public void _persistence_set_completed(Boolean bl) {
        this._persistence_checkFetchedForSet("completed");
        this._persistence_propertyChange("completed", (Object)this.completed, (Object)bl);
        this.completed = bl;
    }

    public LocalDateTime _persistence_get_importTime() {
        this._persistence_checkFetched("importTime");
        return this.importTime;
    }

    public void _persistence_set_importTime(LocalDateTime localDateTime) {
        this._persistence_checkFetchedForSet("importTime");
        this._persistence_propertyChange("importTime", (Object)this.importTime, (Object)localDateTime);
        this.importTime = localDateTime;
    }

    public Integer _persistence_get_failureCount() {
        this._persistence_checkFetched("failureCount");
        return this.failureCount;
    }

    public void _persistence_set_failureCount(Integer n) {
        this._persistence_checkFetchedForSet("failureCount");
        this._persistence_propertyChange("failureCount", (Object)this.failureCount, (Object)n);
        this.failureCount = n;
    }
}

