/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob.service;

import java.time.LocalDate;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.cob.conditions.LoanCOBEnabledCondition;
import org.apache.fineract.cob.data.IsCatchUpRunningDTO;
import org.apache.fineract.cob.data.LoanIdAndLastClosedBusinessDate;
import org.apache.fineract.cob.data.OldestCOBProcessedLoanDTO;
import org.apache.fineract.cob.loan.RetrieveLoanIdService;
import org.apache.fineract.cob.service.AsyncLoanCOBExecutorService;
import org.apache.fineract.cob.service.LoanAccountLockService;
import org.apache.fineract.cob.service.LoanCOBCatchUpService;
import org.apache.fineract.infrastructure.businessdate.domain.BusinessDateType;
import org.apache.fineract.infrastructure.core.domain.FineractContext;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.infrastructure.jobs.domain.JobExecutionRepository;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={LoanCOBEnabledCondition.class})
public class LoanCOBCatchUpServiceImpl
implements LoanCOBCatchUpService {
    private final AsyncLoanCOBExecutorService asyncLoanCOBExecutorService;
    private final JobExecutionRepository jobExecutionRepository;
    private final RetrieveLoanIdService retrieveLoanIdService;
    private final LoanAccountLockService accountLockService;

    public void unlockHardLockedLoans() {
        this.accountLockService.updateCobAndRemoveLocks();
    }

    public OldestCOBProcessedLoanDTO getOldestCOBProcessedLoan() {
        List loanIdAndLastClosedBusinessDate = this.retrieveLoanIdService.retrieveLoanIdsOldestCobProcessed(ThreadLocalContextUtil.getBusinessDateByType((BusinessDateType)BusinessDateType.COB_DATE));
        OldestCOBProcessedLoanDTO oldestCOBProcessedLoanDTO = new OldestCOBProcessedLoanDTO();
        oldestCOBProcessedLoanDTO.setLoanIds(loanIdAndLastClosedBusinessDate.stream().map(LoanIdAndLastClosedBusinessDate::getId).toList());
        oldestCOBProcessedLoanDTO.setCobProcessedDate(loanIdAndLastClosedBusinessDate.stream().map(LoanIdAndLastClosedBusinessDate::getLastClosedBusinessDate).findFirst().orElse(ThreadLocalContextUtil.getBusinessDateByType((BusinessDateType)BusinessDateType.COB_DATE)));
        oldestCOBProcessedLoanDTO.setCobBusinessDate(ThreadLocalContextUtil.getBusinessDateByType((BusinessDateType)BusinessDateType.COB_DATE));
        return oldestCOBProcessedLoanDTO;
    }

    public void executeLoanCOBCatchUp() {
        FineractContext context = ThreadLocalContextUtil.getContext();
        this.asyncLoanCOBExecutorService.executeLoanCOBCatchUpAsync(context);
    }

    public IsCatchUpRunningDTO isCatchUpRunning() {
        LocalDate runningCatchUpBusinessDate = this.jobExecutionRepository.getBusinessDateOfRunningJobByExecutionParameter("LOAN_COB", "CUSTOM_JOB_PARAMETER_ID", "IS_CATCH_UP", "true", "BusinessDate");
        return new IsCatchUpRunningDTO(runningCatchUpBusinessDate != null, runningCatchUpBusinessDate);
    }

    @Generated
    public LoanCOBCatchUpServiceImpl(AsyncLoanCOBExecutorService asyncLoanCOBExecutorService, JobExecutionRepository jobExecutionRepository, RetrieveLoanIdService retrieveLoanIdService, LoanAccountLockService accountLockService) {
        this.asyncLoanCOBExecutorService = asyncLoanCOBExecutorService;
        this.jobExecutionRepository = jobExecutionRepository;
        this.retrieveLoanIdService = retrieveLoanIdService;
        this.accountLockService = accountLockService;
    }
}

