/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob.service;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.cob.conditions.LoanCOBEnabledCondition;
import org.apache.fineract.cob.data.LoanIdAndLastClosedBusinessDate;
import org.apache.fineract.cob.loan.RetrieveLoanIdService;
import org.apache.fineract.cob.service.AsyncLoanCOBExecutorService;
import org.apache.fineract.infrastructure.businessdate.domain.BusinessDateType;
import org.apache.fineract.infrastructure.core.domain.FineractContext;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.infrastructure.jobs.data.JobParameterDTO;
import org.apache.fineract.infrastructure.jobs.domain.JobParameterRepository;
import org.apache.fineract.infrastructure.jobs.domain.ScheduledJobDetail;
import org.apache.fineract.infrastructure.jobs.domain.ScheduledJobDetailRepository;
import org.apache.fineract.infrastructure.jobs.exception.JobNotFoundException;
import org.apache.fineract.infrastructure.jobs.service.JobStarter;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.configuration.JobLocator;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.context.annotation.Conditional;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={LoanCOBEnabledCondition.class})
public class AsyncLoanCOBExecutorServiceImpl
implements AsyncLoanCOBExecutorService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncLoanCOBExecutorServiceImpl.class);
    private final JobLocator jobLocator;
    private final ScheduledJobDetailRepository scheduledJobDetailRepository;
    private final JobStarter jobStarter;
    private final JobParameterRepository jobParameterRepository;
    private final RetrieveLoanIdService retrieveLoanIdService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async(value="loanCOBCatchUpThreadPoolTaskExecutor")
    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"})
    public void executeLoanCOBCatchUpAsync(FineractContext context) {
        try {
            LocalDate oldestCOBProcessedDate;
            ThreadLocalContextUtil.init((FineractContext)context);
            LocalDate cobBusinessDate = ThreadLocalContextUtil.getBusinessDateByType((BusinessDateType)BusinessDateType.COB_DATE);
            List loanIdAndLastClosedBusinessDate = this.retrieveLoanIdService.retrieveLoanIdsOldestCobProcessed(cobBusinessDate);
            LocalDate localDate = oldestCOBProcessedDate = !loanIdAndLastClosedBusinessDate.isEmpty() ? ((LoanIdAndLastClosedBusinessDate)loanIdAndLastClosedBusinessDate.get(0)).getLastClosedBusinessDate() : cobBusinessDate;
            if (DateUtils.isBefore((LocalDate)oldestCOBProcessedDate, (LocalDate)cobBusinessDate)) {
                this.executeLoanCOBDayByDayUntilCOBBusinessDate(oldestCOBProcessedDate, cobBusinessDate, context);
            }
        }
        catch (NoSuchJobException e) {
            log.error("", (Throwable)new JobNotFoundException("LOAN_COB", e));
        }
        catch (JobExecutionException | JobParametersInvalidException | JobExecutionAlreadyRunningException | JobInstanceAlreadyCompleteException | JobRestartException e) {
            log.error("", e);
        }
        finally {
            ThreadLocalContextUtil.reset();
        }
    }

    private void executeLoanCOBDayByDayUntilCOBBusinessDate(LocalDate oldestCOBProcessedDate, LocalDate cobBusinessDate, FineractContext context) throws NoSuchJobException, JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException, JobExecutionException {
        Job job = this.jobLocator.getJob("LOAN_COB");
        ScheduledJobDetail scheduledJobDetail = this.scheduledJobDetailRepository.findByJobName("Loan COB");
        LocalDate executingBusinessDate = oldestCOBProcessedDate.plusDays(1L);
        while (!DateUtils.isAfter((LocalDate)executingBusinessDate, (LocalDate)cobBusinessDate)) {
            ThreadLocalContextUtil.init((FineractContext)context);
            JobParameterDTO jobParameterDTO = new JobParameterDTO("BusinessDate", executingBusinessDate.format(DateTimeFormatter.ISO_DATE));
            JobParameterDTO jobParameterCatchUpDTO = new JobParameterDTO("IS_CATCH_UP", "true");
            HashSet jobParameters = new HashSet();
            Collections.addAll(jobParameters, jobParameterDTO, jobParameterCatchUpDTO);
            this.jobStarter.run(job, scheduledJobDetail, jobParameters, ThreadLocalContextUtil.getTenant().getTenantIdentifier());
            executingBusinessDate = executingBusinessDate.plusDays(1L);
        }
    }

    @Generated
    public AsyncLoanCOBExecutorServiceImpl(JobLocator jobLocator, ScheduledJobDetailRepository scheduledJobDetailRepository, JobStarter jobStarter, JobParameterRepository jobParameterRepository, RetrieveLoanIdService retrieveLoanIdService) {
        this.jobLocator = jobLocator;
        this.scheduledJobDetailRepository = scheduledJobDetailRepository;
        this.jobStarter = jobStarter;
        this.jobParameterRepository = jobParameterRepository;
        this.retrieveLoanIdService = retrieveLoanIdService;
    }
}

