/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.cob.api.LoanAccountLockApiResourceSwagger;
import org.apache.fineract.cob.data.LoanAccountLockResponseDTO;
import org.apache.fineract.cob.service.LoanAccountLockService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.springframework.stereotype.Component;

@Path(value="/v1/loans")
@Component
@Tag(name="Loan Account Lock", description="")
public class LoanAccountLockApiResource {
    private static final Set<String> LOAN_ACCOUNT_LOCK_RESPONSE_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("page", "limit", "content"));
    private final LoanAccountLockService loanAccountLockService;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final DefaultToApiJsonSerializer<LoanAccountLockResponseDTO> businessStepConfigSerializeService;

    @GET
    @Path(value="locked")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List locked loan accounts", description="Returns the locked loan IDs")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanAccountLockApiResourceSwagger.GetLoanAccountLockResponse.class))})})
    public String retrieveLockedAccounts(@Context UriInfo uriInfo, @QueryParam(value="page") Integer pageParam, @QueryParam(value="limit") Integer limitParam) {
        int page = Objects.requireNonNullElse(pageParam, 0);
        int limit = Objects.requireNonNullElse(limitParam, 50);
        List lockedLoanAccounts = this.loanAccountLockService.getLockedLoanAccountByPage(page, limit);
        LoanAccountLockResponseDTO response = new LoanAccountLockResponseDTO();
        response.setPage(page);
        response.setLimit(limit);
        response.setContent(lockedLoanAccounts);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.businessStepConfigSerializeService.serialize(settings, (Object)response, LOAN_ACCOUNT_LOCK_RESPONSE_DATA_PARAMETERS);
    }

    @Generated
    public LoanAccountLockApiResource(LoanAccountLockService loanAccountLockService, ApiRequestParameterHelper apiRequestParameterHelper, DefaultToApiJsonSerializer<LoanAccountLockResponseDTO> businessStepConfigSerializeService) {
        this.loanAccountLockService = loanAccountLockService;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.businessStepConfigSerializeService = businessStepConfigSerializeService;
    }
}

