/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.cob.api.ConfigureBusinessStepResourceSwagger;
import org.apache.fineract.cob.data.ConfiguredJobNamesDTO;
import org.apache.fineract.cob.data.JobBusinessStepConfigData;
import org.apache.fineract.cob.data.JobBusinessStepDetail;
import org.apache.fineract.cob.service.ConfigJobParameterService;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.springframework.stereotype.Component;

@Path(value="/v1/jobs")
@Component
@Tag(name="Business Step Configuration", description="")
public class ConfigureBusinessStepApiResource {
    private static final Set<String> BUSINESS_STEP_CONFIG_RESPONSE_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("jobName", "businessSteps"));
    private static final Set<String> BUSINESS_STEP_DETAIL_RESPONSE_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("jobName", "availableBusinessSteps"));
    private final DefaultToApiJsonSerializer<JobBusinessStepConfigData> businessStepConfigSerializeService;
    private final DefaultToApiJsonSerializer<JobBusinessStepDetail> businessStepDetailSerializeService;
    private final DefaultToApiJsonSerializer<ConfiguredJobNamesDTO> configuredJobNamesSerializer;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final ConfigJobParameterService configJobParameterService;
    private final PortfolioCommandSourceWritePlatformService commandWritePlatformService;

    @GET
    @Path(value="/names")
    @Produces(value={"application/json"})
    @Operation(summary="List Business Jobs", description="Returns the configured Business Jobs")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ConfigureBusinessStepResourceSwagger.GetBusinessJobConfigResponse.class))})})
    public String retrieveAllConfiguredBusinessJobs(@Context UriInfo uriInfo) {
        List businessJobNames = this.configJobParameterService.getAllConfiguredJobNames();
        ConfiguredJobNamesDTO result = new ConfiguredJobNamesDTO(businessJobNames);
        return this.configuredJobNamesSerializer.serialize((Object)result);
    }

    @GET
    @Path(value="{jobName}/steps")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Business Step Configurations for a Job", description="Returns the configured Business Steps for a job")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ConfigureBusinessStepResourceSwagger.GetBusinessStepConfigResponse.class))})})
    public String retrieveAllConfiguredBusinessStep(@Context UriInfo uriInfo, @PathParam(value="jobName") @Parameter(description="jobName") String jobName) {
        JobBusinessStepConfigData jobBusinessStepConfigData = this.configJobParameterService.getBusinessStepConfigByJobName(jobName);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.businessStepConfigSerializeService.serialize(settings, (Object)jobBusinessStepConfigData, BUSINESS_STEP_CONFIG_RESPONSE_DATA_PARAMETERS);
    }

    @PUT
    @Path(value="{jobName}/steps")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Business Step Configurations for a Job", description="Updates the Business steps execution order for a job")
    @RequestBody(content={@Content(schema=@Schema(implementation=ConfigureBusinessStepResourceSwagger.UpdateBusinessStepConfigRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="NO_CONTENT")})
    public Response updateJobBusinessStepConfig(@PathParam(value="jobName") @Parameter(description="jobName") String jobName, @Parameter(hidden=true) String jsonRequestBody) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateBusinessStepConfig(jobName).withJson(jsonRequestBody).build();
        this.commandWritePlatformService.logCommandSource(commandRequest);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @GET
    @Path(value="{jobName}/available-steps")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Business Step Configurations for a Job", description="Returns the available Business Steps for a job")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ConfigureBusinessStepResourceSwagger.GetBusinessStepConfigResponse.class))})})
    public String retrieveAllAvailableBusinessStep(@Context UriInfo uriInfo, @PathParam(value="jobName") @Parameter(description="jobName") String jobName) {
        JobBusinessStepDetail availableBusinessStepsByJobName = this.configJobParameterService.getAvailableBusinessStepsByJobName(jobName);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.businessStepDetailSerializeService.serialize(settings, (Object)availableBusinessStepsByJobName, BUSINESS_STEP_DETAIL_RESPONSE_DATA_PARAMETERS);
    }

    @Generated
    public ConfigureBusinessStepApiResource(DefaultToApiJsonSerializer<JobBusinessStepConfigData> businessStepConfigSerializeService, DefaultToApiJsonSerializer<JobBusinessStepDetail> businessStepDetailSerializeService, DefaultToApiJsonSerializer<ConfiguredJobNamesDTO> configuredJobNamesSerializer, ApiRequestParameterHelper apiRequestParameterHelper, ConfigJobParameterService configJobParameterService, PortfolioCommandSourceWritePlatformService commandWritePlatformService) {
        this.businessStepConfigSerializeService = businessStepConfigSerializeService;
        this.businessStepDetailSerializeService = businessStepDetailSerializeService;
        this.configuredJobNamesSerializer = configuredJobNamesSerializer;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.configJobParameterService = configJobParameterService;
        this.commandWritePlatformService = commandWritePlatformService;
    }
}

