/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import lombok.Generated;
import org.apache.fineract.cob.COBBusinessStep;
import org.apache.fineract.cob.COBBusinessStepService;
import org.apache.fineract.cob.data.BusinessStepNameAndOrder;
import org.apache.fineract.cob.domain.BatchBusinessStep;
import org.apache.fineract.cob.domain.BatchBusinessStepRepository;
import org.apache.fineract.cob.exceptions.BusinessStepException;
import org.apache.fineract.cob.service.ReloaderService;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.infrastructure.core.domain.ActionContext;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.infrastructure.event.business.service.BusinessEventNotifierService;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class COBBusinessStepServiceImpl
implements COBBusinessStepService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(COBBusinessStepServiceImpl.class);
    private final BatchBusinessStepRepository batchBusinessStepRepository;
    private final ApplicationContext applicationContext;
    private final ListableBeanFactory beanFactory;
    private final BusinessEventNotifierService businessEventNotifierService;
    private final ConfigurationDomainService configurationDomainService;
    private final ReloaderService reloaderService;

    public <T extends COBBusinessStep<S>, S extends AbstractPersistableCustom<Long>> S run(TreeMap<Long, String> executionMap, S item) {
        if (executionMap == null || executionMap.isEmpty()) {
            throw new BusinessStepException("Execution map is empty! COB Business step execution skipped!");
        }
        boolean bulkEventEnabled = this.configurationDomainService.isCOBBulkEventEnabled();
        try {
            if (bulkEventEnabled) {
                this.businessEventNotifierService.startExternalEventRecording();
            }
            for (String businessStep : executionMap.values()) {
                try {
                    ThreadLocalContextUtil.setActionContext((ActionContext)ActionContext.COB);
                    COBBusinessStep businessStepBean = (COBBusinessStep)this.applicationContext.getBean(businessStep);
                    item = this.reloaderService.reload(item);
                    item = businessStepBean.execute(item);
                }
                catch (Exception e) {
                    throw new BusinessStepException("Error happened during business step execution", (Throwable)e);
                }
                finally {
                    ThreadLocalContextUtil.setActionContext((ActionContext)ActionContext.COB);
                }
            }
            if (bulkEventEnabled) {
                this.businessEventNotifierService.stopExternalEventRecording();
            }
        }
        catch (Exception e) {
            if (bulkEventEnabled) {
                this.businessEventNotifierService.resetEventRecording();
            }
            throw e;
        }
        return item;
    }

    @NotNull
    public <T extends COBBusinessStep<S>, S extends AbstractPersistableCustom<Long>> Set<BusinessStepNameAndOrder> getCOBBusinessSteps(Class<T> businessStepClass, String cobJobName) {
        List cobStepConfigs = this.batchBusinessStepRepository.findAllByJobName(cobJobName);
        List<String> businessSteps = Arrays.stream(this.beanFactory.getBeanNamesForType(businessStepClass)).toList();
        HashSet<BusinessStepNameAndOrder> executionMap = new HashSet<BusinessStepNameAndOrder>();
        for (String businessStep : businessSteps) {
            COBBusinessStep businessStepBean = (COBBusinessStep)this.applicationContext.getBean(businessStep);
            Optional<BatchBusinessStep> businessStepConfig = cobStepConfigs.stream().filter(stepConfig -> businessStepBean.getEnumStyledName().equals(stepConfig.getStepName())).findFirst();
            businessStepConfig.ifPresent(batchBusinessStep -> executionMap.add(new BusinessStepNameAndOrder(businessStep, batchBusinessStep.getStepOrder())));
        }
        return executionMap;
    }

    @Generated
    public COBBusinessStepServiceImpl(BatchBusinessStepRepository batchBusinessStepRepository, ApplicationContext applicationContext, ListableBeanFactory beanFactory, BusinessEventNotifierService businessEventNotifierService, ConfigurationDomainService configurationDomainService, ReloaderService reloaderService) {
        this.batchBusinessStepRepository = batchBusinessStepRepository;
        this.applicationContext = applicationContext;
        this.beanFactory = beanFactory;
        this.businessEventNotifierService = businessEventNotifierService;
        this.configurationDomainService = configurationDomainService;
        this.reloaderService = reloaderService;
    }
}

