/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.accounting.journalentry.service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.accounting.closure.domain.GLClosure;
import org.apache.fineract.accounting.common.AccountingConstants;
import org.apache.fineract.accounting.glaccount.domain.GLAccount;
import org.apache.fineract.accounting.journalentry.data.ChargePaymentDTO;
import org.apache.fineract.accounting.journalentry.data.GLAccountBalanceHolder;
import org.apache.fineract.accounting.journalentry.data.LoanDTO;
import org.apache.fineract.accounting.journalentry.data.LoanTransactionDTO;
import org.apache.fineract.accounting.journalentry.service.AccountingProcessorForLoan;
import org.apache.fineract.accounting.journalentry.service.AccountingProcessorHelper;
import org.apache.fineract.accounting.journalentry.service.JournalAmountHolder;
import org.apache.fineract.infrastructure.core.service.MathUtil;
import org.apache.fineract.organisation.office.domain.Office;
import org.springframework.stereotype.Component;

@Component
public class CashBasedAccountingProcessorForLoan
implements AccountingProcessorForLoan {
    private final AccountingProcessorHelper helper;

    public void createJournalEntriesForLoan(LoanDTO loanDTO) {
        GLClosure latestGLClosure = this.helper.getLatestClosureByBranch(loanDTO.getOfficeId().longValue());
        Long loanProductId = loanDTO.getLoanProductId();
        String currencyCode = loanDTO.getCurrencyCode();
        for (LoanTransactionDTO loanTransactionDTO : loanDTO.getNewLoanTransactions()) {
            LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
            String transactionId = loanTransactionDTO.getTransactionId();
            Office office = this.helper.getOfficeById(loanTransactionDTO.getOfficeId().longValue());
            Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
            Long loanId = loanDTO.getLoanId();
            this.helper.checkForBranchClosures(latestGLClosure, transactionDate);
            if (loanTransactionDTO.getTransactionType().isDisbursement()) {
                this.createJournalEntriesForDisbursements(loanDTO, loanTransactionDTO, office);
                continue;
            }
            if (loanTransactionDTO.getTransactionType().isRepaymentType() && !loanTransactionDTO.getTransactionType().isChargeAdjustment() || loanTransactionDTO.getTransactionType().isRepaymentAtDisbursement() || loanTransactionDTO.getTransactionType().isChargePayment()) {
                this.createJournalEntriesForRepayments(loanDTO, loanTransactionDTO, office);
                continue;
            }
            if (loanTransactionDTO.getTransactionType().isRecoveryRepayment()) {
                this.createJournalEntriesForRecoveryRepayments(loanDTO, loanTransactionDTO, office);
                continue;
            }
            if (loanTransactionDTO.getTransactionType().isRefund()) {
                this.createJournalEntriesForRefund(loanDTO, loanTransactionDTO, office);
                continue;
            }
            if (loanTransactionDTO.getTransactionType().isCreditBalanceRefund()) {
                this.createJournalEntriesForCreditBalanceRefund(loanDTO, loanTransactionDTO, office);
                continue;
            }
            if (loanTransactionDTO.getTransactionType().isWriteOff()) {
                BigDecimal principalAmount = loanTransactionDTO.getPrincipal();
                if (principalAmount == null || principalAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                this.helper.createJournalEntriesAndReversalsForLoan(office, currencyCode, AccountingConstants.CashAccountsForLoan.LOSSES_WRITTEN_OFF.getValue(), AccountingConstants.CashAccountsForLoan.LOAN_PORTFOLIO.getValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, principalAmount, Boolean.valueOf(loanTransactionDTO.isReversed()));
                continue;
            }
            if (loanTransactionDTO.getTransactionType().isInitiateTransfer() || loanTransactionDTO.getTransactionType().isApproveTransfer() || loanTransactionDTO.getTransactionType().isWithdrawTransfer()) {
                this.createJournalEntriesForTransfers(loanDTO, loanTransactionDTO, office);
                continue;
            }
            if (loanTransactionDTO.getTransactionType().isRefundForActiveLoans()) {
                this.createJournalEntriesForRefundForActiveLoan(loanDTO, loanTransactionDTO, office);
                continue;
            }
            if (loanTransactionDTO.getTransactionType().isChargeback()) {
                this.createJournalEntriesForChargeback(loanDTO, loanTransactionDTO, office);
                continue;
            }
            if (loanTransactionDTO.getTransactionType().isChargeAdjustment()) {
                this.createJournalEntriesForChargeAdjustment(loanDTO, loanTransactionDTO, office);
                continue;
            }
            if (!loanTransactionDTO.getTransactionType().isChargeoff()) continue;
            this.createJournalEntriesForChargeOff(loanDTO, loanTransactionDTO, office);
        }
    }

    private void createJournalEntriesForChargeOff(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        GLAccount glAccount;
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        boolean isMarkedFraud = loanDTO.isMarkedAsFraud();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal principalAmount = loanTransactionDTO.getPrincipal();
        BigDecimal interestAmount = loanTransactionDTO.getInterest();
        BigDecimal feesAmount = loanTransactionDTO.getFees();
        BigDecimal penaltiesAmount = loanTransactionDTO.getPenalties();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        boolean isReversal = loanTransactionDTO.isReversed();
        GLAccountBalanceHolder glAccountBalanceHolder = new GLAccountBalanceHolder();
        if (principalAmount != null && principalAmount.compareTo(BigDecimal.ZERO) > 0) {
            if (isMarkedFraud) {
                this.populateCreditDebitMaps(loanProductId, principalAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.LOAN_PORTFOLIO.getValue(), AccountingConstants.CashAccountsForLoan.CHARGE_OFF_FRAUD_EXPENSE.getValue(), glAccountBalanceHolder);
            } else {
                this.populateCreditDebitMaps(loanProductId, principalAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.LOAN_PORTFOLIO.getValue(), AccountingConstants.CashAccountsForLoan.CHARGE_OFF_EXPENSE.getValue(), glAccountBalanceHolder);
            }
        }
        if (interestAmount != null && interestAmount.compareTo(BigDecimal.ZERO) > 0) {
            this.populateCreditDebitMaps(loanProductId, interestAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.INTEREST_ON_LOANS.getValue(), AccountingConstants.CashAccountsForLoan.INCOME_FROM_CHARGE_OFF_INTEREST.getValue(), glAccountBalanceHolder);
        }
        if (feesAmount != null && feesAmount.compareTo(BigDecimal.ZERO) > 0) {
            this.populateCreditDebitMaps(loanProductId, feesAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_FEES.getValue(), AccountingConstants.CashAccountsForLoan.INCOME_FROM_CHARGE_OFF_FEES.getValue(), glAccountBalanceHolder);
        }
        if (penaltiesAmount != null && penaltiesAmount.compareTo(BigDecimal.ZERO) > 0) {
            this.populateCreditDebitMaps(loanProductId, penaltiesAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_PENALTIES.getValue(), AccountingConstants.CashAccountsForLoan.INCOME_FROM_CHARGE_OFF_PENALTY.getValue(), glAccountBalanceHolder);
        }
        for (Map.Entry creditEntry : glAccountBalanceHolder.getCreditBalances().entrySet()) {
            glAccount = (GLAccount)glAccountBalanceHolder.getGlAccountMap().get(creditEntry.getKey());
            this.helper.createCreditJournalEntryOrReversalForLoan(office, currencyCode, loanId, transactionId, transactionDate, (BigDecimal)creditEntry.getValue(), Boolean.valueOf(isReversal), glAccount);
        }
        for (Map.Entry debitEntry : glAccountBalanceHolder.getDebitBalances().entrySet()) {
            glAccount = (GLAccount)glAccountBalanceHolder.getGlAccountMap().get(debitEntry.getKey());
            this.helper.createDebitJournalEntryOrReversalForLoan(office, currencyCode, loanId, transactionId, transactionDate, (BigDecimal)debitEntry.getValue(), Boolean.valueOf(isReversal), glAccount);
        }
    }

    private void populateCreditDebitMaps(Long loanProductId, BigDecimal transactionPartAmount, Long paymentTypeId, Integer creditAccountType, Integer debitAccountType, GLAccountBalanceHolder glAccountBalanceHolder) {
        GLAccount accountCredit = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, creditAccountType.intValue(), paymentTypeId);
        glAccountBalanceHolder.addToCredit(accountCredit, transactionPartAmount);
        GLAccount accountDebit = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, debitAccountType.intValue(), paymentTypeId);
        glAccountBalanceHolder.addToDebit(accountDebit, transactionPartAmount);
    }

    private Integer returnExistingDebitAccountInMapMatchingGLAccount(Long loanProductId, Long paymentTypeId, Integer accountType, Map<Integer, BigDecimal> accountMap) {
        GLAccount glAccount = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, accountType.intValue(), paymentTypeId);
        Integer accountEntry = accountMap.entrySet().stream().filter(account -> this.helper.getLinkedGLAccountForLoanProduct(loanProductId, ((Integer)account.getKey()).intValue(), paymentTypeId).getGlCode().equals(glAccount.getGlCode())).map(Map.Entry::getKey).findFirst().orElse(accountType);
        return accountEntry;
    }

    private void createJournalEntriesForChargeAdjustment(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        boolean isMarkedAsChargeOff = loanDTO.isMarkedAsChargeOff();
        if (isMarkedAsChargeOff) {
            this.createJournalEntriesForChargeOffLoanChargeAdjustment(loanDTO, loanTransactionDTO, office);
        } else {
            this.createJournalEntriesForLoanChargeAdjustment(loanDTO, loanTransactionDTO, office);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createJournalEntriesForChargeOffLoanChargeAdjustment(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        GLAccount account;
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal principalAmount = loanTransactionDTO.getPrincipal();
        BigDecimal interestAmount = loanTransactionDTO.getInterest();
        BigDecimal feesAmount = loanTransactionDTO.getFees();
        BigDecimal penaltiesAmount = loanTransactionDTO.getPenalties();
        BigDecimal overPaymentAmount = loanTransactionDTO.getOverPayment();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        boolean isReversal = loanTransactionDTO.isReversed();
        BigDecimal totalDebitAmount = new BigDecimal(0);
        LinkedHashMap<GLAccount, BigDecimal> accountMap = new LinkedHashMap<GLAccount, BigDecimal>();
        if (principalAmount != null && principalAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(principalAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_CHARGE_OFF_FEES.getValue().intValue(), paymentTypeId);
            accountMap.put(account, principalAmount);
        }
        if (interestAmount != null && interestAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(interestAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_CHARGE_OFF_FEES.getValue().intValue(), paymentTypeId);
            if (accountMap.containsKey(account)) {
                BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(interestAmount);
                accountMap.put(account, bigDecimal);
            } else {
                accountMap.put(account, interestAmount);
            }
        }
        if (feesAmount != null && feesAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(feesAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_CHARGE_OFF_FEES.getValue().intValue(), paymentTypeId);
            if (accountMap.containsKey(account)) {
                BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(feesAmount);
                accountMap.put(account, bigDecimal);
            } else {
                accountMap.put(account, feesAmount);
            }
        }
        if (penaltiesAmount != null && penaltiesAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(penaltiesAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_CHARGE_OFF_PENALTY.getValue().intValue(), paymentTypeId);
            if (accountMap.containsKey(account)) {
                BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(penaltiesAmount);
                accountMap.put(account, bigDecimal);
            } else {
                accountMap.put(account, penaltiesAmount);
            }
        }
        if (overPaymentAmount != null && overPaymentAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(overPaymentAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.CashAccountsForLoan.OVERPAYMENT.getValue().intValue(), paymentTypeId);
            if (accountMap.containsKey(account)) {
                BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(overPaymentAmount);
                accountMap.put(account, bigDecimal);
            } else {
                accountMap.put(account, overPaymentAmount);
            }
        }
        for (Map.Entry entry : accountMap.entrySet()) {
            this.helper.createCreditJournalEntryOrReversalForLoan(office, currencyCode, loanId, transactionId, transactionDate, (BigDecimal)entry.getValue(), Boolean.valueOf(isReversal), (GLAccount)entry.getKey());
        }
        if (totalDebitAmount.compareTo(BigDecimal.ZERO) > 0) {
            void var19_30;
            Long chargeId = loanTransactionDTO.getLoanChargeData().getChargeId();
            if (loanTransactionDTO.getLoanChargeData().isPenalty()) {
                Integer n = AccountingConstants.CashAccountsForLoan.INCOME_FROM_PENALTIES.getValue();
            } else {
                Integer n = AccountingConstants.CashAccountsForLoan.INCOME_FROM_FEES.getValue();
            }
            this.helper.createDebitJournalEntryOrReversalForLoanCharges(office, currencyCode, var19_30.intValue(), loanProductId, chargeId, loanId, transactionId, transactionDate, totalDebitAmount, Boolean.valueOf(isReversal));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createJournalEntriesForLoanChargeAdjustment(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        GLAccount account;
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal principalAmount = loanTransactionDTO.getPrincipal();
        BigDecimal interestAmount = loanTransactionDTO.getInterest();
        BigDecimal feesAmount = loanTransactionDTO.getFees();
        BigDecimal penaltiesAmount = loanTransactionDTO.getPenalties();
        BigDecimal overPaymentAmount = loanTransactionDTO.getOverPayment();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        boolean isReversal = loanTransactionDTO.isReversed();
        BigDecimal totalDebitAmount = new BigDecimal(0);
        LinkedHashMap<GLAccount, BigDecimal> accountMap = new LinkedHashMap<GLAccount, BigDecimal>();
        if (principalAmount != null && principalAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(principalAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.CashAccountsForLoan.LOAN_PORTFOLIO.getValue().intValue(), paymentTypeId);
            accountMap.put(account, principalAmount);
        }
        if (interestAmount != null && interestAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(interestAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.CashAccountsForLoan.INTEREST_ON_LOANS.getValue().intValue(), paymentTypeId);
            if (accountMap.containsKey(account)) {
                BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(interestAmount);
                accountMap.put(account, bigDecimal);
            } else {
                accountMap.put(account, interestAmount);
            }
        }
        if (feesAmount != null && feesAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(feesAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_FEES.getValue().intValue(), paymentTypeId);
            if (accountMap.containsKey(account)) {
                BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(feesAmount);
                accountMap.put(account, bigDecimal);
            } else {
                accountMap.put(account, feesAmount);
            }
        }
        if (penaltiesAmount != null && penaltiesAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(penaltiesAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_PENALTIES.getValue().intValue(), paymentTypeId);
            if (accountMap.containsKey(account)) {
                BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(penaltiesAmount);
                accountMap.put(account, bigDecimal);
            } else {
                accountMap.put(account, penaltiesAmount);
            }
        }
        if (overPaymentAmount != null && overPaymentAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(overPaymentAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.CashAccountsForLoan.OVERPAYMENT.getValue().intValue(), paymentTypeId);
            if (accountMap.containsKey(account)) {
                BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(overPaymentAmount);
                accountMap.put(account, bigDecimal);
            } else {
                accountMap.put(account, overPaymentAmount);
            }
        }
        for (Map.Entry entry : accountMap.entrySet()) {
            this.helper.createCreditJournalEntryOrReversalForLoan(office, currencyCode, loanId, transactionId, transactionDate, (BigDecimal)entry.getValue(), Boolean.valueOf(isReversal), (GLAccount)entry.getKey());
        }
        if (totalDebitAmount.compareTo(BigDecimal.ZERO) > 0) {
            void var19_30;
            Long chargeId = loanTransactionDTO.getLoanChargeData().getChargeId();
            if (loanTransactionDTO.getLoanChargeData().isPenalty()) {
                Integer n = AccountingConstants.CashAccountsForLoan.INCOME_FROM_PENALTIES.getValue();
            } else {
                Integer n = AccountingConstants.CashAccountsForLoan.INCOME_FROM_FEES.getValue();
            }
            this.helper.createDebitJournalEntryOrReversalForLoanCharges(office, currencyCode, var19_30.intValue(), loanProductId, chargeId, loanId, transactionId, transactionDate, totalDebitAmount, Boolean.valueOf(isReversal));
        }
    }

    private void createJournalEntriesForChargeback(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal amount = loanTransactionDTO.getAmount();
        boolean isReversal = loanTransactionDTO.isReversed();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        this.helper.createJournalEntriesAndReversalsForLoan(office, currencyCode, AccountingConstants.CashAccountsForLoan.LOAN_PORTFOLIO.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, amount, Boolean.valueOf(isReversal));
    }

    private void createJournalEntriesForDisbursements(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal overpaymentPortion = loanTransactionDTO.getOverPayment() != null ? loanTransactionDTO.getOverPayment() : BigDecimal.ZERO;
        BigDecimal principalPortion = loanTransactionDTO.getAmount().subtract(overpaymentPortion);
        boolean isReversal = loanTransactionDTO.isReversed();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        if (MathUtil.isGreaterThanZero((BigDecimal)principalPortion)) {
            this.helper.createDebitJournalEntryOrReversalForLoan(office, currencyCode, AccountingConstants.CashAccountsForLoan.LOAN_PORTFOLIO.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, principalPortion, Boolean.valueOf(isReversal));
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)overpaymentPortion)) {
            this.helper.createDebitJournalEntryOrReversalForLoan(office, currencyCode, AccountingConstants.CashAccountsForLoan.OVERPAYMENT.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, overpaymentPortion, Boolean.valueOf(isReversal));
        }
        if (loanTransactionDTO.isLoanToLoanTransfer()) {
            this.helper.createCreditJournalEntryOrReversalForLoan(office, currencyCode, AccountingConstants.FinancialActivity.ASSET_TRANSFER.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, loanTransactionDTO.getAmount(), Boolean.valueOf(isReversal));
        } else if (loanTransactionDTO.isAccountTransfer()) {
            this.helper.createCreditJournalEntryOrReversalForLoan(office, currencyCode, AccountingConstants.FinancialActivity.LIABILITY_TRANSFER.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, loanTransactionDTO.getAmount(), Boolean.valueOf(isReversal));
        } else {
            this.helper.createCreditJournalEntryOrReversalForLoan(office, currencyCode, AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, loanTransactionDTO.getAmount(), Boolean.valueOf(isReversal));
        }
    }

    private void createJournalEntriesForRefund(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal refundAmount = loanTransactionDTO.getAmount();
        boolean isReversal = loanTransactionDTO.isReversed();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        if (loanTransactionDTO.isAccountTransfer()) {
            this.helper.createJournalEntriesAndReversalsForLoan(office, currencyCode, AccountingConstants.CashAccountsForLoan.OVERPAYMENT.getValue(), AccountingConstants.FinancialActivity.LIABILITY_TRANSFER.getValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, refundAmount, Boolean.valueOf(isReversal));
        } else {
            this.helper.createJournalEntriesAndReversalsForLoan(office, currencyCode, AccountingConstants.CashAccountsForLoan.OVERPAYMENT.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, refundAmount, Boolean.valueOf(isReversal));
        }
    }

    private void createJournalEntriesForRepayments(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        boolean isMarkedChargeOff = loanDTO.isMarkedAsChargeOff();
        if (isMarkedChargeOff) {
            this.createJournalEntriesForChargeOffLoanRepayments(loanDTO, loanTransactionDTO, office);
        } else {
            this.createJournalEntriesForLoanRepayments(loanDTO, loanTransactionDTO, office);
        }
    }

    private void createJournalEntriesForChargeOffLoanRepayments(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        GLAccount glAccount;
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        boolean isMarkedFraud = loanDTO.isMarkedAsFraud();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal principalAmount = loanTransactionDTO.getPrincipal();
        BigDecimal interestAmount = loanTransactionDTO.getInterest();
        BigDecimal feesAmount = loanTransactionDTO.getFees();
        BigDecimal penaltiesAmount = loanTransactionDTO.getPenalties();
        BigDecimal overPaymentAmount = loanTransactionDTO.getOverPayment();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        boolean isReversal = loanTransactionDTO.isReversed();
        GLAccountBalanceHolder glAccountBalanceHolder = new GLAccountBalanceHolder();
        BigDecimal totalDebitAmount = new BigDecimal(0);
        if (principalAmount != null && principalAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(principalAmount);
            if (loanTransactionDTO.getTransactionType().isMerchantIssuedRefund()) {
                if (isMarkedFraud) {
                    this.populateCreditDebitMaps(loanProductId, principalAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.CHARGE_OFF_FRAUD_EXPENSE.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
                } else {
                    this.populateCreditDebitMaps(loanProductId, principalAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.CHARGE_OFF_EXPENSE.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
                }
            } else if (loanTransactionDTO.getTransactionType().isPayoutRefund()) {
                if (isMarkedFraud) {
                    this.populateCreditDebitMaps(loanProductId, principalAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.CHARGE_OFF_FRAUD_EXPENSE.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
                } else {
                    this.populateCreditDebitMaps(loanProductId, principalAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.CHARGE_OFF_EXPENSE.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
                }
            } else if (loanTransactionDTO.getTransactionType().isGoodwillCredit()) {
                this.populateCreditDebitMaps(loanProductId, principalAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_RECOVERY.getValue(), AccountingConstants.CashAccountsForLoan.GOODWILL_CREDIT.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isRepayment()) {
                this.populateCreditDebitMaps(loanProductId, principalAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_RECOVERY.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else {
                this.populateCreditDebitMaps(loanProductId, principalAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.LOAN_PORTFOLIO.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            }
        }
        if (interestAmount != null && interestAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(interestAmount);
            if (loanTransactionDTO.getTransactionType().isMerchantIssuedRefund()) {
                this.populateCreditDebitMaps(loanProductId, interestAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_CHARGE_OFF_INTEREST.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isPayoutRefund()) {
                this.populateCreditDebitMaps(loanProductId, interestAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_CHARGE_OFF_INTEREST.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isGoodwillCredit()) {
                this.populateCreditDebitMaps(loanProductId, interestAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_RECOVERY.getValue(), AccountingConstants.CashAccountsForLoan.INCOME_FROM_GOODWILL_CREDIT_INTEREST.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isRepayment()) {
                this.populateCreditDebitMaps(loanProductId, interestAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_RECOVERY.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else {
                this.populateCreditDebitMaps(loanProductId, interestAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.INTEREST_ON_LOANS.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            }
        }
        if (feesAmount != null && feesAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(feesAmount);
            if (loanTransactionDTO.getTransactionType().isMerchantIssuedRefund()) {
                this.populateCreditDebitMaps(loanProductId, feesAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_CHARGE_OFF_FEES.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isPayoutRefund()) {
                this.populateCreditDebitMaps(loanProductId, feesAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_CHARGE_OFF_FEES.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isGoodwillCredit()) {
                this.populateCreditDebitMaps(loanProductId, feesAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_RECOVERY.getValue(), AccountingConstants.CashAccountsForLoan.INCOME_FROM_GOODWILL_CREDIT_FEES.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isRepayment()) {
                this.populateCreditDebitMaps(loanProductId, feesAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_RECOVERY.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else {
                this.populateCreditDebitMaps(loanProductId, feesAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_FEES.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            }
        }
        if (penaltiesAmount != null && penaltiesAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(penaltiesAmount);
            if (loanTransactionDTO.getTransactionType().isMerchantIssuedRefund()) {
                this.populateCreditDebitMaps(loanProductId, penaltiesAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_CHARGE_OFF_PENALTY.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isPayoutRefund()) {
                this.populateCreditDebitMaps(loanProductId, penaltiesAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_CHARGE_OFF_PENALTY.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isGoodwillCredit()) {
                this.populateCreditDebitMaps(loanProductId, penaltiesAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_RECOVERY.getValue(), AccountingConstants.CashAccountsForLoan.INCOME_FROM_GOODWILL_CREDIT_PENALTY.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isRepayment()) {
                this.populateCreditDebitMaps(loanProductId, penaltiesAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_RECOVERY.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else {
                this.populateCreditDebitMaps(loanProductId, penaltiesAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_PENALTIES.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            }
        }
        if (overPaymentAmount != null && overPaymentAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(overPaymentAmount);
            if (loanTransactionDTO.getTransactionType().isMerchantIssuedRefund()) {
                this.populateCreditDebitMaps(loanProductId, overPaymentAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.OVERPAYMENT.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isPayoutRefund()) {
                this.populateCreditDebitMaps(loanProductId, overPaymentAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.OVERPAYMENT.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isGoodwillCredit()) {
                this.populateCreditDebitMaps(loanProductId, overPaymentAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.OVERPAYMENT.getValue(), AccountingConstants.CashAccountsForLoan.GOODWILL_CREDIT.getValue(), glAccountBalanceHolder);
            } else {
                this.populateCreditDebitMaps(loanProductId, overPaymentAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.OVERPAYMENT.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            }
        }
        for (Map.Entry creditEntry : glAccountBalanceHolder.getCreditBalances().entrySet()) {
            glAccount = (GLAccount)glAccountBalanceHolder.getGlAccountMap().get(creditEntry.getKey());
            this.helper.createCreditJournalEntryOrReversalForLoan(office, currencyCode, loanId, transactionId, transactionDate, (BigDecimal)creditEntry.getValue(), Boolean.valueOf(isReversal), glAccount);
        }
        if (loanTransactionDTO.isLoanToLoanTransfer()) {
            this.helper.createDebitJournalEntryOrReversalForLoan(office, currencyCode, AccountingConstants.FinancialActivity.ASSET_TRANSFER.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, totalDebitAmount, Boolean.valueOf(isReversal));
        } else if (loanTransactionDTO.isAccountTransfer()) {
            this.helper.createDebitJournalEntryOrReversalForLoan(office, currencyCode, AccountingConstants.FinancialActivity.LIABILITY_TRANSFER.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, totalDebitAmount, Boolean.valueOf(isReversal));
        } else {
            for (Map.Entry debitEntry : glAccountBalanceHolder.getDebitBalances().entrySet()) {
                glAccount = (GLAccount)glAccountBalanceHolder.getGlAccountMap().get(debitEntry.getKey());
                this.helper.createDebitJournalEntryOrReversalForLoan(office, currencyCode, loanId, transactionId, transactionDate, (BigDecimal)debitEntry.getValue(), Boolean.valueOf(isReversal), glAccount);
            }
        }
        if (totalDebitAmount.compareTo(BigDecimal.ZERO) > 0 && loanTransactionDTO.getTransactionType().isChargeRefund()) {
            Integer incomeAccount = this.helper.getValueForFeeOrPenaltyIncomeAccount(loanTransactionDTO.getChargeRefundChargeType());
            this.helper.createJournalEntriesAndReversalsForLoan(office, currencyCode, incomeAccount, AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, totalDebitAmount, Boolean.valueOf(isReversal));
        }
    }

    private void createJournalEntriesForLoanRepayments(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal principalAmount = loanTransactionDTO.getPrincipal();
        BigDecimal interestAmount = loanTransactionDTO.getInterest();
        BigDecimal feesAmount = loanTransactionDTO.getFees();
        BigDecimal penaltiesAmount = loanTransactionDTO.getPenalties();
        BigDecimal overPaymentAmount = loanTransactionDTO.getOverPayment();
        boolean isReversal = loanTransactionDTO.isReversed();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        BigDecimal totalDebitAmount = new BigDecimal(0);
        LinkedHashMap debitAccountMapForGoodwillCredit = new LinkedHashMap();
        if (principalAmount != null && principalAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(principalAmount);
            this.helper.createCreditJournalEntryOrReversalForLoan(office, currencyCode, AccountingConstants.CashAccountsForLoan.LOAN_PORTFOLIO, loanProductId, paymentTypeId, loanId, transactionId, transactionDate, principalAmount, Boolean.valueOf(isReversal));
            if (loanTransactionDTO.getTransactionType().isGoodwillCredit()) {
                this.populateDebitAccountEntry(loanProductId, principalAmount, AccountingConstants.CashAccountsForLoan.GOODWILL_CREDIT.getValue(), debitAccountMapForGoodwillCredit, paymentTypeId);
            }
        }
        if (interestAmount != null && interestAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(interestAmount);
            this.helper.createCreditJournalEntryOrReversalForLoan(office, currencyCode, AccountingConstants.CashAccountsForLoan.INTEREST_ON_LOANS, loanProductId, paymentTypeId, loanId, transactionId, transactionDate, interestAmount, Boolean.valueOf(isReversal));
            if (loanTransactionDTO.getTransactionType().isGoodwillCredit()) {
                this.populateDebitAccountEntry(loanProductId, interestAmount, AccountingConstants.CashAccountsForLoan.INCOME_FROM_GOODWILL_CREDIT_INTEREST.getValue(), debitAccountMapForGoodwillCredit, paymentTypeId);
            }
        }
        if (feesAmount != null && feesAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(feesAmount);
            this.helper.createCreditJournalEntryOrReversalForLoanCharges(office, currencyCode, AccountingConstants.CashAccountsForLoan.INCOME_FROM_FEES.getValue().intValue(), loanProductId, loanId, transactionId, transactionDate, feesAmount, Boolean.valueOf(isReversal), loanTransactionDTO.getFeePayments());
            if (loanTransactionDTO.getTransactionType().isGoodwillCredit()) {
                this.populateDebitAccountEntry(loanProductId, feesAmount, AccountingConstants.CashAccountsForLoan.INCOME_FROM_GOODWILL_CREDIT_FEES.getValue(), debitAccountMapForGoodwillCredit, paymentTypeId);
            }
        }
        if (penaltiesAmount != null && penaltiesAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(penaltiesAmount);
            this.helper.createCreditJournalEntryOrReversalForLoanCharges(office, currencyCode, AccountingConstants.CashAccountsForLoan.INCOME_FROM_PENALTIES.getValue().intValue(), loanProductId, loanId, transactionId, transactionDate, penaltiesAmount, Boolean.valueOf(isReversal), loanTransactionDTO.getPenaltyPayments());
            if (loanTransactionDTO.getTransactionType().isGoodwillCredit()) {
                this.populateDebitAccountEntry(loanProductId, penaltiesAmount, AccountingConstants.CashAccountsForLoan.INCOME_FROM_GOODWILL_CREDIT_PENALTY.getValue(), debitAccountMapForGoodwillCredit, paymentTypeId);
            }
        }
        if (overPaymentAmount != null && overPaymentAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(overPaymentAmount);
            this.helper.createCreditJournalEntryOrReversalForLoan(office, currencyCode, AccountingConstants.CashAccountsForLoan.OVERPAYMENT, loanProductId, paymentTypeId, loanId, transactionId, transactionDate, overPaymentAmount, Boolean.valueOf(isReversal));
            if (loanTransactionDTO.getTransactionType().isGoodwillCredit()) {
                this.populateDebitAccountEntry(loanProductId, overPaymentAmount, AccountingConstants.CashAccountsForLoan.GOODWILL_CREDIT.getValue(), debitAccountMapForGoodwillCredit, paymentTypeId);
            }
        }
        if (loanTransactionDTO.isLoanToLoanTransfer()) {
            this.helper.createDebitJournalEntryOrReversalForLoan(office, currencyCode, AccountingConstants.FinancialActivity.ASSET_TRANSFER.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, totalDebitAmount, Boolean.valueOf(isReversal));
        } else if (loanTransactionDTO.isAccountTransfer()) {
            this.helper.createDebitJournalEntryOrReversalForLoan(office, currencyCode, AccountingConstants.FinancialActivity.LIABILITY_TRANSFER.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, totalDebitAmount, Boolean.valueOf(isReversal));
        } else if (loanTransactionDTO.getTransactionType().isGoodwillCredit()) {
            for (Map.Entry debitEntry : debitAccountMapForGoodwillCredit.entrySet()) {
                this.helper.createDebitJournalEntryOrReversalForLoan(office, currencyCode, ((Integer)debitEntry.getKey()).intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, (BigDecimal)debitEntry.getValue(), Boolean.valueOf(isReversal));
            }
        } else {
            this.helper.createDebitJournalEntryOrReversalForLoan(office, currencyCode, AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, totalDebitAmount, Boolean.valueOf(isReversal));
        }
        if (totalDebitAmount.compareTo(BigDecimal.ZERO) > 0 && loanTransactionDTO.getTransactionType().isChargeRefund()) {
            Integer incomeAccount = this.helper.getValueForFeeOrPenaltyIncomeAccount(loanTransactionDTO.getChargeRefundChargeType());
            this.helper.createJournalEntriesAndReversalsForLoan(office, currencyCode, incomeAccount, AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, totalDebitAmount, Boolean.valueOf(isReversal));
        }
    }

    private void populateDebitAccountEntry(Long loanProductId, BigDecimal transactionPartAmount, Integer debitAccountType, Map<Integer, BigDecimal> accountMapForDebit, Long paymentTypeId) {
        Integer accountDebit = this.returnExistingDebitAccountInMapMatchingGLAccount(loanProductId, paymentTypeId, debitAccountType, accountMapForDebit);
        if (accountMapForDebit.containsKey(accountDebit)) {
            BigDecimal amount = accountMapForDebit.get(accountDebit).add(transactionPartAmount);
            accountMapForDebit.put(accountDebit, amount);
        } else {
            accountMapForDebit.put(accountDebit, transactionPartAmount);
        }
    }

    private void createJournalEntriesForRecoveryRepayments(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal amount = loanTransactionDTO.getAmount();
        boolean isReversal = loanTransactionDTO.isReversed();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        this.helper.createJournalEntriesAndReversalsForLoan(office, currencyCode, AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), AccountingConstants.CashAccountsForLoan.INCOME_FROM_RECOVERY.getValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, amount, Boolean.valueOf(isReversal));
    }

    private void createJournalEntriesForTransfers(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal principalAmount = loanTransactionDTO.getPrincipal();
        boolean isReversal = loanTransactionDTO.isReversed();
        if (loanTransactionDTO.getTransactionType().isInitiateTransfer()) {
            this.helper.createJournalEntriesAndReversalsForLoan(office, currencyCode, AccountingConstants.CashAccountsForLoan.TRANSFERS_SUSPENSE.getValue(), AccountingConstants.CashAccountsForLoan.LOAN_PORTFOLIO.getValue(), loanProductId, null, loanId, transactionId, transactionDate, principalAmount, Boolean.valueOf(isReversal));
        } else if (loanTransactionDTO.getTransactionType().isApproveTransfer() || loanTransactionDTO.getTransactionType().isWithdrawTransfer()) {
            this.helper.createJournalEntriesAndReversalsForLoan(office, currencyCode, AccountingConstants.CashAccountsForLoan.LOAN_PORTFOLIO.getValue(), AccountingConstants.CashAccountsForLoan.TRANSFERS_SUSPENSE.getValue(), loanProductId, null, loanId, transactionId, transactionDate, principalAmount, Boolean.valueOf(isReversal));
        }
    }

    private void createJournalEntriesForCreditBalanceRefund(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        boolean isReversal = loanTransactionDTO.isReversed();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        BigDecimal overpaymentAmount = loanTransactionDTO.getOverPayment();
        BigDecimal principalAmount = loanTransactionDTO.getPrincipal();
        BigDecimal totalAmount = BigDecimal.ZERO;
        ArrayList<JournalAmountHolder> journalAmountHolders = new ArrayList<JournalAmountHolder>();
        if (principalAmount != null && principalAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalAmount = totalAmount.add(principalAmount);
            journalAmountHolders.add(new JournalAmountHolder(AccountingConstants.CashAccountsForLoan.LOAN_PORTFOLIO.getValue(), principalAmount));
        }
        if (overpaymentAmount != null && overpaymentAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalAmount = totalAmount.add(overpaymentAmount);
            journalAmountHolders.add(new JournalAmountHolder(AccountingConstants.CashAccountsForLoan.OVERPAYMENT.getValue(), overpaymentAmount));
        }
        JournalAmountHolder totalAmountHolder = new JournalAmountHolder(AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), totalAmount);
        this.helper.createSplitJournalEntriesAndReversalsForLoan(office, currencyCode, journalAmountHolders, totalAmountHolder, loanProductId, paymentTypeId, loanId, transactionId, transactionDate, Boolean.valueOf(isReversal));
    }

    private void createJournalEntriesForRefundForActiveLoan(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        ArrayList<ChargePaymentDTO> chargePaymentDTOs;
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal principalAmount = loanTransactionDTO.getPrincipal();
        BigDecimal interestAmount = loanTransactionDTO.getInterest();
        BigDecimal feesAmount = loanTransactionDTO.getFees();
        BigDecimal penaltiesAmount = loanTransactionDTO.getPenalties();
        BigDecimal overPaymentAmount = loanTransactionDTO.getOverPayment();
        boolean isReversal = loanTransactionDTO.isReversed();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        BigDecimal totalDebitAmount = new BigDecimal(0);
        if (principalAmount != null && principalAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(principalAmount);
            this.helper.createCreditJournalEntryOrReversalForLoan(office, currencyCode, AccountingConstants.CashAccountsForLoan.LOAN_PORTFOLIO, loanProductId, paymentTypeId, loanId, transactionId, transactionDate, principalAmount, Boolean.valueOf(!isReversal));
        }
        if (interestAmount != null && interestAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(interestAmount);
            this.helper.createCreditJournalEntryOrReversalForLoan(office, currencyCode, AccountingConstants.CashAccountsForLoan.INTEREST_ON_LOANS, loanProductId, paymentTypeId, loanId, transactionId, transactionDate, interestAmount, Boolean.valueOf(!isReversal));
        }
        if (feesAmount != null && feesAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(feesAmount);
            chargePaymentDTOs = new ArrayList<ChargePaymentDTO>();
            for (ChargePaymentDTO chargePaymentDTO : loanTransactionDTO.getFeePayments()) {
                chargePaymentDTOs.add(new ChargePaymentDTO(chargePaymentDTO.getChargeId(), chargePaymentDTO.getAmount().floatValue() < 0.0f ? chargePaymentDTO.getAmount().multiply(new BigDecimal(-1)) : chargePaymentDTO.getAmount(), chargePaymentDTO.getLoanChargeId()));
            }
            this.helper.createCreditJournalEntryOrReversalForLoanCharges(office, currencyCode, AccountingConstants.CashAccountsForLoan.INCOME_FROM_FEES.getValue().intValue(), loanProductId, loanId, transactionId, transactionDate, feesAmount, Boolean.valueOf(!isReversal), chargePaymentDTOs);
        }
        if (penaltiesAmount != null && penaltiesAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(penaltiesAmount);
            chargePaymentDTOs = new ArrayList();
            for (ChargePaymentDTO chargePaymentDTO : loanTransactionDTO.getPenaltyPayments()) {
                chargePaymentDTOs.add(new ChargePaymentDTO(chargePaymentDTO.getChargeId(), chargePaymentDTO.getAmount().floatValue() < 0.0f ? chargePaymentDTO.getAmount().multiply(new BigDecimal(-1)) : chargePaymentDTO.getAmount(), chargePaymentDTO.getLoanChargeId()));
            }
            this.helper.createCreditJournalEntryOrReversalForLoanCharges(office, currencyCode, AccountingConstants.CashAccountsForLoan.INCOME_FROM_PENALTIES.getValue().intValue(), loanProductId, loanId, transactionId, transactionDate, penaltiesAmount, Boolean.valueOf(!isReversal), chargePaymentDTOs);
        }
        if (overPaymentAmount != null && overPaymentAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(overPaymentAmount);
            this.helper.createCreditJournalEntryOrReversalForLoan(office, currencyCode, AccountingConstants.CashAccountsForLoan.OVERPAYMENT, loanProductId, paymentTypeId, loanId, transactionId, transactionDate, overPaymentAmount, Boolean.valueOf(!isReversal));
        }
        this.helper.createDebitJournalEntryOrReversalForLoan(office, currencyCode, AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, totalDebitAmount, Boolean.valueOf(!isReversal));
    }

    @Generated
    public CashBasedAccountingProcessorForLoan(AccountingProcessorHelper helper) {
        this.helper = helper;
    }
}

