/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.accounting.journalentry.service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.fineract.accounting.closure.domain.GLClosure;
import org.apache.fineract.accounting.common.AccountingConstants;
import org.apache.fineract.accounting.glaccount.domain.GLAccount;
import org.apache.fineract.accounting.journalentry.data.ChargePaymentDTO;
import org.apache.fineract.accounting.journalentry.data.GLAccountBalanceHolder;
import org.apache.fineract.accounting.journalentry.data.LoanDTO;
import org.apache.fineract.accounting.journalentry.data.LoanTransactionDTO;
import org.apache.fineract.accounting.journalentry.service.AccountingProcessorForLoan;
import org.apache.fineract.accounting.journalentry.service.AccountingProcessorHelper;
import org.apache.fineract.accounting.journalentry.service.JournalAmountHolder;
import org.apache.fineract.accounting.producttoaccountmapping.domain.ProductToGLAccountMapping;
import org.apache.fineract.infrastructure.core.service.MathUtil;
import org.apache.fineract.organisation.office.domain.Office;
import org.apache.fineract.portfolio.PortfolioProductType;
import org.apache.fineract.portfolio.loanaccount.data.LoanTransactionEnumData;
import org.springframework.stereotype.Component;

@Component
public class AccrualBasedAccountingProcessorForLoan
implements AccountingProcessorForLoan {
    private final AccountingProcessorHelper helper;

    public void createJournalEntriesForLoan(LoanDTO loanDTO) {
        GLClosure latestGLClosure = this.helper.getLatestClosureByBranch(loanDTO.getOfficeId().longValue());
        Office office = this.helper.getOfficeById(loanDTO.getOfficeId().longValue());
        for (LoanTransactionDTO loanTransactionDTO : loanDTO.getNewLoanTransactions()) {
            LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
            this.helper.checkForBranchClosures(latestGLClosure, transactionDate);
            LoanTransactionEnumData transactionType = loanTransactionDTO.getTransactionType();
            if (transactionType.isDisbursement()) {
                this.createJournalEntriesForDisbursements(loanDTO, loanTransactionDTO, office);
            }
            if (transactionType.isAccrual() || transactionType.isAccrualAdjustment()) {
                this.createJournalEntriesForAccruals(loanDTO, loanTransactionDTO, office);
                continue;
            }
            if (transactionType.isRepaymentType() && !transactionType.isChargeAdjustment() || transactionType.isRepaymentAtDisbursement() || transactionType.isChargePayment()) {
                this.createJournalEntriesForRepaymentsAndWriteOffs(loanDTO, loanTransactionDTO, office, false, transactionType.isRepaymentAtDisbursement());
                continue;
            }
            if (transactionType.isRecoveryRepayment()) {
                this.createJournalEntriesForRecoveryRepayments(loanDTO, loanTransactionDTO, office);
                continue;
            }
            if (transactionType.isRefund()) {
                this.createJournalEntriesForRefund(loanDTO, loanTransactionDTO, office);
                continue;
            }
            if (transactionType.isCreditBalanceRefund()) {
                this.createJournalEntriesForCreditBalanceRefund(loanDTO, loanTransactionDTO, office);
                continue;
            }
            if (transactionType.isWriteOff() || transactionType.isWaiveInterest() || transactionType.isWaiveCharges()) {
                this.createJournalEntriesForRepaymentsAndWriteOffs(loanDTO, loanTransactionDTO, office, true, false);
                continue;
            }
            if (transactionType.isRefundForActiveLoans()) {
                this.createJournalEntriesForRefundForActiveLoan(loanDTO, loanTransactionDTO, office);
                continue;
            }
            if (transactionType.isChargeback()) {
                this.createJournalEntriesForChargeback(loanDTO, loanTransactionDTO, office);
                continue;
            }
            if (transactionType.isChargeAdjustment()) {
                this.createJournalEntriesForChargeAdjustment(loanDTO, loanTransactionDTO, office);
                continue;
            }
            if (transactionType.isChargeoff()) {
                this.createJournalEntriesForChargeOff(loanDTO, loanTransactionDTO, office);
                continue;
            }
            if (!transactionType.isInterestPaymentWaiver() && !transactionType.isInterestRefund()) continue;
            this.createJournalEntriesForInterestPaymentWaiverOrInterestRefund(loanDTO, loanTransactionDTO, office);
        }
    }

    private void createJournalEntriesForInterestPaymentWaiverOrInterestRefund(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        GLAccount glAccount;
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        boolean isMarkedAsChargeOff = loanDTO.isMarkedAsChargeOff();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal principalAmount = loanTransactionDTO.getPrincipal();
        BigDecimal interestAmount = loanTransactionDTO.getInterest();
        BigDecimal feesAmount = loanTransactionDTO.getFees();
        BigDecimal penaltiesAmount = loanTransactionDTO.getPenalties();
        BigDecimal overPayment = loanTransactionDTO.getOverPayment();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        boolean isReversal = loanTransactionDTO.isReversed();
        GLAccountBalanceHolder glAccountBalanceHolder = new GLAccountBalanceHolder();
        if (isMarkedAsChargeOff) {
            if (principalAmount != null && principalAmount.compareTo(BigDecimal.ZERO) > 0) {
                this.populateCreditDebitMaps(loanProductId, principalAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CHARGE_OFF_INTEREST.getValue(), AccountingConstants.AccrualAccountsForLoan.INTEREST_ON_LOANS.getValue(), glAccountBalanceHolder);
            }
            if (interestAmount != null && interestAmount.compareTo(BigDecimal.ZERO) > 0) {
                this.populateCreditDebitMaps(loanProductId, interestAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CHARGE_OFF_INTEREST.getValue(), AccountingConstants.AccrualAccountsForLoan.INTEREST_ON_LOANS.getValue(), glAccountBalanceHolder);
            }
            if (feesAmount != null && feesAmount.compareTo(BigDecimal.ZERO) > 0) {
                this.populateCreditDebitMaps(loanProductId, feesAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CHARGE_OFF_INTEREST.getValue(), AccountingConstants.AccrualAccountsForLoan.INTEREST_ON_LOANS.getValue(), glAccountBalanceHolder);
            }
            if (penaltiesAmount != null && penaltiesAmount.compareTo(BigDecimal.ZERO) > 0) {
                this.populateCreditDebitMaps(loanProductId, penaltiesAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CHARGE_OFF_INTEREST.getValue(), AccountingConstants.AccrualAccountsForLoan.INTEREST_ON_LOANS.getValue(), glAccountBalanceHolder);
            }
            if (overPayment != null && overPayment.compareTo(BigDecimal.ZERO) > 0) {
                this.populateCreditDebitMaps(loanProductId, overPayment, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.OVERPAYMENT.getValue(), AccountingConstants.AccrualAccountsForLoan.INTEREST_ON_LOANS.getValue(), glAccountBalanceHolder);
            }
        } else {
            if (principalAmount != null && principalAmount.compareTo(BigDecimal.ZERO) > 0) {
                this.populateCreditDebitMaps(loanProductId, principalAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.LOAN_PORTFOLIO.getValue(), AccountingConstants.AccrualAccountsForLoan.INTEREST_ON_LOANS.getValue(), glAccountBalanceHolder);
            }
            if (interestAmount != null && interestAmount.compareTo(BigDecimal.ZERO) > 0) {
                this.populateCreditDebitMaps(loanProductId, interestAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INTEREST_RECEIVABLE.getValue(), AccountingConstants.AccrualAccountsForLoan.INTEREST_ON_LOANS.getValue(), glAccountBalanceHolder);
            }
            if (feesAmount != null && feesAmount.compareTo(BigDecimal.ZERO) > 0) {
                this.populateCreditDebitMaps(loanProductId, feesAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.FEES_RECEIVABLE.getValue(), AccountingConstants.AccrualAccountsForLoan.INTEREST_ON_LOANS.getValue(), glAccountBalanceHolder);
            }
            if (penaltiesAmount != null && penaltiesAmount.compareTo(BigDecimal.ZERO) > 0) {
                this.populateCreditDebitMaps(loanProductId, penaltiesAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.PENALTIES_RECEIVABLE.getValue(), AccountingConstants.AccrualAccountsForLoan.INTEREST_ON_LOANS.getValue(), glAccountBalanceHolder);
            }
            if (overPayment != null && overPayment.compareTo(BigDecimal.ZERO) > 0) {
                this.populateCreditDebitMaps(loanProductId, overPayment, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.OVERPAYMENT.getValue(), AccountingConstants.AccrualAccountsForLoan.INTEREST_ON_LOANS.getValue(), glAccountBalanceHolder);
            }
        }
        for (Map.Entry creditEntry : glAccountBalanceHolder.getCreditBalances().entrySet()) {
            glAccount = (GLAccount)glAccountBalanceHolder.getGlAccountMap().get(creditEntry.getKey());
            this.helper.createCreditJournalEntryOrReversalForLoan(office, currencyCode, loanId, transactionId, transactionDate, (BigDecimal)creditEntry.getValue(), Boolean.valueOf(isReversal), glAccount);
        }
        for (Map.Entry debitEntry : glAccountBalanceHolder.getDebitBalances().entrySet()) {
            glAccount = (GLAccount)glAccountBalanceHolder.getGlAccountMap().get(debitEntry.getKey());
            this.helper.createDebitJournalEntryOrReversalForLoan(office, currencyCode, loanId, transactionId, transactionDate, (BigDecimal)debitEntry.getValue(), Boolean.valueOf(isReversal), glAccount);
        }
    }

    private void createJournalEntriesForChargeOff(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        GLAccount glAccount;
        ProductToGLAccountMapping mapping;
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        boolean isMarkedFraud = loanDTO.isMarkedAsFraud();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal principalAmount = loanTransactionDTO.getPrincipal();
        BigDecimal interestAmount = loanTransactionDTO.getInterest();
        BigDecimal feesAmount = loanTransactionDTO.getFees();
        BigDecimal penaltiesAmount = loanTransactionDTO.getPenalties();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        boolean isReversal = loanTransactionDTO.isReversed();
        GLAccountBalanceHolder glAccountBalanceHolder = new GLAccountBalanceHolder();
        Long chargeOffReasonCodeValue = loanDTO.getChargeOffReasonCodeValue();
        ProductToGLAccountMapping productToGLAccountMapping = mapping = chargeOffReasonCodeValue != null ? this.helper.getChargeOffMappingByCodeValue(loanProductId, PortfolioProductType.LOAN, chargeOffReasonCodeValue) : null;
        if (mapping != null) {
            GLAccount accountCredit = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.LOAN_PORTFOLIO.getValue().intValue(), paymentTypeId);
            glAccountBalanceHolder.addToCredit(accountCredit, principalAmount);
            glAccountBalanceHolder.addToDebit(mapping.getGlAccount(), principalAmount);
        } else if (principalAmount != null && principalAmount.compareTo(BigDecimal.ZERO) > 0) {
            if (isMarkedFraud) {
                this.populateCreditDebitMaps(loanProductId, principalAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.LOAN_PORTFOLIO.getValue(), AccountingConstants.AccrualAccountsForLoan.CHARGE_OFF_FRAUD_EXPENSE.getValue(), glAccountBalanceHolder);
            } else {
                this.populateCreditDebitMaps(loanProductId, principalAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.LOAN_PORTFOLIO.getValue(), AccountingConstants.AccrualAccountsForLoan.CHARGE_OFF_EXPENSE.getValue(), glAccountBalanceHolder);
            }
        }
        if (interestAmount != null && interestAmount.compareTo(BigDecimal.ZERO) > 0) {
            this.populateCreditDebitMaps(loanProductId, interestAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INTEREST_RECEIVABLE.getValue(), AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CHARGE_OFF_INTEREST.getValue(), glAccountBalanceHolder);
        }
        if (feesAmount != null && feesAmount.compareTo(BigDecimal.ZERO) > 0) {
            this.populateCreditDebitMaps(loanProductId, feesAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.FEES_RECEIVABLE.getValue(), AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CHARGE_OFF_FEES.getValue(), glAccountBalanceHolder);
        }
        if (penaltiesAmount != null && penaltiesAmount.compareTo(BigDecimal.ZERO) > 0) {
            this.populateCreditDebitMaps(loanProductId, penaltiesAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.PENALTIES_RECEIVABLE.getValue(), AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CHARGE_OFF_PENALTY.getValue(), glAccountBalanceHolder);
        }
        for (Map.Entry creditEntry : glAccountBalanceHolder.getCreditBalances().entrySet()) {
            glAccount = (GLAccount)glAccountBalanceHolder.getGlAccountMap().get(creditEntry.getKey());
            this.helper.createCreditJournalEntryOrReversalForLoan(office, currencyCode, loanId, transactionId, transactionDate, (BigDecimal)creditEntry.getValue(), Boolean.valueOf(isReversal), glAccount);
        }
        for (Map.Entry debitEntry : glAccountBalanceHolder.getDebitBalances().entrySet()) {
            glAccount = (GLAccount)glAccountBalanceHolder.getGlAccountMap().get(debitEntry.getKey());
            this.helper.createDebitJournalEntryOrReversalForLoan(office, currencyCode, loanId, transactionId, transactionDate, (BigDecimal)debitEntry.getValue(), Boolean.valueOf(isReversal), glAccount);
        }
    }

    private void populateCreditDebitMaps(Long loanProductId, BigDecimal transactionPartAmount, Long paymentTypeId, Integer creditAccountType, Integer debitAccountType, GLAccountBalanceHolder glAccountBalanceHolder) {
        GLAccount accountCredit = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, creditAccountType.intValue(), paymentTypeId);
        glAccountBalanceHolder.addToCredit(accountCredit, transactionPartAmount);
        GLAccount accountDebit = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, debitAccountType.intValue(), paymentTypeId);
        glAccountBalanceHolder.addToDebit(accountDebit, transactionPartAmount);
    }

    private void createJournalEntriesForChargeAdjustment(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        boolean isMarkedAsChargeOff = loanDTO.isMarkedAsChargeOff();
        if (isMarkedAsChargeOff) {
            this.createJournalEntriesForChargeOffLoanChargeAdjustment(loanDTO, loanTransactionDTO, office);
        } else {
            this.createJournalEntriesForLoanChargeAdjustment(loanDTO, loanTransactionDTO, office);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createJournalEntriesForChargeOffLoanChargeAdjustment(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        GLAccount account;
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal principalAmount = loanTransactionDTO.getPrincipal();
        BigDecimal interestAmount = loanTransactionDTO.getInterest();
        BigDecimal feesAmount = loanTransactionDTO.getFees();
        BigDecimal penaltiesAmount = loanTransactionDTO.getPenalties();
        BigDecimal overPaymentAmount = loanTransactionDTO.getOverPayment();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        boolean isReversal = loanTransactionDTO.isReversed();
        BigDecimal totalDebitAmount = new BigDecimal(0);
        LinkedHashMap<GLAccount, BigDecimal> accountMap = new LinkedHashMap<GLAccount, BigDecimal>();
        if (principalAmount != null && principalAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(principalAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CHARGE_OFF_FEES.getValue().intValue(), paymentTypeId);
            accountMap.put(account, principalAmount);
        }
        if (interestAmount != null && interestAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(interestAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CHARGE_OFF_FEES.getValue().intValue(), paymentTypeId);
            if (accountMap.containsKey(account)) {
                BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(interestAmount);
                accountMap.put(account, bigDecimal);
            } else {
                accountMap.put(account, interestAmount);
            }
        }
        if (feesAmount != null && feesAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(feesAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CHARGE_OFF_FEES.getValue().intValue(), paymentTypeId);
            if (accountMap.containsKey(account)) {
                BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(feesAmount);
                accountMap.put(account, bigDecimal);
            } else {
                accountMap.put(account, feesAmount);
            }
        }
        if (penaltiesAmount != null && penaltiesAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(penaltiesAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CHARGE_OFF_PENALTY.getValue().intValue(), paymentTypeId);
            if (accountMap.containsKey(account)) {
                BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(penaltiesAmount);
                accountMap.put(account, bigDecimal);
            } else {
                accountMap.put(account, penaltiesAmount);
            }
        }
        if (overPaymentAmount != null && overPaymentAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(overPaymentAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.OVERPAYMENT.getValue().intValue(), paymentTypeId);
            if (accountMap.containsKey(account)) {
                BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(overPaymentAmount);
                accountMap.put(account, bigDecimal);
            } else {
                accountMap.put(account, overPaymentAmount);
            }
        }
        for (Map.Entry entry : accountMap.entrySet()) {
            this.helper.createCreditJournalEntryOrReversalForLoan(office, currencyCode, loanId, transactionId, transactionDate, (BigDecimal)entry.getValue(), Boolean.valueOf(isReversal), (GLAccount)entry.getKey());
        }
        if (totalDebitAmount.compareTo(BigDecimal.ZERO) > 0) {
            void var19_30;
            Long chargeId = loanTransactionDTO.getLoanChargeData().getChargeId();
            if (loanTransactionDTO.getLoanChargeData().isPenalty()) {
                Integer n = AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_PENALTIES.getValue();
            } else {
                Integer n = AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_FEES.getValue();
            }
            this.helper.createDebitJournalEntryOrReversalForLoanCharges(office, currencyCode, var19_30.intValue(), loanProductId, chargeId, loanId, transactionId, transactionDate, totalDebitAmount, Boolean.valueOf(isReversal));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createJournalEntriesForLoanChargeAdjustment(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        GLAccount account;
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal principalAmount = loanTransactionDTO.getPrincipal();
        BigDecimal interestAmount = loanTransactionDTO.getInterest();
        BigDecimal feesAmount = loanTransactionDTO.getFees();
        BigDecimal penaltiesAmount = loanTransactionDTO.getPenalties();
        BigDecimal overPaymentAmount = loanTransactionDTO.getOverPayment();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        boolean isReversal = loanTransactionDTO.isReversed();
        BigDecimal totalDebitAmount = new BigDecimal(0);
        LinkedHashMap<GLAccount, BigDecimal> accountMap = new LinkedHashMap<GLAccount, BigDecimal>();
        if (principalAmount != null && principalAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(principalAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.LOAN_PORTFOLIO.getValue().intValue(), paymentTypeId);
            accountMap.put(account, principalAmount);
        }
        if (interestAmount != null && interestAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(interestAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.INTEREST_RECEIVABLE.getValue().intValue(), paymentTypeId);
            if (accountMap.containsKey(account)) {
                BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(interestAmount);
                accountMap.put(account, bigDecimal);
            } else {
                accountMap.put(account, interestAmount);
            }
        }
        if (feesAmount != null && feesAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(feesAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.FEES_RECEIVABLE.getValue().intValue(), paymentTypeId);
            if (accountMap.containsKey(account)) {
                BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(feesAmount);
                accountMap.put(account, bigDecimal);
            } else {
                accountMap.put(account, feesAmount);
            }
        }
        if (penaltiesAmount != null && penaltiesAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(penaltiesAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.PENALTIES_RECEIVABLE.getValue().intValue(), paymentTypeId);
            if (accountMap.containsKey(account)) {
                BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(penaltiesAmount);
                accountMap.put(account, bigDecimal);
            } else {
                accountMap.put(account, penaltiesAmount);
            }
        }
        if (overPaymentAmount != null && overPaymentAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(overPaymentAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.OVERPAYMENT.getValue().intValue(), paymentTypeId);
            if (accountMap.containsKey(account)) {
                BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(overPaymentAmount);
                accountMap.put(account, bigDecimal);
            } else {
                accountMap.put(account, overPaymentAmount);
            }
        }
        for (Map.Entry entry : accountMap.entrySet()) {
            this.helper.createCreditJournalEntryOrReversalForLoan(office, currencyCode, loanId, transactionId, transactionDate, (BigDecimal)entry.getValue(), Boolean.valueOf(isReversal), (GLAccount)entry.getKey());
        }
        if (totalDebitAmount.compareTo(BigDecimal.ZERO) > 0) {
            void var19_30;
            Long chargeId = loanTransactionDTO.getLoanChargeData().getChargeId();
            if (loanTransactionDTO.getLoanChargeData().isPenalty()) {
                Integer n = AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_PENALTIES.getValue();
            } else {
                Integer n = AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_FEES.getValue();
            }
            this.helper.createDebitJournalEntryOrReversalForLoanCharges(office, currencyCode, var19_30.intValue(), loanProductId, chargeId, loanId, transactionId, transactionDate, totalDebitAmount, Boolean.valueOf(isReversal));
        }
    }

    private void createJournalEntriesForChargeback(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal amount = loanTransactionDTO.getAmount();
        boolean isReversal = loanTransactionDTO.isReversed();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        BigDecimal overpaidAmount = Objects.isNull(loanTransactionDTO.getOverPayment()) ? BigDecimal.ZERO : loanTransactionDTO.getOverPayment();
        BigDecimal principalCredited = Objects.isNull(loanTransactionDTO.getPrincipal()) ? BigDecimal.ZERO : loanTransactionDTO.getPrincipal();
        BigDecimal feeCredited = Objects.isNull(loanTransactionDTO.getFees()) ? BigDecimal.ZERO : loanTransactionDTO.getFees();
        BigDecimal penaltyCredited = Objects.isNull(loanTransactionDTO.getPenalties()) ? BigDecimal.ZERO : loanTransactionDTO.getPenalties();
        BigDecimal principalPaid = Objects.isNull(loanTransactionDTO.getPrincipalPaid()) ? BigDecimal.ZERO : loanTransactionDTO.getPrincipalPaid();
        BigDecimal feePaid = Objects.isNull(loanTransactionDTO.getFeePaid()) ? BigDecimal.ZERO : loanTransactionDTO.getFeePaid();
        BigDecimal penaltyPaid = Objects.isNull(loanTransactionDTO.getPenaltyPaid()) ? BigDecimal.ZERO : loanTransactionDTO.getPenaltyPaid();
        this.helper.createCreditJournalEntryOrReversalForLoan(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE, loanProductId, paymentTypeId, loanId, transactionId, transactionDate, amount, Boolean.valueOf(isReversal));
        if (overpaidAmount.compareTo(BigDecimal.ZERO) > 0) {
            this.helper.createDebitJournalEntryOrReversalForLoan(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.OVERPAYMENT.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, overpaidAmount, Boolean.valueOf(isReversal));
        }
        if (principalCredited.compareTo(principalPaid) > 0) {
            this.helper.createDebitJournalEntryOrReversalForLoan(office, currencyCode, this.getPrincipalAccount(loanDTO).intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, principalCredited.subtract(principalPaid), Boolean.valueOf(isReversal));
        } else if (principalCredited.compareTo(principalPaid) < 0) {
            this.helper.createCreditJournalEntryOrReversalForLoan(office, currencyCode, this.getPrincipalAccount(loanDTO).intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, principalPaid.subtract(principalCredited), Boolean.valueOf(isReversal));
        }
        if (feeCredited.compareTo(feePaid) > 0) {
            this.helper.createDebitJournalEntryOrReversalForLoan(office, currencyCode, this.getFeeAccount(loanDTO).intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, feeCredited.subtract(feePaid), Boolean.valueOf(isReversal));
        } else if (feeCredited.compareTo(feePaid) < 0) {
            this.helper.createCreditJournalEntryOrReversalForLoan(office, currencyCode, this.getFeeAccount(loanDTO).intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, feePaid.subtract(feeCredited), Boolean.valueOf(isReversal));
        }
        if (penaltyCredited.compareTo(penaltyPaid) > 0) {
            this.helper.createDebitJournalEntryOrReversalForLoan(office, currencyCode, this.getPenaltyAccount(loanDTO).intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, penaltyCredited.subtract(penaltyPaid), Boolean.valueOf(isReversal));
        } else if (penaltyCredited.compareTo(penaltyPaid) < 0) {
            this.helper.createCreditJournalEntryOrReversalForLoan(office, currencyCode, this.getPenaltyAccount(loanDTO).intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, penaltyPaid.subtract(penaltyCredited), Boolean.valueOf(isReversal));
        }
    }

    private Integer getFeeAccount(LoanDTO loanDTO) {
        Integer account = AccountingConstants.AccrualAccountsForLoan.FEES_RECEIVABLE.getValue();
        if (loanDTO.isMarkedAsChargeOff()) {
            account = AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CHARGE_OFF_FEES.getValue();
        }
        return account;
    }

    private Integer getPenaltyAccount(LoanDTO loanDTO) {
        Integer account = AccountingConstants.AccrualAccountsForLoan.PENALTIES_RECEIVABLE.getValue();
        if (loanDTO.isMarkedAsChargeOff()) {
            account = AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CHARGE_OFF_PENALTY.getValue();
        }
        return account;
    }

    private Integer getPrincipalAccount(LoanDTO loanDTO) {
        if (loanDTO.isMarkedAsFraud() && loanDTO.isMarkedAsChargeOff()) {
            return AccountingConstants.AccrualAccountsForLoan.CHARGE_OFF_FRAUD_EXPENSE.getValue();
        }
        if (!loanDTO.isMarkedAsFraud() && loanDTO.isMarkedAsChargeOff()) {
            return AccountingConstants.AccrualAccountsForLoan.CHARGE_OFF_EXPENSE.getValue();
        }
        return AccountingConstants.AccrualAccountsForLoan.LOAN_PORTFOLIO.getValue();
    }

    private void createJournalEntriesForDisbursements(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal overpaymentPortion = loanTransactionDTO.getOverPayment() != null ? loanTransactionDTO.getOverPayment() : BigDecimal.ZERO;
        BigDecimal principalPortion = loanTransactionDTO.getAmount().subtract(overpaymentPortion);
        boolean isReversed = loanTransactionDTO.isReversed();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        if (MathUtil.isGreaterThanZero((BigDecimal)principalPortion)) {
            this.helper.createDebitJournalEntryOrReversalForLoan(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.LOAN_PORTFOLIO.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, principalPortion, Boolean.valueOf(isReversed));
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)overpaymentPortion)) {
            this.helper.createDebitJournalEntryOrReversalForLoan(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.OVERPAYMENT.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, overpaymentPortion, Boolean.valueOf(isReversed));
        }
        if (loanTransactionDTO.isLoanToLoanTransfer()) {
            this.helper.createCreditJournalEntryOrReversalForLoan(office, currencyCode, AccountingConstants.FinancialActivity.ASSET_TRANSFER.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, loanTransactionDTO.getAmount(), Boolean.valueOf(isReversed));
        } else if (loanTransactionDTO.isAccountTransfer()) {
            this.helper.createCreditJournalEntryOrReversalForLoan(office, currencyCode, AccountingConstants.FinancialActivity.LIABILITY_TRANSFER.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, loanTransactionDTO.getAmount(), Boolean.valueOf(isReversed));
        } else {
            this.helper.createCreditJournalEntryOrReversalForLoan(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, loanTransactionDTO.getAmount(), Boolean.valueOf(isReversed));
        }
    }

    private void createJournalEntriesForRepaymentsAndWriteOffs(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office, boolean writeOff, boolean isIncomeFromFee) {
        boolean isMarkedChargeOff = loanDTO.isMarkedAsChargeOff();
        if (isMarkedChargeOff) {
            this.createJournalEntriesForChargeOffLoanRepaymentAndWriteOffs(loanDTO, loanTransactionDTO, office, writeOff, isIncomeFromFee);
        } else {
            this.createJournalEntriesForLoansRepaymentAndWriteOffs(loanDTO, loanTransactionDTO, office, writeOff, isIncomeFromFee);
        }
    }

    private void createJournalEntriesForChargeOffLoanRepaymentAndWriteOffs(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office, boolean writeOff, boolean isIncomeFromFee) {
        GLAccount glAccount;
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        boolean isMarkedFraud = loanDTO.isMarkedAsFraud();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal principalAmount = loanTransactionDTO.getPrincipal();
        BigDecimal interestAmount = loanTransactionDTO.getInterest();
        BigDecimal feesAmount = loanTransactionDTO.getFees();
        BigDecimal penaltiesAmount = loanTransactionDTO.getPenalties();
        BigDecimal overPaymentAmount = loanTransactionDTO.getOverPayment();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        boolean isReversal = loanTransactionDTO.isReversed();
        GLAccountBalanceHolder glAccountBalanceHolder = new GLAccountBalanceHolder();
        BigDecimal totalDebitAmount = new BigDecimal(0);
        if (principalAmount != null && principalAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(principalAmount);
            if (loanTransactionDTO.getTransactionType().isMerchantIssuedRefund()) {
                if (isMarkedFraud) {
                    this.populateCreditDebitMaps(loanProductId, principalAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.CHARGE_OFF_FRAUD_EXPENSE.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
                } else {
                    this.populateCreditDebitMaps(loanProductId, principalAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.CHARGE_OFF_EXPENSE.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
                }
            } else if (loanTransactionDTO.getTransactionType().isPayoutRefund()) {
                if (isMarkedFraud) {
                    this.populateCreditDebitMaps(loanProductId, principalAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.CHARGE_OFF_FRAUD_EXPENSE.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
                } else {
                    this.populateCreditDebitMaps(loanProductId, principalAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.CHARGE_OFF_EXPENSE.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
                }
            } else if (loanTransactionDTO.getTransactionType().isGoodwillCredit()) {
                this.populateCreditDebitMaps(loanProductId, principalAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_RECOVERY.getValue(), AccountingConstants.AccrualAccountsForLoan.GOODWILL_CREDIT.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isRepayment()) {
                this.populateCreditDebitMaps(loanProductId, principalAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_RECOVERY.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else {
                this.populateCreditDebitMaps(loanProductId, principalAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.LOAN_PORTFOLIO.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            }
        }
        if (interestAmount != null && interestAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(interestAmount);
            if (loanTransactionDTO.getTransactionType().isMerchantIssuedRefund()) {
                this.populateCreditDebitMaps(loanProductId, interestAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CHARGE_OFF_INTEREST.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isPayoutRefund()) {
                this.populateCreditDebitMaps(loanProductId, interestAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CHARGE_OFF_INTEREST.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isGoodwillCredit()) {
                this.populateCreditDebitMaps(loanProductId, interestAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_RECOVERY.getValue(), AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_GOODWILL_CREDIT_INTEREST.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isRepayment()) {
                this.populateCreditDebitMaps(loanProductId, interestAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_RECOVERY.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else {
                this.populateCreditDebitMaps(loanProductId, interestAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INTEREST_RECEIVABLE.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            }
        }
        if (feesAmount != null && feesAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(feesAmount);
            if (loanTransactionDTO.getTransactionType().isMerchantIssuedRefund()) {
                this.populateCreditDebitMaps(loanProductId, feesAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CHARGE_OFF_FEES.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isPayoutRefund()) {
                this.populateCreditDebitMaps(loanProductId, feesAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CHARGE_OFF_FEES.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isGoodwillCredit()) {
                this.populateCreditDebitMaps(loanProductId, feesAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_RECOVERY.getValue(), AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_GOODWILL_CREDIT_FEES.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isRepayment()) {
                this.populateCreditDebitMaps(loanProductId, feesAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_RECOVERY.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else if (isIncomeFromFee) {
                this.helper.createCreditJournalEntryOrReversalForLoanCharges(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_FEES.getValue().intValue(), loanProductId, loanId, transactionId, transactionDate, feesAmount, Boolean.valueOf(isReversal), loanTransactionDTO.getFeePayments());
                GLAccount debitAccount = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue().intValue(), paymentTypeId);
                glAccountBalanceHolder.addToDebit(debitAccount, feesAmount);
            } else {
                this.populateCreditDebitMaps(loanProductId, feesAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.FEES_RECEIVABLE.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            }
        }
        if (penaltiesAmount != null && penaltiesAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(penaltiesAmount);
            if (loanTransactionDTO.getTransactionType().isMerchantIssuedRefund()) {
                this.populateCreditDebitMaps(loanProductId, penaltiesAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CHARGE_OFF_PENALTY.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isPayoutRefund()) {
                this.populateCreditDebitMaps(loanProductId, penaltiesAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_CHARGE_OFF_PENALTY.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isGoodwillCredit()) {
                this.populateCreditDebitMaps(loanProductId, penaltiesAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_RECOVERY.getValue(), AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_GOODWILL_CREDIT_PENALTY.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isRepayment()) {
                this.populateCreditDebitMaps(loanProductId, penaltiesAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_RECOVERY.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else if (isIncomeFromFee) {
                this.populateCreditDebitMaps(loanProductId, penaltiesAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_PENALTIES.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else {
                this.populateCreditDebitMaps(loanProductId, penaltiesAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.PENALTIES_RECEIVABLE.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            }
        }
        if (overPaymentAmount != null && overPaymentAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(overPaymentAmount);
            if (loanTransactionDTO.getTransactionType().isMerchantIssuedRefund()) {
                this.populateCreditDebitMaps(loanProductId, overPaymentAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.OVERPAYMENT.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isPayoutRefund()) {
                this.populateCreditDebitMaps(loanProductId, overPaymentAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.OVERPAYMENT.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isGoodwillCredit()) {
                this.populateCreditDebitMaps(loanProductId, overPaymentAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.OVERPAYMENT.getValue(), AccountingConstants.AccrualAccountsForLoan.GOODWILL_CREDIT.getValue(), glAccountBalanceHolder);
            } else {
                this.populateCreditDebitMaps(loanProductId, overPaymentAmount, paymentTypeId, AccountingConstants.AccrualAccountsForLoan.OVERPAYMENT.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            }
        }
        for (Map.Entry creditEntry : glAccountBalanceHolder.getCreditBalances().entrySet()) {
            glAccount = (GLAccount)glAccountBalanceHolder.getGlAccountMap().get(creditEntry.getKey());
            this.helper.createCreditJournalEntryOrReversalForLoan(office, currencyCode, loanId, transactionId, transactionDate, (BigDecimal)creditEntry.getValue(), Boolean.valueOf(isReversal), glAccount);
        }
        if (totalDebitAmount.compareTo(BigDecimal.ZERO) > 0) {
            if (writeOff) {
                this.helper.createDebitJournalEntryOrReversalForLoan(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.LOSSES_WRITTEN_OFF.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, totalDebitAmount, Boolean.valueOf(isReversal));
            } else if (loanTransactionDTO.isLoanToLoanTransfer()) {
                this.helper.createDebitJournalEntryOrReversalForLoan(office, currencyCode, AccountingConstants.FinancialActivity.ASSET_TRANSFER.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, totalDebitAmount, Boolean.valueOf(isReversal));
            } else if (loanTransactionDTO.isAccountTransfer()) {
                this.helper.createDebitJournalEntryOrReversalForLoan(office, currencyCode, AccountingConstants.FinancialActivity.LIABILITY_TRANSFER.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, totalDebitAmount, Boolean.valueOf(isReversal));
            } else {
                for (Map.Entry debitEntry : glAccountBalanceHolder.getDebitBalances().entrySet()) {
                    glAccount = (GLAccount)glAccountBalanceHolder.getGlAccountMap().get(debitEntry.getKey());
                    this.helper.createDebitJournalEntryOrReversalForLoan(office, currencyCode, loanId, transactionId, transactionDate, (BigDecimal)debitEntry.getValue(), Boolean.valueOf(isReversal), glAccount);
                }
            }
        }
        if (totalDebitAmount.compareTo(BigDecimal.ZERO) > 0 && loanTransactionDTO.getTransactionType().isChargeRefund()) {
            Integer incomeAccount = this.helper.getValueForFeeOrPenaltyIncomeAccount(loanTransactionDTO.getChargeRefundChargeType());
            this.helper.createJournalEntriesAndReversalsForLoan(office, currencyCode, incomeAccount, AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, totalDebitAmount, Boolean.valueOf(isReversal));
        }
    }

    private void createJournalEntriesForLoansRepaymentAndWriteOffs(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office, boolean writeOff, boolean isIncomeFromFee) {
        Object account;
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal principalAmount = loanTransactionDTO.getPrincipal();
        BigDecimal interestAmount = loanTransactionDTO.getInterest();
        BigDecimal feesAmount = loanTransactionDTO.getFees();
        BigDecimal penaltiesAmount = loanTransactionDTO.getPenalties();
        BigDecimal overPaymentAmount = loanTransactionDTO.getOverPayment();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        boolean isReversal = loanTransactionDTO.isReversed();
        BigDecimal totalDebitAmount = new BigDecimal(0);
        LinkedHashMap<Object, BigDecimal> accountMap = new LinkedHashMap<Object, BigDecimal>();
        LinkedHashMap debitAccountMapForGoodwillCredit = new LinkedHashMap();
        if (principalAmount != null && principalAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(principalAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.LOAN_PORTFOLIO.getValue().intValue(), paymentTypeId);
            accountMap.put(account, principalAmount);
            if (loanTransactionDTO.getTransactionType().isGoodwillCredit()) {
                this.populateDebitAccountEntry(loanProductId, principalAmount, AccountingConstants.AccrualAccountsForLoan.GOODWILL_CREDIT.getValue(), debitAccountMapForGoodwillCredit, paymentTypeId);
            }
        }
        if (interestAmount != null && interestAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(interestAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.INTEREST_RECEIVABLE.getValue().intValue(), paymentTypeId);
            if (accountMap.containsKey(account)) {
                BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(interestAmount);
                accountMap.put(account, bigDecimal);
            } else {
                accountMap.put(account, interestAmount);
            }
            if (loanTransactionDTO.getTransactionType().isGoodwillCredit()) {
                this.populateDebitAccountEntry(loanProductId, interestAmount, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_GOODWILL_CREDIT_INTEREST.getValue(), debitAccountMapForGoodwillCredit, paymentTypeId);
            }
        }
        if (feesAmount != null && feesAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(feesAmount);
            if (isIncomeFromFee) {
                this.helper.createCreditJournalEntryOrReversalForLoanCharges(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_FEES.getValue().intValue(), loanProductId, loanId, transactionId, transactionDate, feesAmount, Boolean.valueOf(isReversal), loanTransactionDTO.getFeePayments());
            } else {
                account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.FEES_RECEIVABLE.getValue().intValue(), paymentTypeId);
                if (accountMap.containsKey(account)) {
                    BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(feesAmount);
                    accountMap.put(account, bigDecimal);
                } else {
                    accountMap.put(account, feesAmount);
                }
            }
            if (loanTransactionDTO.getTransactionType().isGoodwillCredit()) {
                this.populateDebitAccountEntry(loanProductId, feesAmount, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_GOODWILL_CREDIT_FEES.getValue(), debitAccountMapForGoodwillCredit, paymentTypeId);
            }
        }
        if (penaltiesAmount != null && penaltiesAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(penaltiesAmount);
            if (isIncomeFromFee) {
                account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_PENALTIES.getValue().intValue(), paymentTypeId);
                if (accountMap.containsKey(account)) {
                    BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(penaltiesAmount);
                    accountMap.put(account, bigDecimal);
                } else {
                    accountMap.put(account, penaltiesAmount);
                }
            } else {
                account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.PENALTIES_RECEIVABLE.getValue().intValue(), paymentTypeId);
                if (accountMap.containsKey(account)) {
                    BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(penaltiesAmount);
                    accountMap.put(account, bigDecimal);
                } else {
                    accountMap.put(account, penaltiesAmount);
                }
            }
            if (loanTransactionDTO.getTransactionType().isGoodwillCredit()) {
                this.populateDebitAccountEntry(loanProductId, penaltiesAmount, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_GOODWILL_CREDIT_PENALTY.getValue(), debitAccountMapForGoodwillCredit, paymentTypeId);
            }
        }
        if (overPaymentAmount != null && overPaymentAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(overPaymentAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.AccrualAccountsForLoan.OVERPAYMENT.getValue().intValue(), paymentTypeId);
            if (accountMap.containsKey(account)) {
                BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(overPaymentAmount);
                accountMap.put(account, bigDecimal);
            } else {
                accountMap.put(account, overPaymentAmount);
            }
            if (loanTransactionDTO.getTransactionType().isGoodwillCredit()) {
                this.populateDebitAccountEntry(loanProductId, overPaymentAmount, AccountingConstants.AccrualAccountsForLoan.GOODWILL_CREDIT.getValue(), debitAccountMapForGoodwillCredit, paymentTypeId);
            }
        }
        for (Map.Entry entry : accountMap.entrySet()) {
            this.helper.createCreditJournalEntryOrReversalForLoan(office, currencyCode, loanId, transactionId, transactionDate, (BigDecimal)entry.getValue(), Boolean.valueOf(isReversal), (GLAccount)entry.getKey());
        }
        if (totalDebitAmount.compareTo(BigDecimal.ZERO) > 0) {
            if (writeOff) {
                this.helper.createDebitJournalEntryOrReversalForLoan(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.LOSSES_WRITTEN_OFF.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, totalDebitAmount, Boolean.valueOf(isReversal));
            } else if (loanTransactionDTO.isLoanToLoanTransfer()) {
                this.helper.createDebitJournalEntryOrReversalForLoan(office, currencyCode, AccountingConstants.FinancialActivity.ASSET_TRANSFER.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, totalDebitAmount, Boolean.valueOf(isReversal));
            } else if (loanTransactionDTO.isAccountTransfer()) {
                this.helper.createDebitJournalEntryOrReversalForLoan(office, currencyCode, AccountingConstants.FinancialActivity.LIABILITY_TRANSFER.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, totalDebitAmount, Boolean.valueOf(isReversal));
            } else if (loanTransactionDTO.getTransactionType().isGoodwillCredit()) {
                for (Map.Entry entry : debitAccountMapForGoodwillCredit.entrySet()) {
                    this.helper.createDebitJournalEntryOrReversalForLoan(office, currencyCode, ((Integer)entry.getKey()).intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, (BigDecimal)entry.getValue(), Boolean.valueOf(isReversal));
                }
            } else {
                this.helper.createDebitJournalEntryOrReversalForLoan(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, totalDebitAmount, Boolean.valueOf(isReversal));
            }
        }
        if (totalDebitAmount.compareTo(BigDecimal.ZERO) > 0 && loanTransactionDTO.getTransactionType().isChargeRefund()) {
            Integer incomeAccount = this.helper.getValueForFeeOrPenaltyIncomeAccount(loanTransactionDTO.getChargeRefundChargeType());
            this.helper.createJournalEntriesAndReversalsForLoan(office, currencyCode, incomeAccount, AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, totalDebitAmount, Boolean.valueOf(isReversal));
        }
    }

    private void populateDebitAccountEntry(Long loanProductId, BigDecimal transactionPartAmount, Integer debitAccountType, Map<Integer, BigDecimal> accountMapForDebit, Long paymentTypeId) {
        Integer accountDebit = this.returnExistingDebitAccountInMapMatchingGLAccount(loanProductId, paymentTypeId, debitAccountType, accountMapForDebit);
        if (accountMapForDebit.containsKey(accountDebit)) {
            BigDecimal amount = accountMapForDebit.get(accountDebit).add(transactionPartAmount);
            accountMapForDebit.put(accountDebit, amount);
        } else {
            accountMapForDebit.put(accountDebit, transactionPartAmount);
        }
    }

    private Integer returnExistingDebitAccountInMapMatchingGLAccount(Long loanProductId, Long paymentTypeId, Integer accountType, Map<Integer, BigDecimal> accountMap) {
        GLAccount glAccount = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, accountType.intValue(), paymentTypeId);
        Integer accountEntry = accountMap.entrySet().stream().filter(account -> this.helper.getLinkedGLAccountForLoanProduct(loanProductId, ((Integer)account.getKey()).intValue(), paymentTypeId).getGlCode().equals(glAccount.getGlCode())).map(Map.Entry::getKey).findFirst().orElse(accountType);
        return accountEntry;
    }

    private void createJournalEntriesForRecoveryRepayments(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal amount = loanTransactionDTO.getAmount();
        boolean isReversal = loanTransactionDTO.isReversed();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        this.helper.createJournalEntriesAndReversalsForLoan(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_RECOVERY.getValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, amount, Boolean.valueOf(isReversal));
    }

    private void createJournalEntriesForAccruals(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        LoanTransactionEnumData transactionType = loanTransactionDTO.getTransactionType();
        BigDecimal interestAmount = loanTransactionDTO.getInterest();
        BigDecimal feesAmount = loanTransactionDTO.getFees();
        BigDecimal penaltiesAmount = loanTransactionDTO.getPenalties();
        boolean isReversed = transactionType.isAccrualAdjustment() != loanTransactionDTO.isReversed();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        if (interestAmount != null && interestAmount.compareTo(BigDecimal.ZERO) > 0) {
            this.helper.createJournalEntriesAndReversalsForLoan(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.INTEREST_RECEIVABLE.getValue(), AccountingConstants.AccrualAccountsForLoan.INTEREST_ON_LOANS.getValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, interestAmount, Boolean.valueOf(isReversed));
        }
        if (feesAmount != null && feesAmount.compareTo(BigDecimal.ZERO) > 0) {
            this.helper.createJournalEntriesAndReversalsForLoanCharges(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.FEES_RECEIVABLE.getValue(), AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_FEES.getValue(), loanProductId, loanId, transactionId, transactionDate, feesAmount, Boolean.valueOf(isReversed), loanTransactionDTO.getFeePayments());
        }
        if (penaltiesAmount != null && penaltiesAmount.compareTo(BigDecimal.ZERO) > 0) {
            this.helper.createJournalEntriesAndReversalsForLoanCharges(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.PENALTIES_RECEIVABLE.getValue(), AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_PENALTIES.getValue(), loanProductId, loanId, transactionId, transactionDate, penaltiesAmount, Boolean.valueOf(isReversed), loanTransactionDTO.getPenaltyPayments());
        }
    }

    private void createJournalEntriesForRefund(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal refundAmount = loanTransactionDTO.getAmount();
        boolean isReversal = loanTransactionDTO.isReversed();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        if (loanTransactionDTO.isAccountTransfer()) {
            this.helper.createJournalEntriesAndReversalsForLoan(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.OVERPAYMENT.getValue(), AccountingConstants.FinancialActivity.LIABILITY_TRANSFER.getValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, refundAmount, Boolean.valueOf(isReversal));
        } else {
            this.helper.createJournalEntriesAndReversalsForLoan(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.OVERPAYMENT.getValue(), AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, refundAmount, Boolean.valueOf(isReversal));
        }
    }

    private void createJournalEntriesForCreditBalanceRefund(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        boolean isMarkedChargeOff = loanDTO.isMarkedAsChargeOff();
        this.createJournalEntriesForLoanCreditBalanceRefund(loanDTO, loanTransactionDTO, office, isMarkedChargeOff);
    }

    private void createJournalEntriesForLoanCreditBalanceRefund(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office, boolean isMarkedChargeOff) {
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        boolean isMarkedFraud = loanDTO.isMarkedAsFraud();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        boolean isReversal = loanTransactionDTO.isReversed();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        BigDecimal overpaymentAmount = loanTransactionDTO.getOverPayment();
        BigDecimal principalAmount = loanTransactionDTO.getPrincipal();
        BigDecimal totalAmount = BigDecimal.ZERO;
        ArrayList<JournalAmountHolder> journalAmountHolders = new ArrayList<JournalAmountHolder>();
        if (principalAmount != null && principalAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalAmount = totalAmount.add(principalAmount);
            journalAmountHolders.add(new JournalAmountHolder(this.determineAccrualAccountForCBR(isMarkedChargeOff, isMarkedFraud, false), principalAmount));
        }
        if (overpaymentAmount != null && overpaymentAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalAmount = totalAmount.add(overpaymentAmount);
            journalAmountHolders.add(new JournalAmountHolder(this.determineAccrualAccountForCBR(isMarkedChargeOff, isMarkedFraud, true), overpaymentAmount));
        }
        JournalAmountHolder totalAmountHolder = new JournalAmountHolder(AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue(), totalAmount);
        this.helper.createSplitJournalEntriesAndReversalsForLoan(office, currencyCode, journalAmountHolders, totalAmountHolder, loanProductId, paymentTypeId, loanId, transactionId, transactionDate, Boolean.valueOf(isReversal));
    }

    private Integer determineAccrualAccountForCBR(boolean isMarkedChargeOff, boolean isMarkedFraud, boolean isOverpayment) {
        if (isOverpayment) {
            return AccountingConstants.AccrualAccountsForLoan.OVERPAYMENT.getValue();
        }
        if (isMarkedChargeOff) {
            if (isMarkedFraud) {
                return AccountingConstants.AccrualAccountsForLoan.CHARGE_OFF_FRAUD_EXPENSE.getValue();
            }
            return AccountingConstants.AccrualAccountsForLoan.CHARGE_OFF_EXPENSE.getValue();
        }
        return AccountingConstants.AccrualAccountsForLoan.LOAN_PORTFOLIO.getValue();
    }

    private void createJournalEntriesForRefundForActiveLoan(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        ArrayList<ChargePaymentDTO> chargePaymentDTOs;
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal principalAmount = loanTransactionDTO.getPrincipal();
        BigDecimal interestAmount = loanTransactionDTO.getInterest();
        BigDecimal feesAmount = loanTransactionDTO.getFees();
        BigDecimal penaltiesAmount = loanTransactionDTO.getPenalties();
        BigDecimal overPaymentAmount = loanTransactionDTO.getOverPayment();
        boolean isReversal = loanTransactionDTO.isReversed();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        BigDecimal totalDebitAmount = new BigDecimal(0);
        if (principalAmount != null && principalAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(principalAmount);
            this.helper.createCreditJournalEntryOrReversalForLoan(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.LOAN_PORTFOLIO, loanProductId, paymentTypeId, loanId, transactionId, transactionDate, principalAmount, Boolean.valueOf(!isReversal));
        }
        if (interestAmount != null && interestAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(interestAmount);
            this.helper.createCreditJournalEntryOrReversalForLoan(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.INTEREST_ON_LOANS, loanProductId, paymentTypeId, loanId, transactionId, transactionDate, interestAmount, Boolean.valueOf(!isReversal));
        }
        if (feesAmount != null && feesAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(feesAmount);
            chargePaymentDTOs = new ArrayList<ChargePaymentDTO>();
            for (ChargePaymentDTO chargePaymentDTO : loanTransactionDTO.getFeePayments()) {
                chargePaymentDTOs.add(new ChargePaymentDTO(chargePaymentDTO.getChargeId(), chargePaymentDTO.getAmount().floatValue() < 0.0f ? chargePaymentDTO.getAmount().multiply(new BigDecimal(-1)) : chargePaymentDTO.getAmount(), chargePaymentDTO.getLoanChargeId()));
            }
            this.helper.createCreditJournalEntryOrReversalForLoanCharges(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_FEES.getValue().intValue(), loanProductId, loanId, transactionId, transactionDate, feesAmount, Boolean.valueOf(!isReversal), chargePaymentDTOs);
        }
        if (penaltiesAmount != null && penaltiesAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(penaltiesAmount);
            chargePaymentDTOs = new ArrayList();
            for (ChargePaymentDTO chargePaymentDTO : loanTransactionDTO.getPenaltyPayments()) {
                chargePaymentDTOs.add(new ChargePaymentDTO(chargePaymentDTO.getChargeId(), chargePaymentDTO.getAmount().floatValue() < 0.0f ? chargePaymentDTO.getAmount().multiply(new BigDecimal(-1)) : chargePaymentDTO.getAmount(), chargePaymentDTO.getLoanChargeId()));
            }
            this.helper.createCreditJournalEntryOrReversalForLoanCharges(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_PENALTIES.getValue().intValue(), loanProductId, loanId, transactionId, transactionDate, penaltiesAmount, Boolean.valueOf(!isReversal), chargePaymentDTOs);
        }
        if (overPaymentAmount != null && overPaymentAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(overPaymentAmount);
            this.helper.createCreditJournalEntryOrReversalForLoan(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.OVERPAYMENT, loanProductId, paymentTypeId, loanId, transactionId, transactionDate, overPaymentAmount, Boolean.valueOf(!isReversal));
        }
        this.helper.createDebitJournalEntryOrReversalForLoan(office, currencyCode, AccountingConstants.AccrualAccountsForLoan.FUND_SOURCE.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, totalDebitAmount, Boolean.valueOf(!isReversal));
    }

    @Generated
    public AccrualBasedAccountingProcessorForLoan(AccountingProcessorHelper helper) {
        this.helper = helper;
    }
}

