/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.useradmin.mongodb;

import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

final class MongoDB {
    private final List<ServerAddress> m_servers;
    private final String m_dbName;
    private final String m_collectionName;
    private final AtomicReference<Mongo> m_mongoRef;

    public MongoDB(String serverNames, String dbName, String collectionName) {
        if (serverNames == null || "".equals(serverNames.trim())) {
            throw new IllegalArgumentException("ServerNames cannot be null or empty!");
        }
        if (dbName == null || "".equals(dbName.trim())) {
            throw new IllegalArgumentException("DbName cannot be null or empty!");
        }
        if (collectionName == null || "".equals(collectionName.trim())) {
            throw new IllegalArgumentException("CollectionName cannot be null or empty!");
        }
        this.m_mongoRef = new AtomicReference();
        this.m_servers = MongoDB.parseServers(serverNames);
        this.m_dbName = dbName;
        this.m_collectionName = collectionName;
    }

    private static List<ServerAddress> parseServers(String serverNames) {
        String[] parts = serverNames.split("\\s+");
        ArrayList<ServerAddress> servers = new ArrayList<ServerAddress>();
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            try {
                int colonPos = part.indexOf(":");
                if (colonPos <= 0 || colonPos >= part.length() - 1) continue;
                String name = part.substring(0, colonPos);
                String portStr = part.substring(colonPos + 1);
                servers.add(new ServerAddress(name, Integer.valueOf(portStr).intValue()));
                continue;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Illegal port number in: " + part);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("Unknown host: " + part);
            }
        }
        if (servers.isEmpty()) {
            throw new IllegalArgumentException("No (valid) servers defined!");
        }
        return servers;
    }

    public boolean connect(String userName, String password) {
        Mongo oldMongo;
        Mongo newMongo = new Mongo(this.m_servers);
        while (!this.m_mongoRef.compareAndSet(oldMongo = this.m_mongoRef.get(), newMongo)) {
        }
        DB db = newMongo.getDB(this.m_dbName);
        return userName == null || password == null || db.authenticate(userName, password.toCharArray());
    }

    public DBCollection getCollection() {
        Mongo mongo = this.m_mongoRef.get();
        if (mongo == null) {
            throw new MongoException("Not connected to MongoDB!");
        }
        DB db = mongo.getDB(this.m_dbName);
        return db.getCollection(this.m_collectionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Mongo mongo = this.m_mongoRef.get();
        if (mongo != null) {
            try {
                mongo.close();
            }
            finally {
                this.m_mongoRef.compareAndSet(mongo, null);
            }
        }
    }
}

