/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.useradmin.filestore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.felix.useradmin.RoleFactory;
import org.apache.felix.useradmin.RoleRepositoryStore;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.useradmin.Role;

public class RoleRepositoryMemoryStore
implements RoleRepositoryStore {
    protected final ConcurrentMap m_entries = new ConcurrentHashMap();

    public Role addRole(String roleName, int type) {
        if (roleName == null) {
            throw new IllegalArgumentException("Name cannot be null!");
        }
        Role role = RoleFactory.createRole((int)type, (String)roleName);
        Role result = this.m_entries.putIfAbsent(roleName, role);
        return result == null ? role : null;
    }

    public Role[] getRoles(String filterValue) throws InvalidSyntaxException {
        Collection roles = this.m_entries.values();
        Filter filter = null;
        if (filterValue != null) {
            filter = FrameworkUtil.createFilter((String)filterValue);
        }
        ArrayList<Role> matchingRoles = new ArrayList<Role>();
        Iterator rolesIter = roles.iterator();
        while (rolesIter.hasNext()) {
            Role role = (Role)rolesIter.next();
            if (filter != null && !filter.match(role.getProperties())) continue;
            matchingRoles.add(role);
        }
        Role[] result = new Role[matchingRoles.size()];
        return matchingRoles.toArray(result);
    }

    public Role getRoleByName(String roleName) {
        if (roleName == null) {
            throw new IllegalArgumentException("Role name cannot be null!");
        }
        return (Role)this.m_entries.get(roleName);
    }

    public Role removeRole(String roleName) {
        if (roleName == null) {
            throw new IllegalArgumentException("Name cannot be null!");
        }
        Role role = this.getRoleByName(roleName);
        boolean result = this.m_entries.remove(roleName, role);
        return result ? role : null;
    }
}

