/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.upnp.tester.gui;

import java.util.Hashtable;
import javax.swing.event.TableModelEvent;
import org.apache.felix.upnp.tester.gui.ArgumentsModel;
import org.osgi.service.upnp.UPnPAction;
import org.osgi.service.upnp.UPnPStateVariable;

class OutputArgumentsModel
extends ArgumentsModel {
    public OutputArgumentsModel() {
        this.header = new String[]{"output arg name", "related Var", "Java \\ UpnP type", "value"};
    }

    public void clearData() {
        this.names = new String[]{""};
        this.related = new String[]{""};
        this.types = new String[]{""};
        this.values = new String[]{""};
        this.size = 0;
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void setData(UPnPAction action, Object result) {
        Hashtable res = (Hashtable)result;
        String[] names = action.getOutputArgumentNames();
        this.size = 0;
        this.names = names;
        if (names != null) {
            this.values = new String[names.length];
            this.types = new String[names.length];
            this.related = new String[names.length];
            for (int i = 0; i < names.length; ++i) {
                UPnPStateVariable currentStateVar = action.getStateVariable(names[i]);
                Object value = res.get(names[i]);
                this.values[i] = value.toString();
                this.related[i] = currentStateVar.getName();
                String javaType = currentStateVar.getJavaDataType().toString();
                javaType = javaType.substring(javaType.lastIndexOf(46) + 1);
                String upnpType = currentStateVar.getUPnPDataType();
                this.types[i] = javaType + " \\ " + upnpType;
            }
            this.size = names.length;
        }
        this.fireTableChanged(new TableModelEvent(this));
    }
}

