/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.upnp.basedriver.tool;

import java.io.PrintStream;
import org.apache.felix.upnp.basedriver.Activator;
import org.cybergarage.util.Debug;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class Logger
implements ServiceListener {
    private ServiceReference rls;
    private LogService osgiLogService;
    private int level;
    private PrintStream out = System.out;
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final String ROW = "\n================REQUEST=====================\n";
    public static final String END_ROW = "--------------------------------------------";
    private static final String[] LEVEL_TO_STRING = new String[]{"", "ERROR [ " + Activator.bc.getBundle().getBundleId() + " ] ", "WARNING [ " + Activator.bc.getBundle().getBundleId() + " ] ", "INFO [ " + Activator.bc.getBundle().getBundleId() + " ] ", "DEBUG [ " + Activator.bc.getBundle().getBundleId() + " ] "};
    static /* synthetic */ Class class$org$osgi$service$log$LogService;

    public Logger(String levelStr) {
        try {
            this.level = Integer.parseInt(levelStr);
        }
        catch (Exception ex) {
            this.out.println("WARNING [UPnPBaseDriver Log]: " + levelStr + " is not a valid value!");
            this.level = 2;
        }
        this.findService();
    }

    public void setCyberDebug(String value) {
        try {
            if (Boolean.valueOf(value).booleanValue()) {
                Debug.on();
                this.out.println("INFO [UPnPBaseDriver] Started CyberLink Debug");
            }
        }
        catch (Exception ex) {
            this.out.println("WARNING [UPnPBaseDriver CyberLog]: " + value + " is not a valid value!");
        }
    }

    public void setLogLevel(int level) {
        if (level < 0 || level > 4) {
            throw new IllegalArgumentException("Log Level must be [0-4]");
        }
        this.level = level;
    }

    public int getLogLevel() {
        return this.level;
    }

    public void setCyberDebug(boolean value) {
        if (value) {
            Debug.on();
        } else {
            Debug.off();
        }
    }

    public boolean getCyberDebug() {
        return Debug.isOn();
    }

    public final void ERROR(String message) {
        this.log(1, message);
    }

    public final void WARNING(String message) {
        this.log(2, message);
    }

    public final void INFO(String message) {
        this.log(3, message);
    }

    public final void DEBUG(String message) {
        this.log(4, message);
    }

    public final void PACKET(String message) {
        this.log(4, ROW + message + END_ROW);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(int msglevel, String message) {
        Logger logger = this;
        synchronized (logger) {
            if (msglevel <= this.level) {
                if (this.osgiLogService != null) {
                    this.osgiLogService.log(msglevel, message);
                } else {
                    StringBuffer sb = new StringBuffer(LEVEL_TO_STRING[msglevel]);
                    this.out.println(sb.append(message));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(int msglevel, String message, Throwable exception) {
        Logger logger = this;
        synchronized (logger) {
            if (msglevel <= this.level) {
                if (this.osgiLogService != null) {
                    this.osgiLogService.log(msglevel, message, exception);
                } else {
                    StringBuffer sb = new StringBuffer(LEVEL_TO_STRING[msglevel]);
                    this.out.println(sb.append(message).append(NEWLINE).append(exception));
                    exception.printStackTrace(this.out);
                }
            }
        }
    }

    private synchronized void setLogService(ServiceReference reference) {
        this.rls = reference;
        this.osgiLogService = (LogService)Activator.bc.getService(this.rls);
    }

    private synchronized void findService() {
        this.rls = Activator.bc.getServiceReference((class$org$osgi$service$log$LogService == null ? (class$org$osgi$service$log$LogService = Logger.class$("org.osgi.service.log.LogService")) : class$org$osgi$service$log$LogService).getName());
        if (this.rls != null) {
            this.osgiLogService = (LogService)Activator.bc.getService(this.rls);
        }
        try {
            Activator.bc.addServiceListener((ServiceListener)this, "(objectClass=" + (class$org$osgi$service$log$LogService == null ? (class$org$osgi$service$log$LogService = Logger.class$("org.osgi.service.log.LogService")) : class$org$osgi$service$log$LogService).getName() + ")");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
    }

    private synchronized void releaseLogService() {
        if (this.osgiLogService != null) {
            Activator.bc.ungetService(this.rls);
        }
        this.rls = null;
        this.osgiLogService = null;
    }

    public void serviceChanged(ServiceEvent e) {
        switch (e.getType()) {
            case 1: {
                this.setLogService(e.getServiceReference());
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                this.releaseLogService();
            }
        }
    }

    public void close() {
        Activator.bc.removeServiceListener((ServiceListener)this);
        this.releaseLogService();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

