/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.upnp.basedriver.importer.core.event.thread;

import org.apache.felix.upnp.basedriver.Activator;
import org.apache.felix.upnp.basedriver.importer.core.MyCtrlPoint;
import org.apache.felix.upnp.basedriver.importer.core.event.message.FirstMessage;
import org.apache.felix.upnp.basedriver.importer.core.event.message.ListenerModified;
import org.apache.felix.upnp.basedriver.importer.core.event.message.ListenerUnRegistration;
import org.apache.felix.upnp.basedriver.importer.core.event.message.SidExipired;
import org.apache.felix.upnp.basedriver.importer.core.event.structs.Monitor;
import org.apache.felix.upnp.basedriver.importer.core.event.structs.SubscriptionQueue;
import org.cybergarage.upnp.Service;

public class SubScriber
extends Thread {
    private MyCtrlPoint ctrl;
    private SubscriptionQueue subQueue;
    private boolean running = true;
    private Monitor monitor;

    public SubScriber(MyCtrlPoint ctrl, SubscriptionQueue subQueue, Monitor monitor) {
        super("upnp.basedriver.Subscriber");
        this.ctrl = ctrl;
        this.subQueue = subQueue;
        this.monitor = monitor;
    }

    public void run() {
        while (this.running) {
            Object msg = this.subQueue.dequeue();
            if (!this.running) continue;
            if (msg instanceof FirstMessage) {
                FirstMessage firstmsg = (FirstMessage)msg;
                Service service = firstmsg.getService();
                if (!service.isSubscribed()) {
                    boolean ok = this.ctrl.subscribe(service, 120000L);
                    String sid = "";
                    if (ok) {
                        sid = service.getSID();
                        firstmsg.setSid(sid);
                        this.monitor.addListener(sid, firstmsg.getListener());
                        continue;
                    }
                    Activator.logger.log(1, "Sucribe failed");
                    continue;
                }
                this.monitor.addListener(service.getSID(), firstmsg.getListener());
                continue;
            }
            if (msg instanceof ListenerModified) {
                this.monitor.updateListener((ListenerModified)msg, this.subQueue, this.ctrl);
                continue;
            }
            if (msg instanceof ListenerUnRegistration) {
                ListenerUnRegistration unreg = (ListenerUnRegistration)msg;
                this.monitor.delListener(unreg.getListener(), this.ctrl);
                continue;
            }
            if (!(msg instanceof SidExipired)) continue;
            Activator.logger.WARNING("[Importer] Please report the bug. Used code - should be checked and removed");
        }
    }

    public void close() {
        this.running = false;
        this.subQueue.close();
    }
}

