/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.upnp.basedriver.export;

import org.apache.felix.upnp.basedriver.Activator;
import org.apache.felix.upnp.basedriver.util.Converter;
import org.cybergarage.upnp.Action;
import org.cybergarage.upnp.AllowedValueList;
import org.cybergarage.upnp.AllowedValueRange;
import org.cybergarage.upnp.Argument;
import org.cybergarage.upnp.ArgumentList;
import org.cybergarage.upnp.Device;
import org.cybergarage.upnp.Service;
import org.cybergarage.upnp.StateVariable;
import org.cybergarage.upnp.xml.DeviceData;
import org.cybergarage.xml.Node;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.upnp.UPnPAction;
import org.osgi.service.upnp.UPnPDevice;
import org.osgi.service.upnp.UPnPService;
import org.osgi.service.upnp.UPnPStateVariable;

public class BuildDevice {
    static /* synthetic */ Class class$org$osgi$service$upnp$UPnPDevice;

    private static Node buildRootNode() {
        Node root = new Node("root");
        root.setAttribute("xmlns", "urn:schemas-upnp-org:device-1-0");
        Node spec = new Node("specVersion");
        Node maj = new Node("major");
        maj.setValue("1");
        Node min = new Node("minor");
        min.setValue("0");
        spec.addNode(maj);
        spec.addNode(min);
        root.addNode(spec);
        return root;
    }

    private static Device buildRootDeviceNode(Node root, ServiceReference sr) {
        Node dev = new Node("device");
        root.addNode(dev);
        DeviceData dd = new DeviceData();
        dd.setDescriptionURI("/gen-desc.xml");
        dev.setUserData(dd);
        Device devUPnP = new Device(root, dev);
        Object aux = sr.getProperty("UPnP.device.type");
        if (aux == null) {
            devUPnP.setDeviceType(null);
        } else if (aux instanceof String) {
            devUPnP.setDeviceType((String)aux);
        } else if (aux instanceof String[]) {
            String[] v = (String[])aux;
            int maxindex = 0;
            int max = Integer.parseInt(v[0].substring(v[0].lastIndexOf(":") + 1));
            for (int i = 1; i < v.length; ++i) {
                int tmp = Integer.parseInt(v[i].substring(v[i].lastIndexOf(":") + 1));
                if (max >= tmp) continue;
                max = tmp;
                maxindex = i;
            }
            devUPnP.setDeviceType(v[maxindex]);
        }
        devUPnP.setFriendlyName((String)sr.getProperty("UPnP.device.friendlyName"));
        devUPnP.setManufacture((String)sr.getProperty("UPnP.device.manufacturer"));
        devUPnP.setManufactureURL((String)sr.getProperty("UPnP.device.manufacturerURL"));
        devUPnP.setModelDescription((String)sr.getProperty("UPnP.device.modelDescription"));
        devUPnP.setModelName((String)sr.getProperty("UPnP.device.modelName"));
        devUPnP.setModelNumber((String)sr.getProperty("UPnP.device.modelNumber"));
        devUPnP.setModelURL((String)sr.getProperty("UPnP.device.modelURL"));
        devUPnP.setSerialNumber((String)sr.getProperty("UPnP.device.serialNumber"));
        devUPnP.setUDN((String)sr.getProperty("UPnP.device.UDN"));
        devUPnP.setUPC((String)sr.getProperty("UPnP.device.UPC"));
        devUPnP.setLocation("/gen-desc.xml");
        BuildDevice.addServices("", devUPnP, sr);
        BuildDevice.addDevices("", devUPnP, sr);
        devUPnP.setPresentationURL((String)sr.getProperty("UPnP.presentationURL"));
        return devUPnP;
    }

    private static void addDevices(String id, Device devUPnP, ServiceReference sr) {
        String[] udns = (String[])sr.getProperty("UPnP.device.childrenUDN");
        if (udns == null) {
            return;
        }
        for (int i = 0; i < udns.length; ++i) {
            try {
                ServiceReference[] aux = Activator.bc.getServiceReferences((class$org$osgi$service$upnp$UPnPDevice == null ? BuildDevice.class$("org.osgi.service.upnp.UPnPDevice") : class$org$osgi$service$upnp$UPnPDevice).getName(), "(UPnP.device.UDN=" + udns[i] + ")");
                if (aux == null || aux.length == 0) continue;
                String localId = id + "/device/" + i;
                BuildDevice.buildDevice(localId, devUPnP, aux[0]);
                continue;
            }
            catch (InvalidSyntaxException ignored) {
                // empty catch block
            }
        }
    }

    private static void buildDevice(String id, Device parent, ServiceReference sr) {
        Node dev = new Node("device");
        DeviceData dd = new DeviceData();
        dd.setDescriptionURI(id + "/gen-desc.xml");
        dev.setUserData(dd);
        Device devUPnP = new Device(dev);
        devUPnP.setFriendlyName((String)sr.getProperty("UPnP.device.friendlyName"));
        devUPnP.setManufacture((String)sr.getProperty("UPnP.device.manufacturer"));
        devUPnP.setManufactureURL((String)sr.getProperty("UPnP.device.manufacturerURL"));
        devUPnP.setModelDescription((String)sr.getProperty("UPnP.device.modelDescription"));
        devUPnP.setModelName((String)sr.getProperty("UPnP.device.modelName"));
        devUPnP.setModelNumber((String)sr.getProperty("UPnP.device.modelNumber"));
        devUPnP.setModelURL((String)sr.getProperty("UPnP.device.modelURL"));
        devUPnP.setSerialNumber((String)sr.getProperty("UPnP.device.serialNumber"));
        devUPnP.setUDN((String)sr.getProperty("UPnP.device.UDN"));
        devUPnP.setUPC((String)sr.getProperty("UPnP.device.UPC"));
        devUPnP.setLocation(id + "/gen-desc.xml");
        BuildDevice.addServices(id, devUPnP, sr);
        BuildDevice.addDevices(id, devUPnP, sr);
        parent.addDevice(devUPnP);
        devUPnP.setPresentationURL((String)sr.getProperty("UPnP.presentationURL"));
    }

    private static void addServices(String id, Device devUPnP, ServiceReference sr) {
        UPnPDevice devOSGi = (UPnPDevice)Activator.bc.getService(sr);
        if (devOSGi == null) {
            Activator.logger.WARNING("UPnP Device that cotains serviceId=" + id + " is deregistered from the framework while is exported");
            return;
        }
        UPnPService[] services = devOSGi.getServices();
        if (services == null || services.length == 0) {
            return;
        }
        for (int i = 0; i < services.length; ++i) {
            Service ser = new Service();
            devUPnP.addService(ser);
            ser.setServiceType(services[i].getType());
            ser.setServiceID(services[i].getId());
            ser.setSCPDURL(id + "/service/" + i + "/gen-desc.xml");
            ser.setDescriptionURL(id + "/service/" + i + "/gen-desc.xml");
            ser.setControlURL(id + "/service/" + i + "/ctrl");
            ser.setEventSubURL(id + "/service/" + i + "/event");
            UPnPAction[] actions = services[i].getActions();
            for (int j = 0; j < actions.length; ++j) {
                Argument a;
                UPnPStateVariable variable;
                int k;
                boolean valid = true;
                Action act = new Action(ser.getServiceNode());
                act.setName(actions[j].getName());
                ArgumentList al = new ArgumentList();
                String[] names = actions[j].getInputArgumentNames();
                if (names != null) {
                    for (k = 0; k < names.length; ++k) {
                        variable = actions[j].getStateVariable(names[k]);
                        if (variable == null) {
                            Activator.logger.WARNING("UPnP Device that cotains serviceId=" + id + " contains the action " + actions[j].getName() + " with the Input argument " + names[k] + " not related to any UPnPStateVariable. Thus this action won't be exported");
                            valid = false;
                            break;
                        }
                        a = new Argument();
                        a.setDirection("in");
                        a.setName(names[k]);
                        a.setRelatedStateVariableName(variable.getName());
                        al.add(a);
                    }
                }
                if ((names = actions[j].getOutputArgumentNames()) != null && valid) {
                    for (k = 0; k < names.length; ++k) {
                        variable = actions[j].getStateVariable(names[k]);
                        if (variable == null) {
                            Activator.logger.WARNING("UPnP Device that cotains serviceId=" + id + " contains the action " + actions[j].getName() + " with the Output argument " + names[k] + " not related to any UPnPStateVariable. Thus this action won't be exported");
                        }
                        a = new Argument();
                        a.setDirection("out");
                        a.setName(names[k]);
                        a.setRelatedStateVariableName(variable.getName());
                        al.add(a);
                    }
                }
                if (!valid) continue;
                act.setArgumentList(al);
                ser.addAction(act);
            }
            UPnPStateVariable[] vars = services[i].getStateVariables();
            for (int j = 0; j < vars.length; ++j) {
                StateVariable var = new StateVariable();
                var.setDataType(vars[j].getUPnPDataType());
                var.setName(vars[j].getName());
                var.setSendEvents(vars[j].sendsEvents());
                String[] values = vars[j].getAllowedValues();
                if (values != null) {
                    AllowedValueList avl = new AllowedValueList(values);
                    var.setAllowedValueList(avl);
                } else if (vars[j].getMaximum() != null) {
                    AllowedValueRange avr = new AllowedValueRange(vars[j].getMaximum(), vars[j].getMinimum(), vars[j].getStep());
                    var.setAllowedValueRange(avr);
                }
                if (vars[j].getDefaultValue() != null) {
                    try {
                        var.setDefaultValue(Converter.toString(vars[j].getDefaultValue(), vars[j].getUPnPDataType()));
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                }
                ser.addStateVariable(var);
            }
            Activator.bc.ungetService(sr);
        }
    }

    public static Device createCyberLinkDevice(ServiceReference sr) {
        Node root = BuildDevice.buildRootNode();
        Device devUPnP = BuildDevice.buildRootDeviceNode(root, sr);
        return devUPnP;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

