/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.feature.impl;

import java.util.Objects;
import java.util.Optional;
import org.osgi.service.feature.ID;

public class IDImpl
implements ID {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String type;
    private final String classifier;

    public static IDImpl fromMavenID(String mavenID) throws IllegalArgumentException {
        String[] parts = mavenID.split(":");
        if (mavenID.startsWith(":") || mavenID.endsWith(":") || mavenID.contains("::")) {
            throw new IllegalArgumentException("Not a valid maven ID" + mavenID);
        }
        if (parts.length < 3 || parts.length > 5) {
            throw new IllegalArgumentException("Not a valid maven ID" + mavenID);
        }
        String gid = parts[0];
        String aid = parts[1];
        String ver = null;
        String t = null;
        String c = null;
        if (parts.length == 3) {
            ver = parts[2];
        } else if (parts.length == 4) {
            t = parts[2];
            ver = parts[3];
        } else {
            t = parts[2];
            c = parts[3];
            ver = parts[4];
        }
        return new IDImpl(gid, aid, ver, t, c);
    }

    public IDImpl(String groupId, String artifactId, String version, String type, String classifier) throws NullPointerException, IllegalArgumentException {
        Objects.requireNonNull(groupId, "groupId");
        Objects.requireNonNull(artifactId, "artifact");
        Objects.requireNonNull(version, "version");
        if (groupId.isEmpty()) {
            throw new IllegalArgumentException("groupId must not be empty");
        }
        if (artifactId.isEmpty()) {
            throw new IllegalArgumentException("artifactId must not be empty");
        }
        if (version.isEmpty()) {
            throw new IllegalArgumentException("version must not be empty");
        }
        if (type != null && type.isEmpty()) {
            throw new IllegalArgumentException("type must not be empty");
        }
        if (classifier != null && classifier.isEmpty()) {
            throw new IllegalArgumentException("classifier must not be empty");
        }
        if (groupId.contains(":")) {
            throw new IllegalArgumentException("groupId must not contain a colon `:`");
        }
        if (artifactId.contains(":")) {
            throw new IllegalArgumentException("artifactId must not contain a colon `:`");
        }
        if (version.contains(":")) {
            throw new IllegalArgumentException("version must not contain a colon `:`");
        }
        if (type != null && type.contains(":")) {
            throw new IllegalArgumentException("type must not contain a colon `:`");
        }
        if (classifier != null && classifier.contains(":")) {
            throw new IllegalArgumentException("classifier must not contain a colon `:`");
        }
        if (type == null && classifier != null) {
            throw new IllegalArgumentException("type must not be `null` if a classifier is set");
        }
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.type = type;
        this.classifier = classifier;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public Optional<String> getType() {
        return Optional.ofNullable(this.type);
    }

    public Optional<String> getClassifier() {
        return Optional.ofNullable(this.classifier);
    }

    public int hashCode() {
        return Objects.hash(this.artifactId, this.classifier, this.groupId, this.type, this.version);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IDImpl)) {
            return false;
        }
        IDImpl other = (IDImpl)obj;
        return Objects.equals(this.artifactId, other.artifactId) && Objects.equals(this.classifier, other.classifier) && Objects.equals(this.groupId, other.groupId) && Objects.equals(this.type, other.type) && Objects.equals(this.version, other.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.groupId).append(":").append(this.artifactId);
        if (this.type != null) {
            sb = sb.append(":").append(this.type);
            if (this.classifier != null) {
                sb = sb.append(":").append(this.classifier);
            }
        }
        return sb.append(":").append(this.version).toString();
    }
}

